/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.CrossCutFilter;
import org.forgerock.json.resource.CrossCutFilterResultHandler;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.FilterCondition;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.UntypedCrossCutFilter;
import org.forgerock.json.resource.UpdateRequest;

public final class Filters {
    public static FilterCondition and(final Collection<FilterCondition> conditions) {
        return new FilterCondition(){

            @Override
            public boolean matches(ServerContext context, Request request) {
                for (FilterCondition condition : conditions) {
                    if (condition.matches(context, request)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static FilterCondition and(FilterCondition ... conditions) {
        return Filters.and(Arrays.asList(conditions));
    }

    public static Filter asFilter(CrossCutFilter<?> crossCutFilter) {
        return Filters.asFilter0(crossCutFilter);
    }

    public static Filter asFilter(UntypedCrossCutFilter<?> crossCutFilter) {
        return Filters.asFilter0(crossCutFilter);
    }

    public static Filter conditionalFilter(FilterCondition condition, Filter subFilter) {
        return new ConditionalFilter(condition, subFilter);
    }

    public static FilterCondition matchRequestType(RequestType ... types) {
        return Filters.matchRequestType(EnumSet.copyOf(Arrays.asList(types)));
    }

    public static FilterCondition matchRequestType(final Set<RequestType> types) {
        return new FilterCondition(){

            @Override
            public boolean matches(ServerContext context, Request request) {
                return types.contains((Object)request.getRequestType());
            }
        };
    }

    public static FilterCondition matchResourceName(final Pattern regex) {
        return new FilterCondition(){

            @Override
            public boolean matches(ServerContext context, Request request) {
                return regex.matcher(request.getResourceName()).matches();
            }
        };
    }

    public static FilterCondition matchResourceName(String regex) {
        return Filters.matchResourceName(Pattern.compile(regex));
    }

    public static FilterCondition not(final FilterCondition condition) {
        return new FilterCondition(){

            @Override
            public boolean matches(ServerContext context, Request request) {
                return !condition.matches(context, request);
            }
        };
    }

    public static FilterCondition or(final Collection<FilterCondition> conditions) {
        return new FilterCondition(){

            @Override
            public boolean matches(ServerContext context, Request request) {
                for (FilterCondition condition : conditions) {
                    if (!condition.matches(context, request)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FilterCondition or(FilterCondition ... conditions) {
        return Filters.or(Arrays.asList(conditions));
    }

    private static <C> Filter asFilter0(CrossCutFilter<C> filter) {
        return new CrossCutFilterAdapter(filter);
    }

    private static <C> Filter asFilter0(UntypedCrossCutFilter<C> filter) {
        return new CrossCutFilterAdapter(new UntypedCrossCutFilterAdapter(filter));
    }

    private Filters() {
    }

    private static final class UntypedCrossCutFilterAdapter<C>
    implements CrossCutFilter<C> {
        private final UntypedCrossCutFilter<C> filter;

        private UntypedCrossCutFilterAdapter(UntypedCrossCutFilter<C> filter) {
            this.filter = filter;
        }

        @Override
        public void filterActionError(ServerContext context, C state, ResourceException error, ResultHandler<JsonValue> handler) {
            this.filter.filterGenericError(context, state, error, this.checked(handler, JsonValue.class));
        }

        @Override
        public void filterActionRequest(ServerContext context, ActionRequest request, RequestHandler next, CrossCutFilterResultHandler<C, JsonValue> handler) {
            this.filter.filterGenericRequest(context, request, next, this.checked(handler, JsonValue.class));
        }

        @Override
        public void filterActionResult(ServerContext context, C state, JsonValue result, ResultHandler<JsonValue> handler) {
            this.filter.filterGenericResult(context, state, result, this.checked(handler, JsonValue.class));
        }

        @Override
        public void filterGenericError(ServerContext context, C state, ResourceException error, ResultHandler<Resource> handler) {
            this.filter.filterGenericError(context, state, error, this.checked(handler, Resource.class));
        }

        @Override
        public void filterGenericRequest(ServerContext context, Request request, RequestHandler next, CrossCutFilterResultHandler<C, Resource> handler) {
            this.filter.filterGenericRequest(context, request, next, this.checked(handler, Resource.class));
        }

        @Override
        public void filterGenericResult(ServerContext context, C state, Resource result, ResultHandler<Resource> handler) {
            this.filter.filterGenericResult(context, state, result, this.checked(handler, Resource.class));
        }

        @Override
        public void filterQueryError(ServerContext context, C state, ResourceException error, QueryResultHandler handler) {
            this.filter.filterGenericError(context, state, error, this.checked(handler, QueryResult.class));
        }

        @Override
        public void filterQueryRequest(ServerContext context, QueryRequest request, RequestHandler next, CrossCutFilterResultHandler<C, QueryResult> handler) {
            this.filter.filterGenericRequest(context, request, next, this.checked(handler, QueryResult.class));
        }

        @Override
        public void filterQueryResource(ServerContext context, C state, Resource resource, QueryResultHandler handler) {
            this.filter.filterQueryResource(context, state, resource, handler);
        }

        @Override
        public void filterQueryResult(ServerContext context, C state, QueryResult result, QueryResultHandler handler) {
            this.filter.filterGenericResult(context, state, result, this.checked(handler, QueryResult.class));
        }

        private <R> CrossCutFilterResultHandler<C, Object> checked(final CrossCutFilterResultHandler<C, R> handler, final Class<R> clazz) {
            return new CrossCutFilterResultHandler<C, Object>(){

                @Override
                public void handleContinue(ServerContext context, C state) {
                    handler.handleContinue(context, state);
                }

                @Override
                public void handleError(ResourceException error) {
                    handler.handleError(error);
                }

                @Override
                public void handleResult(Object response) {
                    try {
                        handler.handleResult(clazz.cast(response));
                    }
                    catch (ClassCastException e) {
                        handler.handleError(new InternalServerErrorException(e));
                    }
                }
            };
        }

        private <R> ResultHandler<Object> checked(final ResultHandler<R> handler, final Class<R> clazz) {
            return new ResultHandler<Object>(){

                @Override
                public void handleError(ResourceException error) {
                    handler.handleError(error);
                }

                @Override
                public void handleResult(Object response) {
                    try {
                        handler.handleResult(clazz.cast(response));
                    }
                    catch (ClassCastException e) {
                        handler.handleError(new InternalServerErrorException(e));
                    }
                }
            };
        }
    }

    private static final class CrossCutFilterAdapter<C>
    implements Filter {
        private final CrossCutFilter<C> filter;

        private CrossCutFilterAdapter(CrossCutFilter<C> filter) {
            this.filter = filter;
        }

        @Override
        public void filterAction(ServerContext context, final ActionRequest request, final ResultHandler<JsonValue> handler, final RequestHandler next) {
            this.filter.filterActionRequest(context, request, next, new Handler<C, JsonValue>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleAction(newContext, request, CrossCutFilterAdapter.this.wrapAction(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterCreate(ServerContext context, final CreateRequest request, final ResultHandler<Resource> handler, final RequestHandler next) {
            this.filter.filterGenericRequest(context, request, next, new Handler<C, Resource>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleCreate(newContext, request, CrossCutFilterAdapter.this.wrapGeneric(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterDelete(ServerContext context, final DeleteRequest request, final ResultHandler<Resource> handler, final RequestHandler next) {
            this.filter.filterGenericRequest(context, request, next, new Handler<C, Resource>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleDelete(newContext, request, CrossCutFilterAdapter.this.wrapGeneric(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterPatch(ServerContext context, final PatchRequest request, final ResultHandler<Resource> handler, final RequestHandler next) {
            this.filter.filterGenericRequest(context, request, next, new Handler<C, Resource>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handlePatch(newContext, request, CrossCutFilterAdapter.this.wrapGeneric(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterQuery(ServerContext context, final QueryRequest request, final QueryResultHandler handler, final RequestHandler next) {
            this.filter.filterQueryRequest(context, request, next, new Handler<C, QueryResult>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleQuery(newContext, request, CrossCutFilterAdapter.this.wrapQuery(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterRead(ServerContext context, final ReadRequest request, final ResultHandler<Resource> handler, final RequestHandler next) {
            this.filter.filterGenericRequest(context, request, next, new Handler<C, Resource>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleRead(newContext, request, CrossCutFilterAdapter.this.wrapGeneric(newContext, state, handler));
                }
            });
        }

        @Override
        public void filterUpdate(ServerContext context, final UpdateRequest request, final ResultHandler<Resource> handler, final RequestHandler next) {
            this.filter.filterGenericRequest(context, request, next, new Handler<C, Resource>(handler){

                @Override
                public void handleContinue(ServerContext newContext, C state) {
                    next.handleUpdate(newContext, request, CrossCutFilterAdapter.this.wrapGeneric(newContext, state, handler));
                }
            });
        }

        private ResultHandler<JsonValue> wrapAction(final ServerContext context, final C state, final ResultHandler<JsonValue> handler) {
            return new ResultHandler<JsonValue>(){

                @Override
                public void handleError(ResourceException error) {
                    CrossCutFilterAdapter.this.filter.filterActionError(context, state, error, handler);
                }

                @Override
                public void handleResult(JsonValue result) {
                    CrossCutFilterAdapter.this.filter.filterActionResult(context, state, result, handler);
                }
            };
        }

        private ResultHandler<Resource> wrapGeneric(final ServerContext context, final C state, final ResultHandler<Resource> handler) {
            return new ResultHandler<Resource>(){

                @Override
                public void handleError(ResourceException error) {
                    CrossCutFilterAdapter.this.filter.filterGenericError(context, state, error, handler);
                }

                @Override
                public void handleResult(Resource result) {
                    CrossCutFilterAdapter.this.filter.filterGenericResult(context, state, result, handler);
                }
            };
        }

        private QueryResultHandler wrapQuery(final ServerContext context, final C state, final QueryResultHandler handler) {
            return new QueryResultHandler(){
                private final AtomicBoolean hasCompleted = new AtomicBoolean();
                private final QueryResultHandler innerHandler = new QueryResultHandler(){

                    @Override
                    public void handleError(ResourceException error) {
                        if (hasCompleted.compareAndSet(false, true)) {
                            handler.handleError(error);
                        }
                    }

                    @Override
                    public boolean handleResource(Resource resource) {
                        return !hasCompleted.get() && handler.handleResource(resource);
                    }

                    @Override
                    public void handleResult(QueryResult result) {
                        if (hasCompleted.compareAndSet(false, true)) {
                            handler.handleResult(result);
                        }
                    }
                };

                @Override
                public void handleError(ResourceException error) {
                    if (!this.hasCompleted.get()) {
                        CrossCutFilterAdapter.this.filter.filterQueryError(context, state, error, this.innerHandler);
                    }
                }

                @Override
                public boolean handleResource(Resource resource) {
                    if (!this.hasCompleted.get()) {
                        CrossCutFilterAdapter.this.filter.filterQueryResource(context, state, resource, this.innerHandler);
                    }
                    return !this.hasCompleted.get();
                }

                @Override
                public void handleResult(QueryResult result) {
                    if (!this.hasCompleted.get()) {
                        CrossCutFilterAdapter.this.filter.filterQueryResult(context, state, result, this.innerHandler);
                    }
                }
            };
        }

        private static abstract class Handler<C, R>
        implements CrossCutFilterResultHandler<C, R> {
            private final ResultHandler<R> handler;

            Handler(ResultHandler<R> handler) {
                this.handler = handler;
            }

            @Override
            public void handleError(ResourceException error) {
                this.handler.handleError(error);
            }

            @Override
            public void handleResult(R response) {
                this.handler.handleResult(response);
            }
        }
    }

    private static final class ConditionalFilter
    implements Filter {
        private final FilterCondition condition;
        private final Filter subFilter;

        private ConditionalFilter(FilterCondition condition, Filter filter) {
            this.condition = condition;
            this.subFilter = filter;
        }

        @Override
        public void filterAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterAction(context, request, handler, next);
            } else {
                next.handleAction(context, request, handler);
            }
        }

        @Override
        public void filterCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterCreate(context, request, handler, next);
            } else {
                next.handleCreate(context, request, handler);
            }
        }

        @Override
        public void filterDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterDelete(context, request, handler, next);
            } else {
                next.handleDelete(context, request, handler);
            }
        }

        @Override
        public void filterPatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterPatch(context, request, handler, next);
            } else {
                next.handlePatch(context, request, handler);
            }
        }

        @Override
        public void filterQuery(ServerContext context, QueryRequest request, QueryResultHandler handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterQuery(context, request, handler, next);
            } else {
                next.handleQuery(context, request, handler);
            }
        }

        @Override
        public void filterRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterRead(context, request, handler, next);
            } else {
                next.handleRead(context, request, handler);
            }
        }

        @Override
        public void filterUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler, RequestHandler next) {
            if (this.condition.matches(context, request)) {
                this.subFilter.filterUpdate(context, request, handler, next);
            } else {
                next.handleUpdate(context, request, handler);
            }
        }
    }
}

