/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.UpdateRequest;

public final class FilterChain
implements RequestHandler {
    private final List<Filter> filters = new CopyOnWriteArrayList<Filter>();
    private volatile RequestHandler target;

    public FilterChain(RequestHandler target) {
        this.target = Resources.checkNotNull(target);
    }

    public FilterChain(RequestHandler target, Collection<Filter> filters) {
        this.target = Resources.checkNotNull(target);
        this.filters.addAll(filters);
    }

    public FilterChain(RequestHandler target, Filter ... filters) {
        this.target = Resources.checkNotNull(target);
        this.filters.addAll(Arrays.asList(filters));
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public RequestHandler getTarget() {
        return this.target;
    }

    @Override
    public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
        new Cursor().handleAction(context, request, handler);
    }

    @Override
    public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
        new Cursor().handleCreate(context, request, handler);
    }

    @Override
    public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
        new Cursor().handleDelete(context, request, handler);
    }

    @Override
    public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
        new Cursor().handlePatch(context, request, handler);
    }

    @Override
    public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
        new Cursor().handleQuery(context, request, handler);
    }

    @Override
    public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
        new Cursor().handleRead(context, request, handler);
    }

    @Override
    public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
        new Cursor().handleUpdate(context, request, handler);
    }

    public FilterChain setTarget(RequestHandler target) {
        this.target = Resources.checkNotNull(target);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.filters.toString());
        builder.append(" -> ");
        builder.append(this.target.toString());
        return builder.toString();
    }

    private final class Cursor
    implements RequestHandler {
        private final int pos;
        private final Filter[] snapshot;

        private Cursor() {
            this(filterChain.filters.toArray(new Filter[0]), 0);
        }

        private Cursor(Filter[] snapshot, int pos) {
            this.snapshot = snapshot;
            this.pos = pos;
        }

        @Override
        public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
            if (this.hasNext()) {
                this.get().filterAction(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleAction(context, request, handler);
            }
        }

        @Override
        public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
            if (this.hasNext()) {
                this.get().filterCreate(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleCreate(context, request, handler);
            }
        }

        @Override
        public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
            if (this.hasNext()) {
                this.get().filterDelete(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleDelete(context, request, handler);
            }
        }

        @Override
        public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
            if (this.hasNext()) {
                this.get().filterPatch(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handlePatch(context, request, handler);
            }
        }

        @Override
        public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
            if (this.hasNext()) {
                this.get().filterQuery(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleQuery(context, request, handler);
            }
        }

        @Override
        public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
            if (this.hasNext()) {
                this.get().filterRead(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleRead(context, request, handler);
            }
        }

        @Override
        public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
            if (this.hasNext()) {
                this.get().filterUpdate(context, request, handler, this.next());
            } else {
                FilterChain.this.target.handleUpdate(context, request, handler);
            }
        }

        private Filter get() {
            return this.snapshot[this.pos];
        }

        private boolean hasNext() {
            return this.pos < this.snapshot.length;
        }

        private Cursor next() {
            return new Cursor(this.snapshot, this.pos + 1);
        }
    }
}

