/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;

public final class ApiInfoContext
extends Context {
    private static final String ATTR_API_NAME = "api-name";
    private static final String ATTR_API_VERSION = "api-version";
    private final String apiName;
    private final String apiVersion;

    public ApiInfoContext(Context parent, String apiName, String apiVersion) {
        super(Resources.checkNotNull(parent));
        this.apiName = Resources.checkNotNull(apiName);
        this.apiVersion = Resources.checkNotNull(apiVersion);
    }

    public ApiInfoContext(String id, Context parent, String apiName, String apiVersion) {
        super(id, Resources.checkNotNull(parent));
        this.apiName = Resources.checkNotNull(apiName);
        this.apiVersion = Resources.checkNotNull(apiVersion);
    }

    ApiInfoContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        this.apiName = savedContext.get(ATTR_API_NAME).required().asString();
        this.apiVersion = savedContext.get(ATTR_API_VERSION).required().asString();
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        savedContext.put(ATTR_API_NAME, (Object)this.apiName);
        savedContext.put(ATTR_API_VERSION, (Object)this.apiVersion);
    }
}

