/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collection;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.FutureResult;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.json.resource.UpdateRequest;

public abstract class AbstractAsynchronousConnection
implements Connection {
    protected AbstractAsynchronousConnection() {
    }

    @Override
    public JsonValue action(Context context, ActionRequest request) throws ResourceException {
        FutureResult<JsonValue> future = this.actionAsync(context, request, null);
        try {
            JsonValue jsonValue = future.get();
            return jsonValue;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Resource create(Context context, CreateRequest request) throws ResourceException {
        FutureResult<Resource> future = this.createAsync(context, request, null);
        try {
            Resource resource = future.get();
            return resource;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Resource delete(Context context, DeleteRequest request) throws ResourceException {
        FutureResult<Resource> future = this.deleteAsync(context, request, null);
        try {
            Resource resource = future.get();
            return resource;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Resource patch(Context context, PatchRequest request) throws ResourceException {
        FutureResult<Resource> future = this.patchAsync(context, request, null);
        try {
            Resource resource = future.get();
            return resource;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public QueryResult query(Context context, QueryRequest request, QueryResultHandler handler) throws ResourceException {
        FutureResult<QueryResult> future = this.queryAsync(context, request, handler);
        try {
            QueryResult queryResult = future.get();
            return queryResult;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public QueryResult query(Context context, QueryRequest request, final Collection<? super Resource> results) throws ResourceException {
        QueryResultHandler handler = new QueryResultHandler(){

            @Override
            public void handleError(ResourceException error) {
            }

            @Override
            public boolean handleResource(Resource resource) {
                results.add(resource);
                return true;
            }

            @Override
            public void handleResult(QueryResult result) {
            }
        };
        return this.query(context, request, handler);
    }

    @Override
    public Resource read(Context context, ReadRequest request) throws ResourceException {
        FutureResult<Resource> future = this.readAsync(context, request, null);
        try {
            Resource resource = future.get();
            return resource;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Resource update(Context context, UpdateRequest request) throws ResourceException {
        FutureResult<Resource> future = this.updateAsync(context, request, null);
        try {
            Resource resource = future.get();
            return resource;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    private ResourceException interrupted(InterruptedException e) {
        return new ServiceUnavailableException("Client thread interrupted", (Throwable)e);
    }
}

