/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.adapter.server2x;

import com.forgerock.opendj.util.CompletedFutureResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import org.forgerock.opendj.adapter.server2x.Converters;
import org.forgerock.opendj.ldap.AbstractSynchronousConnection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SASLBindRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

public final class Adapters {
    private Adapters() {
    }

    public static ConnectionFactory newRootConnectionFactory() {
        InternalClientConnection icc = InternalClientConnection.getRootConnection();
        return Adapters.newConnectionFactory(icc);
    }

    public static ConnectionFactory newAnonymousConnectionFactory() {
        InternalClientConnection icc = new InternalClientConnection(new AuthenticationInfo());
        return Adapters.newConnectionFactory(icc);
    }

    public static ConnectionFactory newConnectionFactoryForUser(DN userDN) {
        InternalClientConnection icc = null;
        try {
            icc = new InternalClientConnection(Converters.to(userDN));
        }
        catch (DirectoryException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return Adapters.newConnectionFactory(icc);
    }

    public static ConnectionFactory newConnectionFactory(InternalClientConnection icc) {
        final Connection connection = Adapters.newConnection(icc);
        ConnectionFactory factory = new ConnectionFactory(){

            public void close() {
            }

            public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
                if (handler != null) {
                    handler.handleResult((Object)connection);
                }
                return new CompletedFutureResult((Object)connection);
            }

            public Connection getConnection() throws ErrorResultException {
                return connection;
            }
        };
        return factory;
    }

    public static Connection newRootConnection() {
        return Adapters.newConnection(InternalClientConnection.getRootConnection());
    }

    public static Connection newAnonymousConnection() {
        return Adapters.newConnection(new InternalClientConnection(new AuthenticationInfo()));
    }

    public static Connection newConnectionForUser(DN dn) throws ErrorResultException {
        try {
            return Adapters.newConnection(new InternalClientConnection(Converters.to(dn)));
        }
        catch (DirectoryException e) {
            throw ErrorResultException.newErrorResult((Result)Responses.newResult((ResultCode)ResultCode.NO_SUCH_OBJECT));
        }
    }

    private static Connection newConnection(final InternalClientConnection icc) {
        return new AbstractSynchronousConnection(){

            public Result search(SearchRequest request, final SearchResultHandler handler) throws ErrorResultException {
                InternalSearchListener internalSearchListener = new InternalSearchListener(){

                    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) throws DirectoryException {
                        handler.handleReference(Converters.from(searchReference));
                    }

                    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
                        handler.handleEntry(Converters.from(searchEntry));
                    }
                };
                InternalSearchOperation internalSO = icc.processSearch(Converters.to(ByteString.valueOf((Object)request.getName())), Converters.to(request.getScope()), Converters.to(request.getDereferenceAliasesPolicy()), request.getSizeLimit(), request.getTimeLimit(), request.isTypesOnly(), Converters.to(request.getFilter()), new LinkedHashSet(request.getAttributes()), Converters.to(request.getControls()), internalSearchListener);
                return Converters.getResponseResult((Operation)internalSO);
            }

            public void removeConnectionEventListener(ConnectionEventListener listener) {
            }

            public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
                ModifyDNOperation modifyDNOperation = icc.processModifyDN(Converters.to(ByteString.valueOf((Object)request.getName())), Converters.to(ByteString.valueOf((Object)request.getNewRDN())), request.isDeleteOldRDN(), request.getNewSuperior() != null ? Converters.to(ByteString.valueOf((Object)request.getNewSuperior())) : null, Converters.to(request.getControls()));
                return Converters.getResponseResult((Operation)modifyDNOperation);
            }

            public Result modify(ModifyRequest request) throws ErrorResultException {
                ModifyOperation modifyOperation = icc.processModify(Converters.to(ByteString.valueOf((Object)request.getName())), Converters.toRawModifications(request.getModifications()), Converters.to(request.getControls()));
                return Converters.getResponseResult((Operation)modifyOperation);
            }

            public boolean isValid() {
                return true;
            }

            public boolean isClosed() {
                return false;
            }

            public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
                ExtendedOperation extendedOperation = icc.processExtendedOperation(request.getOID(), Converters.to(request.getValue()), Converters.to(request.getControls()));
                Result result = Converters.getResponseResult((Operation)extendedOperation);
                GenericExtendedResult genericExtendedResult = Responses.newGenericExtendedResult((ResultCode)result.getResultCode()).setDiagnosticMessage(result.getDiagnosticMessage()).setMatchedDN(result.getMatchedDN()).setValue((Object)Converters.from(extendedOperation.getResponseValue().toByteString()));
                try {
                    ExtendedResult extendedResult = request.getResultDecoder().decodeExtendedResult((ExtendedResult)genericExtendedResult, new DecodeOptions());
                    for (Control control : result.getControls()) {
                        extendedResult.addControl(control);
                    }
                    return (R)extendedResult;
                }
                catch (DecodeException e) {
                    return (R)request.getResultDecoder().newExtendedErrorResult(ResultCode.valueOf((int)extendedOperation.getResultCode().getIntValue()), extendedOperation.getMatchedDN() != null ? extendedOperation.getMatchedDN().toString() : null, extendedOperation.getErrorMessage().toString());
                }
            }

            public Result delete(DeleteRequest request) throws ErrorResultException {
                DeleteOperation deleteOperation = icc.processDelete(Converters.to(ByteString.valueOf((Object)request.getName())), Converters.to(request.getControls()));
                return Converters.getResponseResult((Operation)deleteOperation);
            }

            public CompareResult compare(CompareRequest request) throws ErrorResultException {
                CompareOperation compareOperation = icc.processCompare(Converters.to(ByteString.valueOf((Object)request.getName())), request.getAttributeDescription().toString(), Converters.to(request.getAssertionValueAsString()), Converters.to(request.getControls()));
                CompareResult result = Responses.newCompareResult((ResultCode)Converters.getResultCode((Operation)compareOperation));
                result = Converters.getResponseResult((Operation)compareOperation, result);
                return result;
            }

            public void close(UnbindRequest request, String reason) {
            }

            public BindResult bind(BindRequest request) throws ErrorResultException {
                BindOperation bindOperation = null;
                if (request instanceof SimpleBindRequest) {
                    bindOperation = icc.processSimpleBind(Converters.to(request.getName()), org.opends.server.types.ByteString.wrap((byte[])((SimpleBindRequest)request).getPassword()), Converters.to(request.getControls()));
                } else if (request instanceof SASLBindRequest) {
                    GenericBindRequest genericBindRequest;
                    String serverName = null;
                    try {
                        serverName = InetAddress.getByName(null).getCanonicalHostName();
                    }
                    catch (UnknownHostException e) {
                        // empty catch block
                    }
                    BindClient bindClient = request.createBindClient(serverName);
                    do {
                        genericBindRequest = bindClient.nextBindRequest();
                    } while ((bindOperation = icc.processSASLBind(Converters.to(request.getName()), ((SASLBindRequest)request).getSASLMechanism(), Converters.getCredentials(genericBindRequest.getAuthenticationValue()), Converters.to(request.getControls()))).getResultCode() == org.opends.server.types.ResultCode.SASL_BIND_IN_PROGRESS);
                    bindClient.dispose();
                } else {
                    throw ErrorResultException.newErrorResult((Result)Responses.newResult((ResultCode)ResultCode.AUTH_METHOD_NOT_SUPPORTED));
                }
                BindResult result = Responses.newBindResult((ResultCode)Converters.getResultCode((Operation)bindOperation));
                result.setServerSASLCredentials(Converters.from(bindOperation.getSASLCredentials()));
                if (result.isSuccess()) {
                    return result;
                }
                throw ErrorResultException.newErrorResult((Result)result);
            }

            public void addConnectionEventListener(ConnectionEventListener listener) {
            }

            public Result add(AddRequest request) throws ErrorResultException {
                AddOperation addOperation = icc.processAdd(Converters.to(ByteString.valueOf((Object)request.getName())), Converters.to(request.getAllAttributes()), Converters.to(request.getControls()));
                return Converters.getResponseResult((Operation)addOperation);
            }

            public String toString() {
                return icc.toString();
            }
        };
    }
}

