/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.LocalBackendWorkflowElementCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.LDAPPostReadRequestControl;
import org.opends.server.controls.LDAPPostReadResponseControl;
import org.opends.server.controls.LDAPPreReadRequestControl;
import org.opends.server.controls.LDAPPreReadResponseControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.workflowelement.LeafWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

public class LocalBackendWorkflowElement
extends LeafWorkflowElement<LocalBackendWorkflowElementCfg>
implements ConfigurationChangeListener<LocalBackendWorkflowElementCfg> {
    private Backend backend;
    private static TreeMap<String, LocalBackendWorkflowElement> registeredLocalBackends = new TreeMap();
    private final List<PersistentSearch> persistentSearches = new CopyOnWriteArrayList<PersistentSearch>();
    private static final Object registeredLocalBackendsLock = new Object();
    private static final String BACKEND_WORKFLOW_ELEMENT = "Backend";

    private void initialize(String workflowElementID, Backend backend) {
        super.initialize(workflowElementID, BACKEND_WORKFLOW_ELEMENT);
        this.backend = backend;
        if (this.backend != null) {
            this.setPrivate(this.backend.isPrivateBackend());
        }
    }

    public void initializeWorkflowElement(LocalBackendWorkflowElementCfg configuration) throws ConfigException, InitializationException {
        configuration.addLocalBackendChangeListener(this);
        this.processWorkflowElementConfig(configuration, true);
    }

    @Override
    public void finalizeWorkflowElement() {
        super.initialize(null, null);
        this.backend = null;
        for (PersistentSearch psearch : this.persistentSearches) {
            psearch.cancel();
        }
        this.persistentSearches.clear();
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LocalBackendWorkflowElementCfg configuration, List<Message> unacceptableReasons) {
        boolean isAcceptable = this.processWorkflowElementConfig(configuration, false);
        return isAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LocalBackendWorkflowElementCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        this.processWorkflowElementConfig(configuration, true);
        return changeResult;
    }

    private boolean processWorkflowElementConfig(LocalBackendWorkflowElementCfg configuration, boolean applyChanges) {
        boolean isAcceptable = true;
        if (configuration.isEnabled()) {
            String newBackendID = configuration.getBackend();
            Backend newBackend = DirectoryServer.getBackend(newBackendID);
            if (newBackend == null) {
                ServerManagementContext context = ServerManagementContext.getInstance();
                RootCfg root = context.getRootConfiguration();
                try {
                    BackendCfg backendCfg = root.getBackend(newBackendID);
                    if (backendCfg.getBaseDN().contains(DN.decode("cn=config"))) {
                        newBackend = DirectoryServer.getConfigHandler();
                    }
                }
                catch (Exception ex) {
                    newBackend = null;
                }
            }
            if (applyChanges) {
                super.initialize(configuration.dn().getRDN().getAttributeValue(0).toString(), BACKEND_WORKFLOW_ELEMENT);
                this.backend = newBackend;
                if (this.backend != null) {
                    this.setPrivate(this.backend.isPrivateBackend());
                }
            }
        }
        return isAcceptable;
    }

    public static LocalBackendWorkflowElement createAndRegister(String workflowElementID, Backend backend) {
        LocalBackendWorkflowElement localBackend = registeredLocalBackends.get(workflowElementID);
        if (localBackend == null) {
            localBackend = new LocalBackendWorkflowElement();
            localBackend.initialize(workflowElementID, backend);
            LocalBackendWorkflowElement.registerLocalBackend(localBackend);
        }
        return localBackend;
    }

    public static void remove(String workflowElementID) {
        LocalBackendWorkflowElement.deregisterLocalBackend(workflowElementID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            for (LocalBackendWorkflowElement localBackend : registeredLocalBackends.values()) {
                LocalBackendWorkflowElement.deregisterLocalBackend(localBackend.getWorkflowElementID());
            }
        }
    }

    static boolean isControlAllowed(DN targetDN, Operation op, Control control) throws DirectoryException {
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(targetDN, op, control)) {
            if (control.isCritical()) {
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(control.getOID()));
            }
            op.removeRequestControl(control);
            return false;
        }
        return true;
    }

    static void addPostReadResponse(Operation operation, LDAPPostReadRequestControl postReadRequest, Entry entry) {
        if (postReadRequest == null) {
            return;
        }
        Entry fullEntry = entry.duplicate(true);
        SearchResultEntry unfilteredSearchEntry = new SearchResultEntry(fullEntry, null);
        if (AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(operation, unfilteredSearchEntry)) {
            Entry filteredEntry = fullEntry.filterEntry(postReadRequest.getRequestedAttributes(), false, false, false);
            SearchResultEntry filteredSearchEntry = new SearchResultEntry(filteredEntry, null);
            AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(operation, unfilteredSearchEntry, filteredSearchEntry);
            LDAPPostReadResponseControl responseControl = new LDAPPostReadResponseControl(filteredSearchEntry);
            operation.addResponseControl(responseControl);
        }
    }

    static void addPreReadResponse(Operation operation, LDAPPreReadRequestControl preReadRequest, Entry entry) {
        if (preReadRequest == null) {
            return;
        }
        SearchResultEntry unfilteredSearchEntry = new SearchResultEntry(entry, null);
        if (AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(operation, unfilteredSearchEntry)) {
            Entry filteredEntry = entry.filterEntry(preReadRequest.getRequestedAttributes(), false, false, false);
            SearchResultEntry filteredSearchEntry = new SearchResultEntry(filteredEntry, null);
            AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(operation, unfilteredSearchEntry, filteredSearchEntry);
            LDAPPreReadResponseControl responseControl = new LDAPPreReadResponseControl(filteredSearchEntry);
            operation.addResponseControl(responseControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerLocalBackend(LocalBackendWorkflowElement localBackend) {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            String localBackendID = localBackend.getWorkflowElementID();
            LocalBackendWorkflowElement existingLocalBackend = registeredLocalBackends.get(localBackendID);
            if (existingLocalBackend == null) {
                TreeMap<String, LocalBackendWorkflowElement> newLocalBackends = new TreeMap<String, LocalBackendWorkflowElement>((SortedMap<String, LocalBackendWorkflowElement>)registeredLocalBackends);
                newLocalBackends.put(localBackendID, localBackend);
                registeredLocalBackends = newLocalBackends;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterLocalBackend(String workflowElementID) {
        Object object = registeredLocalBackendsLock;
        synchronized (object) {
            LocalBackendWorkflowElement existingLocalBackend = registeredLocalBackends.get(workflowElementID);
            if (existingLocalBackend != null) {
                TreeMap<String, LocalBackendWorkflowElement> newLocalBackends = new TreeMap<String, LocalBackendWorkflowElement>((SortedMap<String, LocalBackendWorkflowElement>)registeredLocalBackends);
                newLocalBackends.remove(workflowElementID);
                registeredLocalBackends = newLocalBackends;
            }
        }
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        switch (operation.getOperationType()) {
            case BIND: {
                LocalBackendBindOperation bindOperation = new LocalBackendBindOperation((BindOperation)operation);
                bindOperation.processLocalBind(this);
                break;
            }
            case SEARCH: {
                LocalBackendSearchOperation searchOperation = new LocalBackendSearchOperation((SearchOperation)operation);
                searchOperation.processLocalSearch(this);
                break;
            }
            case ADD: {
                LocalBackendAddOperation addOperation = new LocalBackendAddOperation((AddOperation)operation);
                addOperation.processLocalAdd(this);
                break;
            }
            case DELETE: {
                LocalBackendDeleteOperation deleteOperation = new LocalBackendDeleteOperation((DeleteOperation)operation);
                deleteOperation.processLocalDelete(this);
                break;
            }
            case MODIFY: {
                LocalBackendModifyOperation modifyOperation = new LocalBackendModifyOperation((ModifyOperation)operation);
                modifyOperation.processLocalModify(this);
                break;
            }
            case MODIFY_DN: {
                LocalBackendModifyDNOperation modifyDNOperation = new LocalBackendModifyDNOperation((ModifyDNOperation)operation);
                modifyDNOperation.processLocalModifyDN(this);
                break;
            }
            case COMPARE: {
                LocalBackendCompareOperation compareOperation = new LocalBackendCompareOperation((CompareOperation)operation);
                compareOperation.processLocalCompare(this);
                break;
            }
            case ABANDON: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to execute an invalid operation type:  " + (Object)((Object)operation.getOperationType()) + " (" + operation + ")"));
            }
        }
    }

    public static <O extends Operation, L> void attachLocalOperation(O globalOperation, L currentLocalOperation) {
        List existingAttachment = (List)globalOperation.getAttachment("LocalBackendOperations");
        ArrayList<L> newAttachment = new ArrayList<L>();
        if (existingAttachment != null) {
            newAttachment.addAll(existingAttachment);
        }
        newAttachment.add(currentLocalOperation);
        globalOperation.setAttachment("LocalBackendOperations", newAttachment);
    }

    public Backend getBackend() {
        return this.backend;
    }

    void registerPersistentSearch(PersistentSearch persistentSearch) {
        PersistentSearch.CancellationCallback callback = new PersistentSearch.CancellationCallback(){

            @Override
            public void persistentSearchCancelled(PersistentSearch psearch) {
                LocalBackendWorkflowElement.this.persistentSearches.remove(psearch);
            }
        };
        this.persistentSearches.add(persistentSearch);
        persistentSearch.registerCancellationCallback(callback);
    }

    List<PersistentSearch> getPersistentSearches() {
        return this.persistentSearches;
    }
}

