/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.controls.SubentriesControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationWrapper;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendSearchOperation
extends SearchOperationWrapper
implements PreOperationSearchOperation,
PostOperationSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected Backend backend;
    protected boolean processSearch;
    protected ClientConnection clientConnection;
    protected DN baseDN;
    protected PersistentSearch persistentSearch;
    protected SearchFilter filter;

    public LocalBackendSearchOperation(SearchOperation search) {
        super(search);
        LocalBackendWorkflowElement.attachLocalOperation(search, this);
    }

    /*
     * Unable to fully structure code
     */
    public void processLocalSearch(LocalBackendWorkflowElement wfe) throws CanceledOperationException {
        block18: {
            block21: {
                block20: {
                    block19: {
                        executePostOpPlugins = false;
                        this.backend = wfe.getBackend();
                        this.clientConnection = this.getClientConnection();
                        pluginConfigManager = DirectoryServer.getPluginConfigManager();
                        this.processSearch = true;
                        this.checkIfCanceled(false);
                        this.baseDN = this.getBaseDN();
                        this.filter = this.getFilter();
                        if (this.baseDN == null || this.filter == null) break block18;
                        try {
                            this.handleRequestControls();
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendSearchOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            this.setResponseData(de);
                            break block18;
                        }
                        try {
                            if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                                this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                this.appendErrorMessage(CoreMessages.ERR_SEARCH_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.baseDN)));
                            }
                            break block19;
                        }
                        catch (DirectoryException e) {
                            this.setResultCode(e.getResultCode());
                            this.appendErrorMessage(e.getMessageObject());
                        }
                        break block18;
                    }
                    this.checkIfCanceled(false);
                    executePostOpPlugins = true;
                    preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(this);
                    if (preOpResult.continueProcessing()) break block20;
                    this.setResultCode(preOpResult.getResultCode());
                    this.appendErrorMessage(preOpResult.getErrorMessage());
                    this.setMatchedDN(preOpResult.getMatchedDN());
                    this.setReferralURLs(preOpResult.getReferralURLs());
                    break block18;
                }
                this.checkIfCanceled(false);
                if (this.backend != null) break block21;
                this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.baseDN)));
                break block18;
            }
            this.setResultCode(ResultCode.SUCCESS);
            if (this.persistentSearch == null) ** GOTO lbl53
            if (!DirectoryServer.allowNewPersistentSearch()) {
                this.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                this.appendErrorMessage(CoreMessages.ERR_MAX_PSEARCH_LIMIT_EXCEEDED.get());
            } else {
                wfe.registerPersistentSearch(this.persistentSearch);
                this.persistentSearch.enable();
lbl53:
                // 2 sources

                try {
                    if (this.processSearch) {
                        this.backend.search(this);
                    }
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        LocalBackendSearchOperation.TRACER.debugCaught(DebugLogLevel.VERBOSE, de);
                    }
                    this.setResponseData(de);
                    if (this.persistentSearch != null) {
                        this.persistentSearch.cancel();
                        this.setSendResponse(true);
                    }
                }
                catch (CanceledOperationException coe) {
                    if (this.persistentSearch != null) {
                        this.persistentSearch.cancel();
                        this.setSendResponse(true);
                    }
                    throw coe;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        LocalBackendSearchOperation.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.setResultCode(DirectoryServer.getServerErrorResultCode());
                    this.appendErrorMessage(CoreMessages.ERR_SEARCH_BACKEND_EXCEPTION.get(StaticUtils.getExceptionMessage(e)));
                    if (this.persistentSearch == null) break block18;
                    this.persistentSearch.cancel();
                    this.setSendResponse(true);
                }
            }
        }
        this.checkIfCanceled(false);
        if (executePostOpPlugins && !(postOpResult = pluginConfigManager.invokePostOperationSearchPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
    }

    protected void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!LocalBackendWorkflowElement.isControlAllowed(this.baseDN, this, c)) continue;
                if (oid.equals("1.3.6.1.1.12")) {
                    Entry entry;
                    SearchFilter assertionFilter;
                    LDAPAssertionRequestControl assertControl = this.getRequestControl(LDAPAssertionRequestControl.DECODER);
                    try {
                        assertionFilter = assertControl.getSearchFilter();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()), de);
                    }
                    try {
                        entry = DirectoryServer.getEntry(this.baseDN);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_GET_ENTRY_FOR_ASSERTION.get(de.getMessageObject()));
                    }
                    if (entry == null) {
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, CoreMessages.ERR_SEARCH_NO_SUCH_ENTRY_FOR_ASSERTION.get());
                    }
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this, entry, assertionFilter)) {
                        throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                    }
                    try {
                        if (assertionFilter.matchesEntry(entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_SEARCH_ASSERTION_FAILED.get());
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()), de);
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    this.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteProxiedAuthzV1Control"));
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV1Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV2Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.3")) {
                    PersistentSearchControl psearchControl = this.getRequestControl(PersistentSearchControl.DECODER);
                    this.persistentSearch = new PersistentSearch(this, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                    if (!psearchControl.getChangesOnly()) continue;
                    this.processSearch = false;
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.1")) {
                    SubentriesControl subentriesControl = this.getRequestControl(SubentriesControl.DECODER);
                    this.setReturnSubentriesOnly(subentriesControl.getVisibility());
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                    this.addAdditionalLogItem(AdditionalLogItem.keyOnly(this.getClass(), "obsoleteSubentryControl"));
                    this.setReturnSubentriesOnly(true);
                    continue;
                }
                if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                    MatchedValuesControl matchedValuesControl = this.getRequestControl(MatchedValuesControl.DECODER);
                    this.setMatchedValuesControl(matchedValuesControl);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                    this.setIncludeUsableControl(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.17")) {
                    this.setRealAttributesOnly(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.19")) {
                    this.setVirtualAttributesOnly(true);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.2") && DirectoryServer.isSupportedControl("1.3.6.1.4.1.42.2.27.9.5.2") || !c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_SEARCH_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }
}

