/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import org.opends.messages.MessageBuilder;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.server.util.cli.ConsoleApplication;

public class PointAdder
implements Runnable {
    private final ConsoleApplication app;
    private Thread t;
    private boolean stopPointAdder;
    private boolean pointAdderStopped;
    private long periodTime = 3000L;
    private final boolean isError;
    private final ProgressMessageFormatter formatter;
    public static final long DEFAULT_PERIOD_TIME = 3000L;

    public PointAdder(ConsoleApplication app) {
        this(app, 3000L, false, new PlainTextProgressMessageFormatter());
    }

    public PointAdder(ConsoleApplication app, long periodTime, boolean isError, ProgressMessageFormatter formatter) {
        this.app = app;
        this.periodTime = periodTime;
        this.isError = isError;
        this.formatter = formatter;
    }

    public void start() {
        MessageBuilder mb = new MessageBuilder();
        mb.append(this.formatter.getSpace());
        for (int i = 0; i < 5; ++i) {
            mb.append(this.formatter.getFormattedPoint());
        }
        if (this.isError) {
            this.app.print(mb.toMessage());
        } else {
            this.app.printProgress(mb.toMessage());
        }
        this.t = new Thread(this);
        this.t.start();
    }

    public synchronized void stop() {
        this.stopPointAdder = true;
        while (!this.pointAdderStopped) {
            try {
                this.t.interrupt();
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void run() {
        while (!this.stopPointAdder) {
            try {
                Thread.sleep(this.periodTime);
                if (this.isError) {
                    this.app.print(this.formatter.getFormattedPoint());
                    continue;
                }
                this.app.printProgress(this.formatter.getFormattedPoint());
            }
            catch (Throwable throwable) {}
        }
        this.pointAdderStopped = true;
    }
}

