/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class SelectableCertificateKeyManager
extends X509ExtendedKeyManager {
    private final String alias;
    private final X509KeyManager keyManager;

    public SelectableCertificateKeyManager(X509KeyManager keyManager, String alias) {
        this.keyManager = keyManager;
        this.alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        for (String type : keyType) {
            String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
            if (clientAliases == null) continue;
            for (String clientAlias : clientAliases) {
                if (!clientAlias.equals(this.alias)) continue;
                return this.alias;
            }
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        for (String type : keyType) {
            String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
            if (clientAliases == null) continue;
            for (String clientAlias : clientAliases) {
                if (!clientAlias.equals(this.alias)) continue;
                return this.alias;
            }
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
        if (serverAliases != null) {
            for (String serverAlias : serverAliases) {
                if (!serverAlias.equals(this.alias)) continue;
                return this.alias;
            }
        }
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
        if (serverAliases != null) {
            for (String serverAlias : serverAliases) {
                if (!serverAlias.equalsIgnoreCase(this.alias)) continue;
                return serverAlias;
            }
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    public static X509ExtendedKeyManager[] wrap(KeyManager[] keyManagers, String alias) {
        X509ExtendedKeyManager[] newKeyManagers = new X509ExtendedKeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            newKeyManagers[i] = new SelectableCertificateKeyManager((X509KeyManager)keyManagers[i], alias);
        }
        return newKeyManagers;
    }
}

