/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.opends.messages.Message;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDIFWriter
implements Closeable {
    private BufferedWriter writer;
    private LDIFExportConfig exportConfig;
    private static final Pattern SPLIT_NEWLINE = Pattern.compile("\\r?\\n");

    public LDIFWriter(LDIFExportConfig exportConfig) throws IOException {
        Validator.ensureNotNull(exportConfig);
        this.exportConfig = exportConfig;
        this.writer = exportConfig.getWriter();
    }

    public void writeComment(Message comment, int wrapColumn) throws IOException {
        String[] lines;
        Validator.ensureNotNull(comment);
        for (String l : lines = SPLIT_NEWLINE.split(comment)) {
            if (wrapColumn <= 0) {
                this.writer.write("# ");
                this.writer.write(l);
                this.writer.newLine();
                continue;
            }
            int breakColumn = wrapColumn - 2;
            if (l.length() <= breakColumn) {
                this.writer.write("# ");
                this.writer.write(l);
                this.writer.newLine();
                continue;
            }
            int startPos = 0;
            block1: while (startPos < l.length()) {
                if (startPos + breakColumn >= l.length()) {
                    this.writer.write("# ");
                    this.writer.write(l.substring(startPos));
                    this.writer.newLine();
                    startPos = l.length();
                    continue;
                }
                int endPos = startPos + breakColumn;
                for (int i = endPos - 1; i > startPos; --i) {
                    if (l.charAt(i) != ' ') continue;
                    this.writer.write("# ");
                    this.writer.write(l.substring(startPos, i));
                    this.writer.newLine();
                    startPos = i + 1;
                    continue block1;
                }
                this.writer.write("# ");
                this.writer.write(l.substring(startPos, endPos));
                this.writer.newLine();
                startPos = endPos;
            }
        }
    }

    public boolean writeEntries(Collection<Entry> entries) throws IOException, LDIFException {
        boolean ret = true;
        Iterator<Entry> i = entries.iterator();
        while (ret && i.hasNext()) {
            ret = this.writeEntry(i.next());
        }
        return ret;
    }

    public boolean writeEntry(Entry entry) throws IOException, LDIFException {
        Validator.ensureNotNull(entry);
        return entry.toLDIF(this.exportConfig);
    }

    public boolean writeTemplateEntry(TemplateEntry templateEntry) throws IOException, LDIFException {
        Validator.ensureNotNull(templateEntry);
        return templateEntry.toLDIF(this.exportConfig);
    }

    public void writeChangeRecord(ChangeRecordEntry changeRecord) throws IOException {
        Validator.ensureNotNull(changeRecord);
        BufferedWriter writer = this.exportConfig.getWriter();
        int wrapColumn = this.exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(changeRecord.getDN().toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        if (changeRecord instanceof AddChangeRecordEntry) {
            StringBuilder changeTypeLine = new StringBuilder("changetype: add");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
            AddChangeRecordEntry addRecord = (AddChangeRecordEntry)changeRecord;
            for (Attribute a : addRecord.getAttributes()) {
                for (AttributeValue v : a) {
                    StringBuilder line = new StringBuilder();
                    line.append(a.getNameWithOptions());
                    LDIFWriter.appendLDIFSeparatorAndValue(line, v.getValue());
                    LDIFWriter.writeLDIFLine(line, writer, wrapLines, wrapColumn);
                }
            }
        } else if (changeRecord instanceof DeleteChangeRecordEntry) {
            StringBuilder changeTypeLine = new StringBuilder("changetype: delete");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        } else if (changeRecord instanceof ModifyChangeRecordEntry) {
            StringBuilder changeTypeLine = new StringBuilder("changetype: modify");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
            ModifyChangeRecordEntry modifyRecord = (ModifyChangeRecordEntry)changeRecord;
            List<RawModification> mods = modifyRecord.getModifications();
            Iterator<RawModification> iterator = mods.iterator();
            while (iterator.hasNext()) {
                RawModification m = iterator.next();
                RawAttribute a = m.getAttribute();
                String attrName = a.getAttributeType();
                StringBuilder modTypeLine = new StringBuilder();
                modTypeLine.append(m.getModificationType().getLDIFName());
                modTypeLine.append(": ");
                modTypeLine.append(attrName);
                LDIFWriter.writeLDIFLine(modTypeLine, writer, wrapLines, wrapColumn);
                for (ByteString s : a.getValues()) {
                    StringBuilder valueLine = new StringBuilder();
                    String stringValue = s.toString();
                    valueLine.append(attrName);
                    if (StaticUtils.needsBase64Encoding(stringValue)) {
                        valueLine.append(":: ");
                        valueLine.append(Base64.encode(s));
                    } else {
                        valueLine.append(": ");
                        valueLine.append(stringValue);
                    }
                    LDIFWriter.writeLDIFLine(valueLine, writer, wrapLines, wrapColumn);
                }
                if (!iterator.hasNext()) continue;
                StringBuilder dashLine = new StringBuilder("-");
                LDIFWriter.writeLDIFLine(dashLine, writer, wrapLines, wrapColumn);
            }
        } else if (changeRecord instanceof ModifyDNChangeRecordEntry) {
            StringBuilder changeTypeLine = new StringBuilder("changetype: moddn");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
            ModifyDNChangeRecordEntry modifyDNRecord = (ModifyDNChangeRecordEntry)changeRecord;
            StringBuilder newRDNLine = new StringBuilder();
            newRDNLine.append("newrdn: ");
            modifyDNRecord.getNewRDN().toString(newRDNLine);
            LDIFWriter.writeLDIFLine(newRDNLine, writer, wrapLines, wrapColumn);
            StringBuilder deleteOldRDNLine = new StringBuilder();
            deleteOldRDNLine.append("deleteoldrdn: ");
            if (modifyDNRecord.deleteOldRDN()) {
                deleteOldRDNLine.append("1");
            } else {
                deleteOldRDNLine.append("0");
            }
            LDIFWriter.writeLDIFLine(deleteOldRDNLine, writer, wrapLines, wrapColumn);
            DN newSuperiorDN = modifyDNRecord.getNewSuperiorDN();
            if (newSuperiorDN != null) {
                StringBuilder newSuperiorLine = new StringBuilder();
                newSuperiorLine.append("newsuperior: ");
                newSuperiorDN.toString(newSuperiorLine);
                LDIFWriter.writeLDIFLine(newSuperiorLine, writer, wrapLines, wrapColumn);
            }
        }
        writer.newLine();
    }

    public void writeAddChangeRecord(Entry entry) throws IOException {
        Validator.ensureNotNull(entry);
        BufferedWriter writer = this.exportConfig.getWriter();
        int wrapColumn = this.exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(entry.getDN().toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        StringBuilder changeTypeLine = new StringBuilder("changetype: add");
        LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        for (String s : entry.getObjectClasses().values()) {
            StringBuilder ocLine = new StringBuilder();
            ocLine.append("objectClass: ");
            ocLine.append(s);
            LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
        }
        for (AttributeType attrType : entry.getUserAttributes().keySet()) {
            List<Attribute> attrList = entry.getUserAttribute(attrType);
            for (Attribute a : attrList) {
                StringBuilder attrName = new StringBuilder(a.getName());
                for (String o : a.getOptions()) {
                    attrName.append(";");
                    attrName.append(o);
                }
                for (AttributeValue v : a) {
                    StringBuilder attrLine = new StringBuilder();
                    attrLine.append((CharSequence)attrName);
                    LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue());
                    LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                }
            }
        }
        writer.newLine();
    }

    public void writeDeleteChangeRecord(Entry entry, boolean commentEntry) throws IOException {
        Validator.ensureNotNull(entry);
        BufferedWriter writer = this.exportConfig.getWriter();
        int wrapColumn = this.exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(entry.getDN().toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        StringBuilder changeTypeLine = new StringBuilder("changetype: delete");
        LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        if (commentEntry) {
            for (String s : entry.getObjectClasses().values()) {
                StringBuilder ocLine = new StringBuilder();
                ocLine.append("# objectClass: ");
                ocLine.append(s);
                LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
            }
            for (AttributeType attrType : entry.getUserAttributes().keySet()) {
                List<Attribute> attrList = entry.getUserAttribute(attrType);
                for (Attribute a : attrList) {
                    StringBuilder attrName = new StringBuilder();
                    attrName.append("# ");
                    attrName.append(a.getName());
                    for (String o : a.getOptions()) {
                        attrName.append(";");
                        attrName.append(o);
                    }
                    for (AttributeValue v : a) {
                        StringBuilder attrLine = new StringBuilder();
                        attrLine.append((CharSequence)attrName);
                        LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue());
                        LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                    }
                }
            }
        }
        writer.newLine();
    }

    public void writeModifyChangeRecord(DN dn, List<Modification> modifications) throws IOException {
        Validator.ensureNotNull(dn, modifications);
        if (modifications.isEmpty()) {
            return;
        }
        BufferedWriter writer = this.exportConfig.getWriter();
        int wrapColumn = this.exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(dn.toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        StringBuilder changeTypeLine = new StringBuilder("changetype: modify");
        LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        Iterator<Modification> iterator = modifications.iterator();
        block6: while (iterator.hasNext()) {
            Modification m = iterator.next();
            Attribute a = m.getAttribute();
            StringBuilder nameBuffer = new StringBuilder(a.getName());
            for (String o : a.getOptions()) {
                nameBuffer.append(";");
                nameBuffer.append(o);
            }
            String name = nameBuffer.toString();
            StringBuilder modTypeLine = new StringBuilder();
            switch (m.getModificationType()) {
                case ADD: {
                    modTypeLine.append("add: ");
                    modTypeLine.append(name);
                    break;
                }
                case DELETE: {
                    modTypeLine.append("delete: ");
                    modTypeLine.append(name);
                    break;
                }
                case REPLACE: {
                    modTypeLine.append("replace: ");
                    modTypeLine.append(name);
                    break;
                }
                case INCREMENT: {
                    modTypeLine.append("increment: ");
                    modTypeLine.append(name);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            LDIFWriter.writeLDIFLine(modTypeLine, writer, wrapLines, wrapColumn);
            for (AttributeValue v : a) {
                StringBuilder valueLine = new StringBuilder();
                valueLine.append(name);
                LDIFWriter.appendLDIFSeparatorAndValue(valueLine, v.getValue());
                LDIFWriter.writeLDIFLine(valueLine, writer, wrapLines, wrapColumn);
            }
            if (iterator.hasNext()) {
                writer.write("-");
                writer.newLine();
                continue;
            }
            writer.newLine();
        }
    }

    public void writeModifyDNChangeRecord(DN dn, RDN newRDN, boolean deleteOldRDN, DN newSuperior) throws IOException {
        StringBuilder changeTypeLine;
        Validator.ensureNotNull(dn, newRDN);
        BufferedWriter writer = this.exportConfig.getWriter();
        int wrapColumn = this.exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(dn.toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        if (newSuperior == null) {
            changeTypeLine = new StringBuilder("changetype: modrdn");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        } else {
            changeTypeLine = new StringBuilder("changetype: moddn");
            LDIFWriter.writeLDIFLine(changeTypeLine, writer, wrapLines, wrapColumn);
        }
        StringBuilder rdnLine = new StringBuilder();
        rdnLine.append("newrdn");
        LDIFWriter.appendLDIFSeparatorAndValue(rdnLine, ByteString.valueOf(newRDN.toString()));
        LDIFWriter.writeLDIFLine(rdnLine, writer, wrapLines, wrapColumn);
        StringBuilder deleteOldRDNLine = new StringBuilder();
        deleteOldRDNLine.append("deleteoldrdn: ");
        deleteOldRDNLine.append(deleteOldRDN ? "1" : "0");
        LDIFWriter.writeLDIFLine(deleteOldRDNLine, writer, wrapLines, wrapColumn);
        if (newSuperior != null) {
            StringBuilder newSuperiorLine = new StringBuilder();
            newSuperiorLine.append("newsuperior");
            LDIFWriter.appendLDIFSeparatorAndValue(newSuperiorLine, ByteString.valueOf(newSuperior.toString()));
            LDIFWriter.writeLDIFLine(newSuperiorLine, writer, wrapLines, wrapColumn);
        }
        writer.newLine();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public static void appendLDIFSeparatorAndValue(StringBuilder buffer, ByteSequence valueBytes) {
        LDIFWriter.appendLDIFSeparatorAndValue(buffer, valueBytes, false, false);
    }

    public static void appendLDIFSeparatorAndValue(StringBuilder buffer, ByteSequence valueBytes, boolean isURL, boolean isBase64) {
        Validator.ensureNotNull(buffer, valueBytes);
        if (valueBytes == null || valueBytes.length() == 0) {
            if (isURL) {
                buffer.append(":< ");
            } else if (isBase64) {
                buffer.append(":: ");
            } else {
                buffer.append(": ");
            }
            return;
        }
        if (isURL) {
            buffer.append(":< ");
            buffer.append(valueBytes.toString());
        } else if (isBase64) {
            buffer.append(":: ");
            buffer.append(valueBytes.toString());
        } else if (StaticUtils.needsBase64Encoding(valueBytes)) {
            buffer.append(":: ");
            buffer.append(Base64.encode(valueBytes));
        } else {
            buffer.append(": ");
            buffer.append(valueBytes.toString());
        }
    }

    public static void writeLDIFLine(StringBuilder line, BufferedWriter writer, boolean wrapLines, int wrapColumn) throws IOException {
        Validator.ensureNotNull(line, writer);
        int length = line.length();
        if (wrapLines && length > wrapColumn) {
            writer.write(line.substring(0, wrapColumn));
            writer.newLine();
            for (int pos = wrapColumn; pos < length; pos += wrapColumn - 1) {
                int writeLength = Math.min(wrapColumn - 1, length - pos);
                writer.write(32);
                writer.write(line.substring(pos, pos + writeLength));
                writer.newLine();
            }
        } else {
            writer.write(line.toString());
            writer.newLine();
        }
    }
}

