/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.DynamicConstants;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class BuildVersion
implements Comparable<BuildVersion> {
    private final int major;
    private final int minor;
    private final int point;
    private final long rev;
    private static final BuildVersion BINARY_VERSION = new BuildVersion(DynamicConstants.MAJOR_VERSION, DynamicConstants.MINOR_VERSION, DynamicConstants.POINT_VERSION, DynamicConstants.REVISION_NUMBER);

    public static BuildVersion binaryVersion() {
        return BINARY_VERSION;
    }

    public static BuildVersion instanceVersion() throws InitializationException {
        String buildInfo = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "buildinfo";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(buildInfo));
            String s = reader.readLine();
            if (s != null) {
                BuildVersion buildVersion = BuildVersion.valueOf(s);
                return buildVersion;
            }
            try {
                throw new InitializationException(ToolMessages.ERR_BUILDVERSION_MALFORMED.get(buildInfo));
            }
            catch (IOException e) {
                throw new InitializationException(ToolMessages.ERR_BUILDVERSION_NOT_FOUND.get(buildInfo));
            }
            catch (IllegalArgumentException e) {
                throw new InitializationException(ToolMessages.ERR_BUILDVERSION_MALFORMED.get(buildInfo));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void checkVersionMismatch() throws InitializationException {
        if (!BuildVersion.binaryVersion().toString().equals(BuildVersion.instanceVersion().toString())) {
            throw new InitializationException(ToolMessages.ERR_BUILDVERSION_MISMATCH.get(BuildVersion.binaryVersion().toString(), BuildVersion.instanceVersion().toString()));
        }
    }

    public static BuildVersion valueOf(String s) throws IllegalArgumentException {
        String[] fields = s.split("\\.");
        if (fields.length != 4) {
            throw new IllegalArgumentException("Invalid version string " + s);
        }
        int major = Integer.parseInt(fields[0]);
        int minor = Integer.parseInt(fields[1]);
        int point = Integer.parseInt(fields[2]);
        long rev = Long.parseLong(fields[3]);
        return new BuildVersion(major, minor, point, rev);
    }

    public BuildVersion(int major, int minor, int point, long rev) {
        this.major = major;
        this.minor = minor;
        this.point = point;
        this.rev = rev;
    }

    @Override
    public int compareTo(BuildVersion version) {
        if (this.major == version.major) {
            if (this.minor == version.minor) {
                if (this.point == version.point) {
                    if (this.rev == version.rev) {
                        return 0;
                    }
                    if (this.rev < version.rev) {
                        return -1;
                    }
                } else if (this.point < version.point) {
                    return -1;
                }
            } else if (this.minor < version.minor) {
                return -1;
            }
        } else if (this.major < version.major) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuildVersion) {
            BuildVersion other = (BuildVersion)obj;
            return this.major == other.major && this.minor == other.minor && this.point == other.point && this.rev == other.rev;
        }
        return false;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPointVersion() {
        return this.point;
    }

    public long getRevisionNumber() {
        return this.rev;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.major, this.minor, this.point, (int)(this.rev >>> 32), (int)(this.rev & 0xFFFFL)});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        builder.append('.');
        builder.append(this.minor);
        builder.append('.');
        builder.append(this.point);
        builder.append('.');
        builder.append(this.rev);
        return builder.toString();
    }
}

