/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum SSLClientAuthPolicy {
    DISABLED("Disabled"),
    OPTIONAL("Optional"),
    REQUIRED("Required");

    private String policyName;

    private SSLClientAuthPolicy(String policyName) {
        this.policyName = policyName;
    }

    public static SSLClientAuthPolicy policyForName(String policyName) {
        String lowerName = policyName.toLowerCase();
        if (lowerName.equals("disabled") || lowerName.equals("off") || lowerName.equals("never")) {
            return DISABLED;
        }
        if (lowerName.equals("optional") || lowerName.equals("allowed")) {
            return OPTIONAL;
        }
        if (lowerName.equals("required") || lowerName.equals("on") || lowerName.equals("always")) {
            return REQUIRED;
        }
        return null;
    }

    public String toString() {
        return this.policyName;
    }
}

