/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public abstract class RawModification {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawModification create(ModificationType modificationType, RawAttribute attribute) {
        return new LDAPModification(modificationType, attribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, String attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, ByteString attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, ArrayList<ByteString> attributeValues) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValues);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public abstract ModificationType getModificationType();

    public abstract void setModificationType(ModificationType var1);

    public abstract RawAttribute getAttribute();

    public abstract void setAttribute(RawAttribute var1);

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence();
        stream.writeEnumerated(this.getModificationType().intValue());
        this.getAttribute().write(stream);
        stream.writeEndSequence();
    }

    public static LDAPModification decode(ASN1Reader reader) throws LDAPException {
        LDAPAttribute attribute;
        ModificationType modificationType;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            int type = (int)reader.readInteger();
            switch (type) {
                case 0: {
                    modificationType = ModificationType.ADD;
                    break;
                }
                case 1: {
                    modificationType = ModificationType.DELETE;
                    break;
                }
                case 2: {
                    modificationType = ModificationType.REPLACE;
                    break;
                }
                case 3: {
                    modificationType = ModificationType.INCREMENT;
                    break;
                }
                default: {
                    Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_MOD_TYPE.get(type);
                    throw new LDAPException(2, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_MOD_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attribute = RawAttribute.decode(reader);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_ATTR.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFICATION_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPModification(modificationType, attribute);
    }

    public abstract Modification toModification() throws LDAPException;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

