/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ConfigChangeResult {
    private List<Message> messages;
    private boolean adminActionRequired;
    private ResultCode resultCode;

    public ConfigChangeResult(ResultCode resultCode, boolean adminActionRequired) {
        this.resultCode = resultCode;
        this.adminActionRequired = adminActionRequired;
        this.messages = new ArrayList<Message>();
    }

    public ConfigChangeResult(ResultCode resultCode, boolean adminActionRequired, List<Message> messages) {
        this.resultCode = resultCode;
        this.adminActionRequired = adminActionRequired;
        this.messages = messages;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public boolean adminActionRequired() {
        return this.adminActionRequired;
    }

    public void setAdminActionRequired(boolean adminActionRequired) {
        this.adminActionRequired = adminActionRequired;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ConfigChangeResult(result=");
        buffer.append(this.resultCode.toString());
        buffer.append(", adminActionRequired=");
        buffer.append(this.adminActionRequired);
        buffer.append(", messages={");
        if (!this.messages.isEmpty()) {
            Iterator<Message> iterator = this.messages.iterator();
            Message firstMessage = iterator.next();
            buffer.append(firstMessage);
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
        }
        buffer.append("})");
    }
}

