/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractAttribute;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AttributeBuilder
implements Iterable<AttributeValue> {
    private AttributeType attributeType = null;
    private String name = null;
    private SortedSet<String> normalizedOptions = null;
    private final SmallSet<String> options = new SmallSet();
    private final SmallSet<AttributeValue> values = new SmallSet();

    static Attribute create(AttributeType attributeType, String name, Set<AttributeValue> values) {
        return new RealAttributeNoOptions(attributeType, name, values);
    }

    private static AttributeType getAttributeType(String attributeName) {
        String lc = StaticUtils.toLowerCase(attributeName);
        AttributeType type = DirectoryServer.getAttributeType(lc);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(attributeName);
        }
        return type;
    }

    public AttributeBuilder() {
    }

    public AttributeBuilder(Attribute attribute) {
        this(attribute, false);
    }

    public AttributeBuilder(Attribute attribute, boolean omitValues) {
        this(attribute.getAttributeType(), attribute.getName());
        for (String option : attribute.getOptions()) {
            this.setOption(option);
        }
        if (!omitValues) {
            this.addAll(attribute);
        }
    }

    public AttributeBuilder(AttributeType attributeType) {
        this(attributeType, attributeType.getNameOrOID());
    }

    public AttributeBuilder(AttributeType attributeType, String name) {
        Validator.ensureNotNull(attributeType, name);
        this.attributeType = attributeType;
        this.name = name;
    }

    public AttributeBuilder(String attributeName) {
        this(AttributeBuilder.getAttributeType(attributeName), attributeName);
    }

    public boolean add(AttributeValue value) {
        return this.values.add(value);
    }

    public boolean add(String valueString) {
        return this.add(AttributeValues.create(this.attributeType, valueString));
    }

    public boolean add(ByteString value) {
        return this.add(AttributeValues.create(this.attributeType, value));
    }

    public boolean addAll(Attribute attribute) {
        boolean wasModified = false;
        for (AttributeValue v : attribute) {
            wasModified |= this.add(v);
        }
        return wasModified;
    }

    public boolean addAll(Collection<AttributeValue> values) {
        return this.values.addAll(values);
    }

    public void clear() {
        this.values.clear();
    }

    public boolean contains(AttributeValue value) {
        return this.values.contains(value);
    }

    public boolean containsAll(Collection<AttributeValue> values) {
        return this.values.containsAll(values);
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Iterator<AttributeValue> iterator() {
        return this.values.iterator();
    }

    public boolean remove(AttributeValue value) {
        return this.values.remove(value);
    }

    public boolean remove(String valueString) {
        AttributeValue value = AttributeValues.create(this.attributeType, valueString);
        return this.remove(value);
    }

    public boolean removeAll(Attribute attribute) {
        boolean wasModified = false;
        for (AttributeValue v : attribute) {
            wasModified |= this.remove(v);
        }
        return wasModified;
    }

    public boolean removeAll(Collection<AttributeValue> values) {
        return this.values.removeAll(values);
    }

    public void replace(AttributeValue value) {
        this.clear();
        this.add(value);
    }

    public void replace(String valueString) {
        AttributeValue value = AttributeValues.create(this.attributeType, valueString);
        this.replace(value);
    }

    public void replaceAll(Attribute attribute) {
        this.clear();
        this.addAll(attribute);
    }

    public void replaceAll(Collection<AttributeValue> values) {
        this.clear();
        this.addAll(values);
    }

    public void setAttributeType(AttributeType attributeType) {
        this.setAttributeType(attributeType, attributeType.getNameOrOID());
    }

    public void setAttributeType(AttributeType attributeType, String name) {
        Validator.ensureNotNull(attributeType, name);
        this.attributeType = attributeType;
        this.name = name;
    }

    public void setAttributeType(String attributeName) {
        this.setAttributeType(AttributeBuilder.getAttributeType(attributeName), attributeName);
    }

    public AttributeBuilder setInitialCapacity(int initialCapacity) throws IllegalStateException {
        this.values.setInitialCapacity(initialCapacity);
        return this;
    }

    public boolean setOption(String option) {
        switch (this.options.size()) {
            case 0: {
                return this.options.add(option);
            }
            case 1: {
                this.normalizedOptions = new TreeSet<String>();
                this.normalizedOptions.add(StaticUtils.toLowerCase((String)((SmallSet)this.options).firstElement));
                if (!this.normalizedOptions.add(StaticUtils.toLowerCase(option))) break;
                this.options.add(option);
                return true;
            }
            default: {
                if (!this.normalizedOptions.add(StaticUtils.toLowerCase(option))) break;
                this.options.add(option);
                return true;
            }
        }
        return false;
    }

    public boolean setOptions(Collection<String> options) {
        boolean isModified = false;
        for (String option : options) {
            isModified |= this.setOption(option);
        }
        return isModified;
    }

    public boolean optionsEqual(Set<String> options) {
        if (options == null) {
            return this.options.isEmpty();
        }
        if (this.options.size() != options.size()) {
            return false;
        }
        for (String option : options) {
            if (this.options.contains(option)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.values.size();
    }

    public Attribute toAttribute() throws IllegalStateException {
        RealAttribute attribute;
        if (this.attributeType == null) {
            throw new IllegalStateException("Undefined attribute type or name");
        }
        Set<Object> newValues = ((SmallSet)this.values).elements != null ? Collections.unmodifiableSet(((SmallSet)this.values).elements) : (((SmallSet)this.values).firstElement != null ? Collections.singleton(((SmallSet)this.values).firstElement) : Collections.emptySet());
        switch (this.options.size()) {
            case 0: {
                attribute = new RealAttributeNoOptions(this.attributeType, this.name, newValues);
                break;
            }
            case 1: {
                attribute = new RealAttributeSingleOption(this.attributeType, this.name, newValues, (String)((SmallSet)this.options).firstElement);
                break;
            }
            default: {
                attribute = new RealAttributeManyOptions(this.attributeType, this.name, newValues, Collections.unmodifiableSet(((SmallSet)this.options).elements), Collections.unmodifiableSortedSet(this.normalizedOptions));
            }
        }
        this.attributeType = null;
        this.name = null;
        this.normalizedOptions = null;
        this.options.clear();
        this.values.clear();
        return attribute;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AttributeBuilder(");
        builder.append(String.valueOf(this.name));
        for (String option : this.options) {
            builder.append(';');
            builder.append(option);
        }
        builder.append(", {");
        boolean firstValue = true;
        for (AttributeValue value : this.values) {
            if (!firstValue) {
                builder.append(", ");
            }
            value.toString(builder);
            firstValue = false;
        }
        builder.append("})");
        return builder.toString();
    }

    private static final class SmallSet<T>
    extends AbstractSet<T>
    implements Set<T> {
        private LinkedHashSet<T> elements = null;
        private T firstElement = null;

        @Override
        public boolean add(T e) {
            if (this.firstElement == null && this.elements == null) {
                this.firstElement = e;
                return true;
            }
            if (this.elements == null) {
                if (this.firstElement.equals(e)) {
                    return false;
                }
                this.elements = new LinkedHashSet(2);
                this.elements.add(this.firstElement);
                this.firstElement = null;
            }
            return this.elements.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (this.elements != null) {
                return this.elements.addAll(c);
            }
            if (this.firstElement != null) {
                this.elements = new LinkedHashSet(1 + c.size());
                this.elements.add(this.firstElement);
                this.firstElement = null;
                return this.elements.addAll(c);
            }
            switch (c.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.firstElement = c.iterator().next();
                    return true;
                }
            }
            this.elements = new LinkedHashSet<T>(c);
            return true;
        }

        @Override
        public void clear() {
            this.firstElement = null;
            this.elements = null;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.elements != null) {
                return this.elements.iterator();
            }
            if (this.firstElement != null) {
                return new Iterator<T>(){
                    private boolean hasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext) {
                            throw new NoSuchElementException();
                        }
                        this.hasNext = false;
                        return SmallSet.this.firstElement;
                    }

                    @Override
                    public void remove() {
                        if (this.hasNext || SmallSet.this.firstElement == null) {
                            throw new IllegalStateException();
                        }
                        SmallSet.this.firstElement = null;
                    }
                };
            }
            return Collections.emptySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (this.elements != null) {
                return this.elements.remove(o);
            }
            if (this.firstElement != null && this.firstElement.equals(o)) {
                this.firstElement = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            if (this.elements != null) {
                return this.elements.contains(o);
            }
            return this.firstElement != null && this.firstElement.equals(o);
        }

        public void setInitialCapacity(int initialCapacity) throws IllegalStateException {
            Validator.ensureTrue(initialCapacity >= 0);
            if (this.elements != null) {
                throw new IllegalStateException();
            }
            if (initialCapacity > 1) {
                this.elements = new LinkedHashSet(initialCapacity);
            }
        }

        @Override
        public int size() {
            if (this.elements != null) {
                return this.elements.size();
            }
            if (this.firstElement != null) {
                return 1;
            }
            return 0;
        }
    }

    private static final class RealAttributeSingleOption
    extends RealAttribute {
        private final String normalizedOption;
        private final Set<String> option;

        private RealAttributeSingleOption(AttributeType attributeType, String name, Set<AttributeValue> values, String option) {
            super(attributeType, name, values);
            this.option = Collections.singleton(option);
            this.normalizedOption = StaticUtils.toLowerCase(option);
        }

        @Override
        public Set<String> getOptions() {
            return this.option;
        }

        @Override
        public boolean hasOption(String option) {
            String s = StaticUtils.toLowerCase(option);
            return this.normalizedOption.equals(s);
        }

        @Override
        public boolean hasOptions() {
            return true;
        }
    }

    private static final class RealAttributeNoOptions
    extends RealAttribute {
        private RealAttributeNoOptions(AttributeType attributeType, String name, Set<AttributeValue> values) {
            super(attributeType, name, values);
        }

        @Override
        public String getNameWithOptions() {
            return this.getName();
        }

        @Override
        public Set<String> getOptions() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasAllOptions(Collection<String> options) {
            return options == null || options.isEmpty();
        }

        @Override
        public boolean hasOption(String option) {
            return false;
        }

        @Override
        public boolean hasOptions() {
            return false;
        }

        @Override
        public boolean optionsEqual(Set<String> options) {
            return options == null || options.isEmpty();
        }
    }

    private static final class RealAttributeManyOptions
    extends RealAttribute {
        private final SortedSet<String> normalizedOptions;
        private final Set<String> options;

        private RealAttributeManyOptions(AttributeType attributeType, String name, Set<AttributeValue> values, Set<String> options, SortedSet<String> normalizedOptions) {
            super(attributeType, name, values);
            this.options = options;
            this.normalizedOptions = normalizedOptions;
        }

        @Override
        public Set<String> getOptions() {
            return this.options;
        }

        @Override
        public boolean hasOption(String option) {
            String s = StaticUtils.toLowerCase(option);
            return this.normalizedOptions.contains(s);
        }

        @Override
        public boolean hasOptions() {
            return true;
        }
    }

    private static abstract class RealAttribute
    extends AbstractAttribute {
        private static final DebugTracer TRACER = DebugLogger.getTracer();
        private final AttributeType attributeType;
        private final String name;
        private final Set<AttributeValue> values;

        private RealAttribute(AttributeType attributeType, String name, Set<AttributeValue> values) {
            this.attributeType = attributeType;
            this.name = name;
            this.values = values;
        }

        @Override
        public final ConditionResult approximatelyEqualTo(AttributeValue value) {
            ByteString normalizedValue;
            ApproximateMatchingRule matchingRule = this.attributeType.getApproximateMatchingRule();
            if (matchingRule == null) {
                return ConditionResult.UNDEFINED;
            }
            try {
                normalizedValue = matchingRule.normalizeValue(value.getValue());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
            ConditionResult result = ConditionResult.FALSE;
            for (AttributeValue v : this.values) {
                try {
                    ByteString nv = matchingRule.normalizeValue(v.getValue());
                    if (!matchingRule.approximatelyMatch(nv, normalizedValue)) continue;
                    return ConditionResult.TRUE;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
            return result;
        }

        @Override
        public final boolean contains(AttributeValue value) {
            return this.values.contains(value);
        }

        @Override
        public final boolean containsAll(Collection<AttributeValue> values) {
            return this.values.containsAll(values);
        }

        @Override
        public final AttributeType getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final ConditionResult greaterThanOrEqualTo(AttributeValue value) {
            ByteString normalizedValue;
            OrderingMatchingRule matchingRule = this.attributeType.getOrderingMatchingRule();
            if (matchingRule == null) {
                return ConditionResult.UNDEFINED;
            }
            try {
                normalizedValue = matchingRule.normalizeValue(value.getValue());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
            ConditionResult result = ConditionResult.FALSE;
            for (AttributeValue v : this.values) {
                try {
                    ByteString nv = matchingRule.normalizeValue(v.getValue());
                    int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                    if (comparisonResult < 0) continue;
                    return ConditionResult.TRUE;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
            return result;
        }

        @Override
        public final boolean isVirtual() {
            return false;
        }

        @Override
        public final Iterator<AttributeValue> iterator() {
            return this.values.iterator();
        }

        @Override
        public final ConditionResult lessThanOrEqualTo(AttributeValue value) {
            ByteString normalizedValue;
            OrderingMatchingRule matchingRule = this.attributeType.getOrderingMatchingRule();
            if (matchingRule == null) {
                return ConditionResult.UNDEFINED;
            }
            try {
                normalizedValue = matchingRule.normalizeValue(value.getValue());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
            ConditionResult result = ConditionResult.FALSE;
            for (AttributeValue v : this.values) {
                try {
                    ByteString nv = matchingRule.normalizeValue(v.getValue());
                    int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                    if (comparisonResult > 0) continue;
                    return ConditionResult.TRUE;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
            return result;
        }

        @Override
        public final ConditionResult matchesSubstring(ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
            ByteString normalizedSubFinal;
            ArrayList<ByteSequence> normalizedSubAny;
            ByteString normalizedSubInitial;
            SubstringMatchingRule matchingRule = this.attributeType.getSubstringMatchingRule();
            if (matchingRule == null) {
                return ConditionResult.UNDEFINED;
            }
            if (subInitial == null) {
                normalizedSubInitial = null;
            } else {
                try {
                    normalizedSubInitial = matchingRule.normalizeSubstring(subInitial);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return ConditionResult.UNDEFINED;
                }
            }
            if (subAny == null) {
                normalizedSubAny = null;
            } else {
                normalizedSubAny = new ArrayList<ByteSequence>(subAny.size());
                for (ByteString subAnyElement : subAny) {
                    try {
                        normalizedSubAny.add(matchingRule.normalizeSubstring(subAnyElement));
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return ConditionResult.UNDEFINED;
                    }
                }
            }
            if (subFinal == null) {
                normalizedSubFinal = null;
            } else {
                try {
                    normalizedSubFinal = matchingRule.normalizeSubstring(subFinal);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return ConditionResult.UNDEFINED;
                }
            }
            ConditionResult result = ConditionResult.FALSE;
            for (AttributeValue value : this.values) {
                try {
                    if (!matchingRule.valueMatchesSubstring(this.attributeType.getSubstringMatchingRule().normalizeValue(value.getValue()), normalizedSubInitial, normalizedSubAny, normalizedSubFinal)) continue;
                    return ConditionResult.TRUE;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    result = ConditionResult.UNDEFINED;
                }
            }
            return result;
        }

        @Override
        public final int size() {
            return this.values.size();
        }

        @Override
        public final void toString(StringBuilder buffer) {
            buffer.append("Attribute(");
            buffer.append(this.getNameWithOptions());
            buffer.append(", {");
            boolean firstValue = true;
            for (AttributeValue value : this.values) {
                if (!firstValue) {
                    buffer.append(", ");
                }
                value.toString(buffer);
                firstValue = false;
            }
            buffer.append("})");
        }
    }
}

