/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum AccountStatusNotificationType {
    ACCOUNT_TEMPORARILY_LOCKED("account-temporarily-locked"),
    ACCOUNT_PERMANENTLY_LOCKED("account-permanently-locked"),
    ACCOUNT_UNLOCKED("account-unlocked"),
    ACCOUNT_IDLE_LOCKED("account-idle-locked"),
    ACCOUNT_RESET_LOCKED("account-reset-locked"),
    ACCOUNT_DISABLED("account-disabled"),
    ACCOUNT_ENABLED("account-enabled"),
    ACCOUNT_EXPIRED("account-expired"),
    PASSWORD_EXPIRED("password-expired"),
    PASSWORD_EXPIRING("password-expiring"),
    PASSWORD_RESET("password-reset"),
    PASSWORD_CHANGED("password-changed");

    private String name;

    private AccountStatusNotificationType(String name) {
        this.name = name;
    }

    public static AccountStatusNotificationType typeForName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("account-temporarily-locked")) {
            return ACCOUNT_TEMPORARILY_LOCKED;
        }
        if (lowerName.equals("account-permanently-locked")) {
            return ACCOUNT_PERMANENTLY_LOCKED;
        }
        if (lowerName.equals("account-unlocked")) {
            return ACCOUNT_UNLOCKED;
        }
        if (lowerName.equals("account-idle-locked")) {
            return ACCOUNT_IDLE_LOCKED;
        }
        if (lowerName.equals("account-reset-locked")) {
            return ACCOUNT_RESET_LOCKED;
        }
        if (lowerName.equals("account-disabled")) {
            return ACCOUNT_DISABLED;
        }
        if (lowerName.equals("account-enabled")) {
            return ACCOUNT_ENABLED;
        }
        if (lowerName.equals("account-expired")) {
            return ACCOUNT_EXPIRED;
        }
        if (lowerName.equals("password-expired")) {
            return PASSWORD_EXPIRED;
        }
        if (lowerName.equals("password-expiring")) {
            return PASSWORD_EXPIRING;
        }
        if (lowerName.equals("password-reset")) {
            return PASSWORD_RESET;
        }
        if (lowerName.equals("password-changed")) {
            return PASSWORD_CHANGED;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

