/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.types.AccountStatusNotificationProperty;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class AccountStatusNotification {
    private AccountStatusNotificationType notificationType;
    private Entry userEntry;
    private Map<AccountStatusNotificationProperty, List<String>> notificationProperties;
    private Message message;

    public AccountStatusNotification(AccountStatusNotificationType notificationType, Entry userEntry, Message message, Map<AccountStatusNotificationProperty, List<String>> notificationProperties) {
        this.notificationType = notificationType;
        this.userEntry = userEntry;
        this.message = message;
        this.notificationProperties = notificationProperties == null ? new HashMap<AccountStatusNotificationProperty, List<String>>(0) : notificationProperties;
    }

    public AccountStatusNotificationType getNotificationType() {
        return this.notificationType;
    }

    public DN getUserDN() {
        return this.userEntry.getDN();
    }

    public Entry getUserEntry() {
        return this.userEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Map<AccountStatusNotificationProperty, List<String>> getNotificationProperties() {
        return this.notificationProperties;
    }

    public List<String> getNotificationProperty(AccountStatusNotificationProperty property) {
        return this.notificationProperties.get((Object)property);
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public static Map<AccountStatusNotificationProperty, List<String>> createProperties(PasswordPolicyState pwPolicyState, boolean tempLocked, int timeToExpiration, List<AttributeValue> oldPasswords, List<AttributeValue> newPasswords) {
        long secondsUntilUnlock;
        HashMap<AccountStatusNotificationProperty, List<String>> props = new HashMap<AccountStatusNotificationProperty, List<String>>(4);
        PasswordPolicy policy = pwPolicyState.getAuthenticationPolicy();
        ArrayList<String> propList = new ArrayList<String>(1);
        propList.add(policy.getDN().toString());
        props.put(AccountStatusNotificationProperty.PASSWORD_POLICY_DN, propList);
        if (tempLocked && (secondsUntilUnlock = policy.getLockoutDuration()) > 0L) {
            propList = new ArrayList(1);
            propList.add(String.valueOf(secondsUntilUnlock));
            props.put(AccountStatusNotificationProperty.SECONDS_UNTIL_UNLOCK, propList);
            propList = new ArrayList(1);
            propList.add(StaticUtils.secondsToTimeString(secondsUntilUnlock).toString());
            props.put(AccountStatusNotificationProperty.TIME_UNTIL_UNLOCK, propList);
            long unlockTime = System.currentTimeMillis() + 1000L * secondsUntilUnlock;
            propList = new ArrayList(1);
            propList.add(new Date(unlockTime).toString());
            props.put(AccountStatusNotificationProperty.ACCOUNT_UNLOCK_TIME, propList);
        }
        if (timeToExpiration >= 0) {
            propList = new ArrayList(1);
            propList.add(String.valueOf(timeToExpiration));
            props.put(AccountStatusNotificationProperty.SECONDS_UNTIL_EXPIRATION, propList);
            propList = new ArrayList(1);
            propList.add(StaticUtils.secondsToTimeString(timeToExpiration).toString());
            props.put(AccountStatusNotificationProperty.TIME_UNTIL_EXPIRATION, propList);
            long expTime = System.currentTimeMillis() + (long)(1000 * timeToExpiration);
            propList = new ArrayList(1);
            propList.add(new Date(expTime).toString());
            props.put(AccountStatusNotificationProperty.PASSWORD_EXPIRATION_TIME, propList);
        }
        if (oldPasswords != null && !oldPasswords.isEmpty()) {
            propList = new ArrayList(oldPasswords.size());
            for (AttributeValue v : oldPasswords) {
                propList.add(v.getValue().toString());
            }
            props.put(AccountStatusNotificationProperty.OLD_PASSWORD, propList);
        }
        if (newPasswords != null && !newPasswords.isEmpty()) {
            propList = new ArrayList(newPasswords.size());
            for (AttributeValue v : newPasswords) {
                propList.add(v.getValue().toString());
            }
            props.put(AccountStatusNotificationProperty.NEW_PASSWORD, propList);
        }
        return props;
    }

    public String toString() {
        return "AccountStatusNotification(type=" + this.notificationType.getName() + ",dn=" + this.userEntry.getDN() + ",message=" + this.message + ")";
    }
}

