/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.opends.messages.ConfigMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.tools.upgrade.FileManager;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;

final class UpgradeUtils {
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());
    static final File configDirectory = new File(UpgradeUtils.getInstallationPath(), "config");
    static final File configSchemaDirectory = new File(UpgradeUtils.getInstallationPath(), "config" + File.separator + "schema");
    static final File templateDirectory = new File(UpgradeUtils.getInstallationPath(), "config" + File.separator + "template");
    static final File templateConfigSchemaDirectory = new File(UpgradeUtils.getInstallationPath(), "template" + File.separator + "config" + File.separator + "schema");
    static final File templateConfigDirectory = new File(UpgradeUtils.getInstallationPath(), "template" + File.separator + "config");
    static final File configSnmpSecurityDirectory = new File(UpgradeUtils.getInstallationPath(), "config" + File.separator + "snmp" + File.separator + "security");

    public static String getInstallPathFromClasspath() {
        String installPath = DirectoryServer.getServerRoot();
        if (installPath != null) {
            return installPath;
        }
        String sep = System.getProperty("path.separator");
        String[] classPaths = System.getProperty("java.class.path").split(sep);
        String path = UpgradeUtils.getInstallPath(classPaths);
        if (path != null) {
            File f = new File(path).getAbsoluteFile();
            File librariesDir = f.getParentFile();
            try {
                installPath = librariesDir.getParentFile().getCanonicalPath();
            }
            catch (IOException ioe) {
                installPath = librariesDir.getParent();
            }
        }
        return installPath;
    }

    private static String getInstallPath(String[] classPaths) {
        for (String classPath : classPaths) {
            String normPath = classPath.replace(File.separatorChar, '/');
            if (!normPath.endsWith("lib/bootstrap.jar")) continue;
            return classPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstancePathFromInstallPath(String installPath) {
        String string;
        File instanceLoc;
        BufferedReader reader;
        block8: {
            String instancePathFileName = "/etc/opendj/instance.loc";
            File configureScriptPath = new File(installPath + File.separator + "configure");
            File f = new File(instancePathFileName);
            if (!(configureScriptPath.exists() && f.exists() || (f = new File(instancePathFileName = installPath + File.separator + "instance.loc")).exists())) {
                return installPath;
            }
            try {
                reader = new BufferedReader(new FileReader(instancePathFileName));
            }
            catch (Exception e) {
                return installPath;
            }
            String line = reader.readLine();
            instanceLoc = new File(line.trim());
            if (!instanceLoc.isAbsolute()) break block8;
            String string2 = instanceLoc.getAbsolutePath();
            StaticUtils.close(reader);
            return string2;
        }
        try {
            string = new File(installPath + File.separator + instanceLoc.getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            String string3;
            try {
                string3 = installPath;
            }
            catch (Throwable throwable) {
                StaticUtils.close(reader);
                throw throwable;
            }
            StaticUtils.close(reader);
            return string3;
        }
        StaticUtils.close(reader);
        return string;
    }

    public static String getPath(File f) {
        String path = null;
        if (f != null) {
            try {
                File canonical;
                f = canonical = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            path = f.toString();
        }
        return path;
    }

    public static String getPath(String parentPath, String relativePath) {
        return UpgradeUtils.getPath(new File(new File(parentPath), relativePath));
    }

    public static boolean isWindows() {
        return SetupUtils.isWindows();
    }

    public static boolean isUnix() {
        return SetupUtils.isUnix();
    }

    public static boolean isParentOf(File ancestor, File descendant) {
        if (ancestor != null) {
            if (ancestor.equals(descendant)) {
                return false;
            }
            while (descendant != null && !ancestor.equals(descendant)) {
                descendant = descendant.getParentFile();
            }
        }
        return ancestor != null && descendant != null;
    }

    public static boolean isDescendant(File descendant, File path) {
        boolean isDescendant = false;
        if (descendant != null && path != null) {
            File parent = descendant.getParentFile();
            while (parent != null && !isDescendant) {
                isDescendant = path.equals(parent);
                if (isDescendant) continue;
                parent = parent.getParentFile();
            }
        }
        return isDescendant;
    }

    static final String getInstancePath() {
        String installPath = UpgradeUtils.getInstallationPath();
        if (installPath == null) {
            return null;
        }
        return UpgradeUtils.getInstancePathFromInstallPath(installPath);
    }

    static final String getInstallationPath() {
        String path;
        String installationPath = System.getProperty("INSTALL_ROOT");
        if (installationPath == null && (path = UpgradeUtils.getInstallPathFromClasspath()) != null) {
            File f = new File(path);
            installationPath = f.getParentFile() != null && f.getParentFile().getParentFile() != null && new File(f.getParentFile().getParentFile(), "locks").exists() ? UpgradeUtils.getPath(f.getParentFile().getParentFile()) : path;
        }
        return installationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SortedMap<String, LinkedList<String>> getLocalBackends() {
        File configLdif = new File(configDirectory, "config.ldif");
        TreeMap<String, LinkedList<String>> result = new TreeMap<String, LinkedList<String>>();
        LDIFEntryReader entryReader = null;
        try {
            entryReader = new LDIFEntryReader((InputStream)new FileInputStream(configLdif));
            Filter filter = Filter.equality((String)"objectclass", (Object)"ds-cfg-local-db-backend");
            Matcher includeFilter = filter.matcher();
            entryReader.setIncludeFilter(includeFilter);
            Entry entry = null;
            while (entryReader.hasNext()) {
                LinkedList<String> dataRelativesToBck = new LinkedList<String>();
                entry = entryReader.readEntry();
                dataRelativesToBck.add(entry.getAttribute("ds-cfg-db-directory").firstValueAsString());
                dataRelativesToBck.add(entry.getAttribute("ds-cfg-enabled").firstValueAsString());
                result.put(entry.getAttribute("ds-cfg-backend-id").firstValueAsString(), dataRelativesToBck);
            }
        }
        catch (Exception ex) {
            try {
                LOG.log(Level.SEVERE, ex.getMessage());
            }
            catch (Throwable throwable) {
                StaticUtils.close(new Closeable[]{entryReader});
                throw throwable;
            }
            StaticUtils.close(new Closeable[]{entryReader});
        }
        StaticUtils.close(new Closeable[]{entryReader});
        return result;
    }

    static final int updateConfigFile(String configPath, LDAPFilter filter, PersistentSearchChangeType changeType, String ... lines) throws IOException {
        File original = new File(configPath);
        File copyConfig = File.createTempFile("copyConfig", ".tmp", original.getParentFile());
        int changeCount = 0;
        LDIFEntryReader entryReader = null;
        LDIFEntryWriter writer = null;
        try {
            entryReader = new LDIFEntryReader((InputStream)new FileInputStream(configPath));
            entryReader.setSchemaValidationPolicy(SchemaValidationPolicy.ignoreAll());
            writer = new LDIFEntryWriter((OutputStream)new FileOutputStream(copyConfig));
            writer.setWrapColumn(80);
            writer.writeComment((CharSequence)ConfigMessages.INFO_CONFIG_FILE_HEADER.get());
            writer.setWrapColumn(0);
            Entry entry = null;
            boolean alreadyExist = false;
            while (entryReader.hasNext()) {
                entry = entryReader.readEntry();
                if (filter != null && Filter.valueOf((String)filter.toString()).matches(entry) == ConditionResult.TRUE) {
                    try {
                        ModifyRequest mr = Requests.newModifyRequest((String[])UpgradeUtils.readLDIFLines(entry.getName(), changeType, lines));
                        entry = Entries.modifyEntryPermissive((Entry)entry, (Collection)mr.getModifications());
                        ++changeCount;
                        LOG.log(Level.INFO, String.format("The following entry has been modified : %s", entry.getName()));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage());
                    }
                }
                if (filter == null && changeType == PersistentSearchChangeType.ADD && ("dn: " + entry.getName()).equals(lines[0])) {
                    LOG.log(Level.INFO, String.format("Entry %s found", entry.getName().toString()));
                    alreadyExist = true;
                }
                writer.writeEntry(entry);
            }
            if (filter == null && changeType == PersistentSearchChangeType.ADD && !alreadyExist) {
                AddRequest ar = Requests.newAddRequest((String[])lines);
                writer.writeEntry((Entry)ar);
                LOG.log(Level.INFO, String.format("Entry successfully added %s in %s", entry.getName().toString(), original.getAbsolutePath()));
                ++changeCount;
            }
        }
        catch (Exception ex) {
            try {
                throw new IOException(ex.getMessage());
            }
            catch (Throwable throwable) {
                StaticUtils.close(new Closeable[]{entryReader, writer});
                throw throwable;
            }
        }
        StaticUtils.close(new Closeable[]{entryReader, writer});
        try {
            FileManager.rename(copyConfig, new File(configPath));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            FileManager.deleteRecursively(original);
            throw e;
        }
        return changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int updateSchemaFile(File templateFile, File destination, String[] attributes, String[] objectClasses) throws IOException {
        int changeCount = 0;
        LDIFEntryReader reader = null;
        BufferedReader br = null;
        FileWriter fw = null;
        File copy = File.createTempFile("copySchema", ".tmp", destination.getParentFile());
        try {
            String definition;
            reader = new LDIFEntryReader((InputStream)new FileInputStream(templateFile));
            LinkedList<String> definitionsList = new LinkedList<String>();
            Entry schemaEntry = reader.readEntry();
            Schema schema = null;
            schema = new SchemaBuilder(Schema.getCoreSchema()).addSchema(schemaEntry, true).toSchema();
            if (attributes != null) {
                for (String att : attributes) {
                    try {
                        definition = "attributeTypes: " + schema.getAttributeType(att);
                        definitionsList.add(definition);
                        LOG.log(Level.INFO, String.format("Added %s", definition));
                    }
                    catch (UnknownSchemaElementException e) {
                        LOG.log(Level.SEVERE, ToolMessages.ERR_UPGRADE_UNKNOWN_OC_ATT.get("attribute", att).toString());
                    }
                }
            }
            if (objectClasses != null) {
                for (String oc : objectClasses) {
                    try {
                        definition = "objectClasses: " + schema.getObjectClass(oc);
                        definitionsList.add(definition);
                        LOG.log(Level.INFO, String.format("Added %s", definition));
                    }
                    catch (UnknownSchemaElementException e) {
                        LOG.log(Level.SEVERE, ToolMessages.ERR_UPGRADE_UNKNOWN_OC_ATT.get("object class", oc).toString());
                    }
                }
            }
            br = new BufferedReader(new FileReader(destination));
            fw = new FileWriter(copy);
            String line = br.readLine();
            while (line != null && !"".equals(line)) {
                fw.write(line + ServerConstants.EOL);
                line = br.readLine();
            }
            for (String definition2 : definitionsList) {
                UpgradeUtils.writeLine(fw, definition2, 80);
                ++changeCount;
            }
            fw.write(ServerConstants.EOL);
        }
        catch (Throwable throwable) {
            StaticUtils.close(new Closeable[]{br, fw, reader});
            throw throwable;
        }
        StaticUtils.close(new Closeable[]{br, fw, reader});
        try {
            FileManager.rename(copy, destination);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            FileManager.deleteRecursively(copy);
            throw e;
        }
        return changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateConfigUpgradeSchemaFile(File folder, String revision) throws IOException {
        LinkedHashMapEntry theNewSchemaEntry = new LinkedHashMapEntry();
        LDIFEntryReader reader = null;
        LDIFEntryWriter writer = null;
        try {
            if (folder.isDirectory()) {
                for (File f : folder.listFiles()) {
                    LOG.log(Level.INFO, String.format("Processing %s", f.getAbsolutePath()));
                    reader = new LDIFEntryReader((InputStream)new FileInputStream(f));
                    while (reader.hasNext()) {
                        try {
                            Entry entry = reader.readEntry();
                            theNewSchemaEntry.setName(entry.getName());
                            for (Attribute at : entry.getAllAttributes()) {
                                theNewSchemaEntry.addAttribute(at);
                            }
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, ex.getMessage());
                        }
                    }
                }
                File destination = new File(configDirectory, "upgrade" + File.separator + "schema.ldif." + revision);
                writer = new LDIFEntryWriter((OutputStream)new FileOutputStream(destination));
                writer.writeEntry((Entry)theNewSchemaEntry);
                LOG.log(Level.INFO, String.format("%s file created successfully.", destination.getAbsolutePath()));
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private static String[] readLDIFLines(DN dn, PersistentSearchChangeType changeType, String ... lines) {
        String[] modifiedLines = new String[lines.length + 2];
        int index = 0;
        if (changeType == PersistentSearchChangeType.MODIFY) {
            modifiedLines[0] = "dn: " + dn;
            modifiedLines[1] = "changetype: modify";
            index = 2;
        }
        String[] arr$ = lines;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String line;
            modifiedLines[index] = line = arr$[i$];
            ++index;
        }
        return modifiedLines;
    }

    private static void writeLine(FileWriter fw, String line, int wrapColumn) throws IOException {
        int length = line.length();
        if (length > wrapColumn) {
            fw.write(line.subSequence(0, wrapColumn).toString());
            fw.write(ServerConstants.EOL);
            for (int pos = wrapColumn; pos < length; pos += wrapColumn - 1) {
                int writeLength = Math.min(wrapColumn - 1, length - pos);
                fw.write(" ");
                fw.write(line.subSequence(pos, pos + writeLength).toString());
                fw.write(ServerConstants.EOL);
            }
        } else {
            fw.write(line);
            fw.write(ServerConstants.EOL);
        }
    }

    private UpgradeUtils() {
        throw new AssertionError();
    }
}

