/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.upgrade.AbstractUpgradeTask;
import org.opends.server.tools.upgrade.FileManager;
import org.opends.server.tools.upgrade.ProgressNotificationCallback;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.tools.upgrade.UpgradeContext;
import org.opends.server.tools.upgrade.UpgradeTask;
import org.opends.server.tools.upgrade.UpgradeUtils;
import org.opends.server.util.BuildVersion;

public final class UpgradeTasks {
    static int countErrors = 0;
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());

    public static UpgradeTask addConfigEntry(Message summary, String ... ldif) {
        return UpgradeTasks.addConfigEntry0(summary, summary, false, ldif);
    }

    public static UpgradeTask addConfigEntryOptional(Message summary, Message description, String ... ldif) {
        return UpgradeTasks.addConfigEntry0(summary, description, true, ldif);
    }

    public static UpgradeTask copySchemaFile(final String fileName) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_REPLACE_SCHEMA_FILE.get(fileName);
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 0);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                try {
                    context.notifyProgress(pnc.changeProgress(20));
                    FileManager.copy(schemaFileTemplate, UpgradeUtils.configSchemaDirectory, true);
                    context.notifyProgress(pnc.changeProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_COPYSCHEMA_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask addConfigFile(final String fileName) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_ADD_CONFIG_FILE.get(fileName);
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 0);
                File configFile = new File(UpgradeUtils.templateConfigDirectory, fileName);
                try {
                    context.notifyProgress(pnc.changeProgress(20));
                    FileManager.copy(configFile, UpgradeUtils.configDirectory, true);
                    context.notifyProgress(pnc.changeProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADD_CONFIG_FILE_FAILS.get(configFile.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask modifyConfigEntry(Message summary, String filter, String ... ldif) {
        return UpgradeTasks.modifyConfigEntry(summary, summary, false, filter, ldif);
    }

    public static UpgradeTask modifyConfigEntryOptional(Message summary, Message description, String filter, String ... ldif) {
        return UpgradeTasks.modifyConfigEntry(summary, description, true, filter, ldif);
    }

    public static UpgradeTask newAttributeTypes(final Message summary, final String fileName, final String ... names) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                LOG.log(Level.INFO, summary.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                context.notifyProgress(pnc);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                File pathDestination = new File(UpgradeUtils.configSchemaDirectory, fileName);
                try {
                    int changeCount = UpgradeUtils.updateSchemaFile(schemaFileTemplate, pathDestination, names, null);
                    UpgradeTasks.displayChangeCount(pathDestination.getPath(), changeCount);
                    context.notifyProgress(pnc.changeProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDATTRIBUTE_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask newObjectClasses(final Message summary, final String fileName, final String ... names) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                LOG.log(Level.INFO, summary.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                context.notifyProgress(pnc);
                File schemaFileTemplate = new File(UpgradeUtils.templateConfigSchemaDirectory, fileName);
                File pathDestination = new File(UpgradeUtils.configSchemaDirectory, fileName);
                context.notifyProgress(pnc.changeProgress(20));
                try {
                    int changeCount = UpgradeUtils.updateSchemaFile(schemaFileTemplate, pathDestination, null, names);
                    UpgradeTasks.displayChangeCount(pathDestination.getPath(), changeCount);
                    context.notifyProgress(pnc.changeProgress(100));
                }
                catch (IOException e) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_ADDOBJECTCLASS_FAILS.get(schemaFileTemplate.getName(), e.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask regressionInVersion(String versionString, final UpgradeTask ... tasks) {
        final BuildVersion version = BuildVersion.valueOf(versionString);
        return new AbstractUpgradeTask(){

            @Override
            public void verify(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.verify(context);
                    }
                }
            }

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.interact(context);
                    }
                }
            }

            @Override
            public void start(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.start(context);
                    }
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.perform(context);
                    }
                }
            }

            @Override
            public void end(UpgradeContext context) throws ClientException {
                if (this.currentVersionEqualToOrMoreRecentThan(context, version)) {
                    for (UpgradeTask task : tasks) {
                        task.end(context);
                    }
                }
            }

            private boolean currentVersionEqualToOrMoreRecentThan(UpgradeContext context, BuildVersion version2) {
                return context.getFromVersion().compareTo(version2) >= 0;
            }
        };
    }

    public static UpgradeTask rebuildAllIndexes(final Message summary) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
            }

            @Override
            public void start(UpgradeContext context) throws ClientException {
                context.notify(summary);
            }

            @Override
            public void verify(UpgradeContext context) throws ClientException {
                UpgradeTasks.verifyTaskType(UpgradeTask.TaskType.MANDATORY_USER_INTERACTION, context);
            }
        };
    }

    public static UpgradeTask rebuildSingleIndex(final Message summary) {
        return new AbstractUpgradeTask(){

            @Override
            public void verify(UpgradeContext context) throws ClientException {
                UpgradeTasks.verifyTaskType(UpgradeTask.TaskType.MANDATORY_USER_INTERACTION, context);
            }

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                int answer = context.confirmYN(summary, 1);
                if (answer == 1) {
                    throw new ClientException(2, ToolMessages.INFO_UPGRADE_ABORTED_BY_USER.get());
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
            }
        };
    }

    public static UpgradeTask updateConfigUpgradeFolder() {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                Message msg = ToolMessages.INFO_UPGRADE_TASK_REFRESH_UPGRADE_DIRECTORY.get();
                LOG.log(Level.INFO, msg.toString());
                ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, msg, 20);
                context.notifyProgress(pnc);
                try {
                    UpgradeUtils.updateConfigUpgradeSchemaFile(UpgradeUtils.configSchemaDirectory, String.valueOf(context.getToVersion().getRevisionNumber()));
                    context.notifyProgress(pnc.changeProgress(100));
                }
                catch (Exception ex) {
                    UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_CONFIG_ERROR_UPGRADE_FOLDER.get(ex.getMessage()), pnc);
                }
            }
        };
    }

    public static UpgradeTask renameSnmpSecurityConfig(final Message summary) {
        return new AbstractUpgradeTask(){

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (UpgradeUtils.configSnmpSecurityDirectory.exists()) {
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 0);
                    try {
                        File oldSnmpConfig = new File(UpgradeUtils.configSnmpSecurityDirectory + File.separator + "opends-snmp.security");
                        if (oldSnmpConfig.exists()) {
                            context.notifyProgress(pnc.changeProgress(20));
                            LOG.log(Level.INFO, summary.toString());
                            File snmpConfig = new File(UpgradeUtils.configSnmpSecurityDirectory + File.separator + "opendj-snmp.security");
                            FileManager.rename(oldSnmpConfig, snmpConfig);
                            context.notifyProgress(pnc.changeProgress(100));
                        }
                    }
                    catch (Exception ex) {
                        UpgradeTasks.manageTaskException(context, ToolMessages.ERR_UPGRADE_RENAME_SNMP_SECURITY_CONFIG_FILE.get(ex.getMessage()), pnc);
                    }
                }
            }
        };
    }

    private static UpgradeTask addConfigEntry0(final Message summary, final Message description, final boolean needsUserConfirmation, final String ... ldif) {
        return new AbstractUpgradeTask(){
            private boolean userConfirmation = true;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                int answer;
                if (needsUserConfirmation && (answer = context.confirmYN(ToolMessages.INFO_UPGRADE_TASK_NEEDS_USER_CONFIRM.get(description), 0)) == 1) {
                    this.userConfirmation = false;
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.userConfirmation) {
                    UpgradeTasks.displayTaskLogInformation(summary.toString(), null, ldif);
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                    context.notifyProgress(pnc);
                    try {
                        File configFile = new File(UpgradeUtils.configDirectory, "config.ldif");
                        int changeCount = UpgradeUtils.updateConfigFile(configFile.getPath(), null, PersistentSearchChangeType.ADD, ldif);
                        UpgradeTasks.displayChangeCount(configFile.getPath(), changeCount);
                        context.notifyProgress(pnc.changeProgress(100));
                    }
                    catch (Exception e) {
                        UpgradeTasks.manageTaskException(context, Message.fromObject(e.getMessage(), new Object[0]), pnc);
                    }
                }
            }
        };
    }

    private static void displayChangeCount(String fileName, int changeCount) {
        if (changeCount != 0) {
            LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_CHANGE_DONE_IN_SPECIFIC_FILE.get(fileName, String.valueOf(changeCount)).toString());
        } else {
            LOG.log(Level.INFO, ToolMessages.INFO_UPGRADE_NO_CHANGE_DONE_IN_SPECIFIC_FILE.get(fileName).toString());
        }
    }

    private static void displayTaskLogInformation(String summary, String filter, String ... ldif) {
        LOG.log(Level.INFO, summary);
        if (filter != null) {
            LOG.log(Level.INFO, filter.toString());
        }
        if (ldif != null) {
            LOG.log(Level.INFO, Arrays.asList(ldif).toString());
        }
    }

    private static void manageTaskException(UpgradeContext context, Message message, ProgressNotificationCallback pnc) throws ClientException {
        ++countErrors;
        context.notifyProgress(pnc.changeProgress(-100));
        LOG.log(Level.SEVERE, message.toString());
        if (!context.isIgnoreErrorsMode()) {
            throw new ClientException(1, message);
        }
    }

    private static UpgradeTask modifyConfigEntry(final Message summary, final Message description, final boolean needsUserConfirmation, final String filter, final String ... ldif) {
        return new AbstractUpgradeTask(){
            private boolean userConfirmation = true;

            @Override
            public void interact(UpgradeContext context) throws ClientException {
                int answer;
                if (needsUserConfirmation && (answer = context.confirmYN(ToolMessages.INFO_UPGRADE_TASK_NEEDS_USER_CONFIRM.get(description), 0)) == 1) {
                    this.userConfirmation = false;
                }
            }

            @Override
            public void perform(UpgradeContext context) throws ClientException {
                if (this.userConfirmation) {
                    UpgradeTasks.displayTaskLogInformation(summary.toString(), filter, ldif);
                    ProgressNotificationCallback pnc = new ProgressNotificationCallback(0, summary, 20);
                    context.notifyProgress(pnc);
                    try {
                        File configFile = new File(UpgradeUtils.configDirectory, "config.ldif");
                        int changeCount = UpgradeUtils.updateConfigFile(configFile.getPath(), LDAPFilter.decode(filter), PersistentSearchChangeType.MODIFY, ldif);
                        UpgradeTasks.displayChangeCount(configFile.getPath(), changeCount);
                        context.notifyProgress(pnc.changeProgress(100));
                    }
                    catch (Exception e) {
                        UpgradeTasks.manageTaskException(context, Message.fromObject(e.getMessage(), new Object[0]), pnc);
                    }
                }
            }
        };
    }

    private static void verifyTaskType(UpgradeTask.TaskType type, UpgradeContext context) throws ClientException {
        switch (type) {
            case NEED_USER_INTERACTION: {
                break;
            }
            case MANDATORY_USER_INTERACTION: 
            case TAKE_LONG_TIME_TO_COMPLETE: 
            case CANNOT_BE_REVERTED: {
                if (context.isInteractiveMode() || context.isForceUpgradeMode()) break;
                context.notify(Message.raw(" ", new Object[0]), 9);
                context.notify(ToolMessages.ERR_UPGRADE_USER_INTERACTION_REQUIRED.get("no-prompt", "force"), 7);
                throw new ClientException(2, ToolMessages.ERR_UPGRADE_INVALID_USER_OPTIONS_SELECTED.get());
            }
        }
    }

    private UpgradeTasks() {
    }
}

