/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.opends.messages.RuntimeMessages;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.tools.upgrade.UpgradeUtils;

class UpgradeLog {
    private static File logFile = null;
    private static FileHandler fileHandler = null;
    static final String UPGRADELOGNAME = "upgrade.log";

    UpgradeLog() {
    }

    static void initLogFileHandler() {
        Logger logger = Logger.getLogger(UpgradeCli.class.getName());
        String SPACE = " ";
        if (logFile == null) {
            logFile = new File(UpgradeUtils.getInstallationPath() + File.separator + UPGRADELOGNAME);
        }
        try {
            fileHandler = new FileHandler(logFile.getCanonicalPath(), true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        fileHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                StringBuffer sb = new StringBuffer();
                SimpleDateFormat dateFormat = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]");
                sb.append(dateFormat.format(record.getMillis())).append(" ");
                sb.append("category=UPGRADE").append(" ").append("sq=").append(record.getSequenceNumber()).append(" ").append("severity=").append(record.getLevel().toString().toUpperCase());
                sb.append(" ").append("src=").append(record.getSourceClassName()).append(" ").append(record.getSourceMethodName()).append("\n");
                sb.append(" ").append("msg=").append(record.getMessage()).append("\n");
                return sb.toString();
            }
        });
        logger.setLevel(Level.CONFIG);
        logger.addHandler(fileHandler);
        logger.setUseParentHandlers(false);
        logger.log(Level.CONFIG, "**** Upgrade of OpenDJ started ****");
        logger.log(Level.CONFIG, RuntimeMessages.NOTE_INSTALL_DIRECTORY.get(UpgradeUtils.getInstallationPath()).toString());
        logger.log(Level.CONFIG, RuntimeMessages.NOTE_INSTANCE_DIRECTORY.get(UpgradeUtils.getInstancePath()).toString());
    }
}

