/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.TextOutputCallback;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.upgrade.FormattedNotificationCallback;
import org.opends.server.tools.upgrade.ProgressNotificationCallback;
import org.opends.server.util.BuildVersion;

public final class UpgradeContext {
    private final BuildVersion fromVersion;
    private final BuildVersion toVersion;
    private CallbackHandler handler;
    private boolean isIgnoreErrorsMode;
    private boolean isAcceptLicenseMode;
    private boolean isInteractiveMode;
    private boolean isForceUpgradeMode;

    UpgradeContext(BuildVersion fromVersion, BuildVersion toVersion, CallbackHandler handler) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.handler = handler;
    }

    public BuildVersion getFromVersion() {
        return this.fromVersion;
    }

    public BuildVersion getToVersion() {
        return this.toVersion;
    }

    public boolean isIgnoreErrorsMode() {
        return this.isIgnoreErrorsMode;
    }

    public void setIgnoreErrorsMode(boolean isIgnoreErrorsMode) {
        this.isIgnoreErrorsMode = isIgnoreErrorsMode;
    }

    public boolean isAcceptLicenseMode() {
        return this.isAcceptLicenseMode;
    }

    public void setAcceptLicenseMode(boolean isAcceptLicenseMode) {
        this.isAcceptLicenseMode = isAcceptLicenseMode;
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CallbackHandler handler) {
        this.handler = handler;
    }

    public boolean isInteractiveMode() {
        return this.isInteractiveMode;
    }

    public void setInteractiveMode(boolean isInteractiveMode) {
        this.isInteractiveMode = isInteractiveMode;
    }

    public boolean isForceUpgradeMode() {
        return this.isForceUpgradeMode;
    }

    public void setForceUpgradeMode(boolean isForceUpgradeMode) {
        this.isForceUpgradeMode = isForceUpgradeMode;
    }

    public void notify(Message message) throws ClientException {
        try {
            this.handler.handle(new Callback[]{new TextOutputCallback(0, message.toString())});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    public void notify(Message message, int msgType) throws ClientException {
        try {
            this.handler.handle(new Callback[]{new FormattedNotificationCallback(message, msgType)});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    public void notifyProgress(ProgressNotificationCallback callback) throws ClientException {
        try {
            this.handler.handle(new Callback[]{callback});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    public int confirmYN(Message message, int defaultOption) throws ClientException {
        ConfirmationCallback confirmYNCallback = new ConfirmationCallback(message.toString(), 1, 0, defaultOption);
        try {
            this.handler.handle(new Callback[]{confirmYNCallback});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_CONFIRM_ERROR.get(e.getMessage()));
        }
        return confirmYNCallback.getSelectedIndex();
    }

    public static String getDefaultOption(int defaultOption) {
        if (defaultOption == 0) {
            return ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString();
        }
        if (defaultOption == 1) {
            return ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString();
        }
        if (defaultOption == 2) {
            return ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get().toString();
        }
        return null;
    }
}

