/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.opends.server.admin.client.cli.TaskScheduleArgs;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CommandBuilder;

public class TaskScheduleUserData {
    private boolean startNow;
    private Date startDate;
    private String recurringDateTime;
    private final List<String> dependencyIds = new ArrayList<String>();
    private FailedDependencyAction failedDependencyAction;
    private final List<String> notifyUponCompletionEmailAddresses = new ArrayList<String>();
    private final List<String> notifyUponErrorEmailAddresses = new ArrayList<String>();

    public boolean isStartNow() {
        return this.startNow;
    }

    public void setStartNow(boolean startNow) {
        this.startNow = startNow;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getRecurringDateTime() {
        return this.recurringDateTime;
    }

    public void setRecurringDateTime(String recurringDateTime) {
        this.recurringDateTime = recurringDateTime;
    }

    public List<String> getDependencyIds() {
        return this.dependencyIds;
    }

    public void setDependencyIds(List<String> dependencyIds) {
        this.dependencyIds.clear();
        this.dependencyIds.addAll(dependencyIds);
    }

    public FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public void setFailedDependencyAction(FailedDependencyAction failedDependencyAction) {
        this.failedDependencyAction = failedDependencyAction;
    }

    public List<String> getNotifyUponCompletionEmailAddresses() {
        return this.notifyUponCompletionEmailAddresses;
    }

    public void setNotifyUponCompletionEmailAddresses(List<String> notifyUponCompletionEmailAddresses) {
        this.notifyUponCompletionEmailAddresses.clear();
        this.notifyUponCompletionEmailAddresses.addAll(notifyUponCompletionEmailAddresses);
    }

    public List<String> getNotifyUponErrorEmailAddresses() {
        return this.notifyUponErrorEmailAddresses;
    }

    public void setNotifyUponErrorEmailAddresses(List<String> notifyUponErrorEmailAddresses) {
        this.notifyUponErrorEmailAddresses.clear();
        this.notifyUponErrorEmailAddresses.addAll(notifyUponErrorEmailAddresses);
    }

    public static void updateCommandBuilderWithTaskSchedule(CommandBuilder commandBuilder, TaskScheduleUserData taskSchedule) {
        TaskScheduleArgs argsToClone = new TaskScheduleArgs();
        String sDate = null;
        String recurringDateTime = null;
        if (!taskSchedule.isStartNow()) {
            Date date = taskSchedule.getStartDate();
            if (date != null) {
                sDate = StaticUtils.formatDateTimeString(date);
            }
            recurringDateTime = taskSchedule.getRecurringDateTime();
        }
        String sFailedDependencyAction = null;
        FailedDependencyAction fAction = taskSchedule.getFailedDependencyAction();
        if (fAction != null) {
            sFailedDependencyAction = fAction.name();
        }
        String[] sValues = new String[]{sDate, recurringDateTime, sFailedDependencyAction};
        StringArgument[] args = new StringArgument[]{argsToClone.startArg, argsToClone.recurringArg, argsToClone.failedDependencyActionArg};
        for (int i = 0; i < sValues.length; ++i) {
            if (sValues[i] == null) continue;
            commandBuilder.addArgument(TaskScheduleUserData.getArgument(args[i], Collections.singleton(sValues[i])));
        }
        List[] values = new List[]{taskSchedule.getDependencyIds(), taskSchedule.getNotifyUponCompletionEmailAddresses(), taskSchedule.getNotifyUponErrorEmailAddresses()};
        args = new StringArgument[]{argsToClone.dependencyArg, argsToClone.completionNotificationArg, argsToClone.errorNotificationArg};
        for (int i = 0; i < values.length; ++i) {
            if (values[i].isEmpty()) continue;
            commandBuilder.addArgument(TaskScheduleUserData.getArgument(args[i], values[i]));
        }
    }

    private static StringArgument getArgument(StringArgument argToClone, Collection<?> values) {
        StringArgument arg;
        try {
            arg = new StringArgument(argToClone.getName(), argToClone.getShortIdentifier(), argToClone.getLongIdentifier(), argToClone.isRequired(), argToClone.isMultiValued(), argToClone.needsValue(), argToClone.getValuePlaceholder(), argToClone.getDefaultValue(), argToClone.getPropertyName(), argToClone.getDescription());
        }
        catch (ArgumentException e) {
            throw new RuntimeException("Unexpected error: " + e, e);
        }
        for (Object v : values) {
            arg.addValue(String.valueOf(v));
        }
        return arg;
    }
}

