/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

public class TemplateEntry {
    private Branch branch;
    private DN dn;
    private DN parentDN;
    private LinkedHashMap<AttributeType, ArrayList<TemplateValue>> attributes;
    private Template template;

    public TemplateEntry(Branch branch) {
        this.branch = branch;
        this.dn = branch.getBranchDN();
        this.template = null;
        this.parentDN = null;
        this.attributes = new LinkedHashMap();
    }

    public TemplateEntry(Template template, DN parentDN) {
        this.template = template;
        this.parentDN = parentDN;
        this.dn = null;
        this.branch = null;
        this.attributes = new LinkedHashMap();
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Template getTemplate() {
        return this.template;
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public DN getDN() {
        if (this.dn == null) {
            RDN rdn;
            AttributeType[] rdnAttrs = this.template.getRDNAttributes();
            if (rdnAttrs.length == 1) {
                AttributeType t = rdnAttrs[0];
                TemplateValue v = this.getValue(t);
                if (v == null) {
                    return null;
                }
                AttributeValue value = AttributeValues.create(t, v.getValue().toString());
                rdn = new RDN(t, value);
            } else {
                String[] names = new String[rdnAttrs.length];
                AttributeValue[] values = new AttributeValue[rdnAttrs.length];
                for (int i = 0; i < rdnAttrs.length; ++i) {
                    AttributeType t = rdnAttrs[i];
                    TemplateValue v = this.getValue(t);
                    if (v == null) {
                        return null;
                    }
                    names[i] = t.getPrimaryName();
                    values[i] = AttributeValues.create(t, v.getValue().toString());
                }
                rdn = new RDN(rdnAttrs, names, values);
            }
            this.dn = this.parentDN.concat(rdn);
        }
        return this.dn;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.containsKey(attributeType);
    }

    public TemplateValue getValue(AttributeType attributeType) {
        ArrayList<TemplateValue> valueList = this.attributes.get(attributeType);
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return valueList.get(0);
    }

    public List<TemplateValue> getValues(AttributeType attributeType) {
        ArrayList<TemplateValue> valueList = this.attributes.get(attributeType);
        return valueList;
    }

    public void addValue(TemplateValue value) {
        ArrayList<TemplateValue> valueList = this.attributes.get(value.getAttributeType());
        if (valueList == null) {
            valueList = new ArrayList();
            valueList.add(value);
            this.attributes.put(value.getAttributeType(), valueList);
        } else {
            valueList.add(value);
        }
    }

    public boolean toLDIF(LDIFExportConfig exportConfig) throws IOException, LDIFException {
        StringBuilder attrName;
        List attrList;
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
        LinkedHashMap userAttributes = new LinkedHashMap();
        LinkedHashMap operationalAttributes = new LinkedHashMap();
        LinkedHashMap urlAttributes = new LinkedHashMap();
        LinkedHashMap base64Attributes = new LinkedHashMap();
        for (AttributeType t : this.attributes.keySet()) {
            AttributeBuilder builder;
            ArrayList<TemplateValue> valueList = this.attributes.get(t);
            if (t.isObjectClassType()) {
                for (TemplateValue v : valueList) {
                    String ocName = StaticUtils.toLowerCase(v.getValue().toString());
                    ObjectClass oc = DirectoryServer.getObjectClass(ocName, true);
                    objectClasses.put(oc, ocName);
                }
                continue;
            }
            if (t.isOperational()) {
                builder = new AttributeBuilder(t, t.getNameOrOID());
                for (TemplateValue v : valueList) {
                    builder.add(AttributeValues.create(t, v.getValue().toString()));
                }
                ArrayList<Attribute> attrList2 = new ArrayList<Attribute>(1);
                attrList2.add(builder.toAttribute());
                operationalAttributes.put(t, attrList2);
                continue;
            }
            builder = new AttributeBuilder(t, t.getNameOrOID());
            AttributeBuilder urlBuilder = null;
            AttributeBuilder base64Builder = null;
            for (TemplateValue v : valueList) {
                AttributeValue value = AttributeValues.create(t, v.getValue().toString());
                builder.add(value);
                if (v.getTemplateLine().isURL()) {
                    if (urlBuilder == null) {
                        urlBuilder = new AttributeBuilder(t, t.getNameOrOID());
                    }
                    urlBuilder.add(value);
                    continue;
                }
                if (!v.getTemplateLine().isBase64()) continue;
                if (base64Builder == null) {
                    base64Builder = new AttributeBuilder(t, t.getNameOrOID());
                }
                base64Builder.add(value);
            }
            ArrayList<Attribute> attrList3 = new ArrayList<Attribute>(1);
            attrList3.add(builder.toAttribute());
            userAttributes.put(t, attrList3);
            if (urlBuilder != null) {
                ArrayList<Attribute> urlAttrList = new ArrayList<Attribute>(1);
                urlAttrList.add(urlBuilder.toAttribute());
                urlAttributes.put(t, urlAttrList);
            }
            if (base64Builder == null) continue;
            ArrayList<Attribute> base64AttrList = new ArrayList<Attribute>(1);
            base64AttrList.add(base64Builder.toAttribute());
            base64Attributes.put(t, base64AttrList);
        }
        BufferedWriter writer = exportConfig.getWriter();
        int wrapColumn = exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(this.getDN().toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        boolean typesOnly = exportConfig.typesOnly();
        if (exportConfig.includeObjectClasses()) {
            if (typesOnly) {
                StringBuilder ocLine = new StringBuilder("objectClass:");
                LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
            } else {
                for (String s : objectClasses.values()) {
                    StringBuilder ocLine = new StringBuilder();
                    ocLine.append("objectClass: ");
                    ocLine.append(s);
                    LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
                }
            }
        }
        for (AttributeType attrType : userAttributes.keySet()) {
            if (!exportConfig.includeAttribute(attrType)) continue;
            attrList = (List)userAttributes.get(attrType);
            for (Attribute a : attrList) {
                if (a.isVirtual() && !exportConfig.includeVirtualAttributes()) continue;
                if (typesOnly) {
                    attrName = new StringBuilder(a.getName());
                    for (String o : a.getOptions()) {
                        attrName.append(";");
                        attrName.append(o);
                    }
                    attrName.append(":");
                    LDIFWriter.writeLDIFLine(attrName, writer, wrapLines, wrapColumn);
                    continue;
                }
                attrName = new StringBuilder(a.getName());
                for (String o : a.getOptions()) {
                    attrName.append(";");
                    attrName.append(o);
                }
                List urlAttrList = (List)urlAttributes.get(attrType);
                List base64AttrList = (List)base64Attributes.get(attrType);
                for (AttributeValue v : a) {
                    StringBuilder attrLine = new StringBuilder();
                    attrLine.append((CharSequence)attrName);
                    boolean isURLValue = false;
                    if (urlAttrList != null) {
                        for (Attribute urlAttr : urlAttrList) {
                            for (AttributeValue urlValue : urlAttr) {
                                if (!urlValue.equals(v)) continue;
                                isURLValue = true;
                                break;
                            }
                            if (!isURLValue) continue;
                            break;
                        }
                    }
                    boolean isBase64Value = false;
                    if (base64AttrList != null) {
                        for (Attribute base64Attr : base64AttrList) {
                            for (AttributeValue base64Value : base64Attr) {
                                if (!base64Value.equals(v)) continue;
                                isBase64Value = true;
                                break;
                            }
                            if (!isBase64Value) continue;
                            break;
                        }
                    }
                    LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue(), isURLValue, isBase64Value);
                    LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                }
            }
        }
        if (exportConfig.includeOperationalAttributes()) {
            for (AttributeType attrType : operationalAttributes.keySet()) {
                if (!exportConfig.includeAttribute(attrType)) continue;
                attrList = (List)operationalAttributes.get(attrType);
                for (Attribute a : attrList) {
                    if (a.isVirtual() && !exportConfig.includeVirtualAttributes()) continue;
                    if (typesOnly) {
                        attrName = new StringBuilder(a.getName());
                        for (String o : a.getOptions()) {
                            attrName.append(";");
                            attrName.append(o);
                        }
                        attrName.append(":");
                        LDIFWriter.writeLDIFLine(attrName, writer, wrapLines, wrapColumn);
                        continue;
                    }
                    attrName = new StringBuilder(a.getName());
                    for (String o : a.getOptions()) {
                        attrName.append(";");
                        attrName.append(o);
                    }
                    for (AttributeValue v : a) {
                        StringBuilder attrLine = new StringBuilder();
                        attrLine.append((CharSequence)attrName);
                        LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue());
                        LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
                    }
                }
            }
        }
        writer.newLine();
        return true;
    }
}

