/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

public class RDNTag
extends Tag {
    @Override
    public String getName() {
        return "RDN";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length != 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(message);
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length != 0) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN dn = templateEntry.getDN();
        if (dn == null || dn.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        dn.getRDN().toString(templateValue.getValue());
        return TagResult.SUCCESS_RESULT;
    }
}

