/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import java.util.Random;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

public class PresenceTag
extends Tag {
    private int percentage = 100;
    private Random random;

    @Override
    public String getName() {
        return "Presence";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber) throws InitializationException {
        this.random = templateFile.getRandom();
        if (arguments.length != 1) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_COUNT.get(this.getName(), lineNumber, 1, arguments.length);
            throw new InitializationException(message);
        }
        try {
            this.percentage = Integer.parseInt(arguments[0]);
            if (this.percentage < 0) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_BELOW_LOWER_BOUND.get(this.percentage, 0, this.getName(), lineNumber);
                throw new InitializationException(message);
            }
            if (this.percentage > 100) {
                Message message = ToolMessages.ERR_MAKELDIF_TAG_INTEGER_ABOVE_UPPER_BOUND.get(this.percentage, 100, this.getName(), lineNumber);
                throw new InitializationException(message);
            }
        }
        catch (NumberFormatException nfe) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_CANNOT_PARSE_AS_INTEGER.get(arguments[0], this.getName(), lineNumber);
            throw new InitializationException(message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        int intValue = this.random.nextInt(100);
        if (intValue < this.percentage) {
            return TagResult.SUCCESS_RESULT;
        }
        return TagResult.OMIT_FROM_ENTRY;
    }
}

