/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.opends.server.admin.client.cli.TaskScheduleArgs;
import org.opends.server.tools.dsreplication.MonoServerReplicationUserData;
import org.opends.server.tools.dsreplication.PurgeHistoricalScheduleInformation;
import org.opends.server.tools.dsreplication.ReplicationCliArgumentParser;
import org.opends.server.tools.tasks.TaskClient;
import org.opends.server.tools.tasks.TaskScheduleUserData;
import org.opends.server.types.ByteString;
import org.opends.server.types.RawAttribute;

public class PurgeHistoricalUserData
extends MonoServerReplicationUserData {
    private int maximumDuration;
    private boolean online;
    private TaskScheduleUserData taskSchedule = new TaskScheduleUserData();

    public int getMaximumDuration() {
        return this.maximumDuration;
    }

    public void setMaximumDuration(int maximumDuration) {
        this.maximumDuration = maximumDuration;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public TaskScheduleUserData getTaskSchedule() {
        return this.taskSchedule;
    }

    public void setTaskSchedule(TaskScheduleUserData taskSchedule) {
        this.taskSchedule = taskSchedule;
    }

    public static void initializeWithArgParser(PurgeHistoricalUserData uData, ReplicationCliArgumentParser argParser) {
        uData.setBaseDNs(new LinkedList<String>(argParser.getBaseDNs()));
        if (argParser.connectionArgumentsPresent()) {
            String adminUid = PurgeHistoricalUserData.getValue(argParser.getAdministratorUID(), argParser.getDefaultAdministratorUID());
            uData.setAdminUid(adminUid);
            String adminPwd = argParser.getBindPasswordAdmin();
            uData.setAdminPwd(adminPwd);
            String hostName = PurgeHistoricalUserData.getValue(argParser.getHostNameToStatus(), argParser.getDefaultHostNameToStatus());
            uData.setHostName(hostName);
            int port = PurgeHistoricalUserData.getValue(argParser.getPortToStatus(), argParser.getDefaultPortToStatus());
            uData.setPort(port);
            uData.setOnline(true);
            TaskScheduleUserData taskSchedule = new TaskScheduleUserData();
            TaskScheduleArgs taskArgs = argParser.getTaskArgsList();
            taskSchedule.setStartNow(taskArgs.isStartNow());
            if (!taskSchedule.isStartNow()) {
                taskSchedule.setStartDate(taskArgs.getStartDateTime());
                taskSchedule.setDependencyIds(taskArgs.getDependencyIds());
                taskSchedule.setFailedDependencyAction(taskArgs.getFailedDependencyAction());
                taskSchedule.setNotifyUponErrorEmailAddresses(taskArgs.getNotifyUponErrorEmailAddresses());
                taskSchedule.setNotifyUponCompletionEmailAddresses(taskArgs.getNotifyUponCompletionEmailAddresses());
                taskSchedule.setRecurringDateTime(taskArgs.getRecurringDateTime());
            }
            uData.setTaskSchedule(taskSchedule);
        } else {
            uData.setOnline(false);
        }
        uData.setMaximumDuration(PurgeHistoricalUserData.getValue(argParser.getMaximumDuration(), argParser.getDefaultMaximumDuration()));
    }

    private static String getValue(String v, String defaultValue) {
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    private static int getValue(int v, int defaultValue) {
        if (v != -1) {
            return v;
        }
        return defaultValue;
    }

    public static BasicAttributes getTaskAttributes(PurgeHistoricalUserData uData) {
        PurgeHistoricalScheduleInformation information = new PurgeHistoricalScheduleInformation(uData);
        ArrayList<RawAttribute> rawAttrs = TaskClient.getTaskAttributes(information);
        BasicAttributes attrs = PurgeHistoricalUserData.getAttributes(rawAttrs);
        return attrs;
    }

    private static BasicAttributes getAttributes(ArrayList<RawAttribute> rawAttrs) {
        BasicAttributes attrs = new BasicAttributes();
        for (RawAttribute rawAttr : rawAttrs) {
            BasicAttribute attr = new BasicAttribute(rawAttr.getAttributeType());
            for (ByteString v : rawAttr.getValues()) {
                attr.add(v.toString());
            }
            attrs.put(attr);
        }
        return attrs;
    }

    public static String getTaskDN(BasicAttributes attrs) {
        ArrayList<RawAttribute> rawAttrs = PurgeHistoricalUserData.getRawAttributes(attrs);
        return TaskClient.getTaskDN(rawAttrs);
    }

    public static String getTaskID(BasicAttributes attrs) {
        ArrayList<RawAttribute> rawAttrs = PurgeHistoricalUserData.getRawAttributes(attrs);
        return TaskClient.getTaskID(rawAttrs);
    }

    private static ArrayList<RawAttribute> getRawAttributes(BasicAttributes attrs) {
        ArrayList<RawAttribute> rawAttrs = new ArrayList<RawAttribute>();
        NamingEnumeration<Attribute> nAtt = attrs.getAll();
        try {
            while (nAtt.hasMore()) {
                Attribute attr = nAtt.next();
                NamingEnumeration<?> values = attr.getAll();
                ArrayList<ByteString> rawValues = new ArrayList<ByteString>();
                while (values.hasMore()) {
                    Object v = values.next();
                    rawValues.add(ByteString.valueOf(v.toString()));
                }
                RawAttribute rAttr = RawAttribute.create(attr.getID(), rawValues);
                rawAttrs.add(rAttr);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Unexpected error: " + ne, ne);
        }
        return rawAttrs;
    }
}

