/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.PurgeConflictsHistoricalTask;
import org.opends.server.tools.dsreplication.PurgeHistoricalUserData;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.tools.tasks.TaskScheduleUserData;
import org.opends.server.types.ByteString;
import org.opends.server.types.RawAttribute;

public class PurgeHistoricalScheduleInformation
implements TaskScheduleInformation {
    private final PurgeHistoricalUserData uData;
    private TaskScheduleUserData taskSchedule;

    public PurgeHistoricalScheduleInformation(PurgeHistoricalUserData uData) {
        this.uData = uData;
        this.taskSchedule = uData.getTaskSchedule();
        if (this.taskSchedule == null) {
            this.taskSchedule = new TaskScheduleUserData();
        }
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        ArrayList<ByteString> baseDNs = new ArrayList<ByteString>();
        for (String baseDN : this.uData.getBaseDNs()) {
            baseDNs.add(ByteString.valueOf(baseDN));
        }
        attributes.add(new LDAPAttribute("ds-task-purge-conflicts-historical-domain-dn", baseDNs));
        attributes.add(new LDAPAttribute("ds-task-purge-conflicts-historical-maximum-duration", Long.toString(this.uData.getMaximumDuration())));
    }

    @Override
    public List<String> getDependencyIds() {
        return this.taskSchedule.getDependencyIds();
    }

    @Override
    public FailedDependencyAction getFailedDependencyAction() {
        return this.taskSchedule.getFailedDependencyAction();
    }

    @Override
    public List<String> getNotifyUponCompletionEmailAddresses() {
        return this.taskSchedule.getNotifyUponCompletionEmailAddresses();
    }

    @Override
    public List<String> getNotifyUponErrorEmailAddresses() {
        return this.taskSchedule.getNotifyUponErrorEmailAddresses();
    }

    @Override
    public String getRecurringDateTime() {
        return this.taskSchedule.getRecurringDateTime();
    }

    @Override
    public Date getStartDateTime() {
        return this.taskSchedule.getStartDate();
    }

    @Override
    public Class<?> getTaskClass() {
        return PurgeConflictsHistoricalTask.class;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-purge-conflicts-historical";
    }
}

