/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.tools.dsreplication.PurgeHistoricalUserData;
import org.opends.server.tools.dsreplication.ReplicationCliReturnCode;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.PointAdder;

public class LocalPurgeHistorical {
    private static final Logger LOG = Logger.getLogger(LocalPurgeHistorical.class.getName());
    private final PurgeHistoricalUserData uData;
    private final ConsoleApplication app;
    private final ProgressMessageFormatter formatter;
    private final String configFile;
    private final String configClass;

    public LocalPurgeHistorical(PurgeHistoricalUserData uData, ConsoleApplication app, ProgressMessageFormatter formatter, String configFile, String configClass) {
        this.uData = uData;
        this.app = app;
        this.formatter = formatter;
        this.configFile = configFile;
        this.configClass = configClass;
    }

    public ReplicationCliReturnCode execute() {
        Class<?> cfgClass;
        boolean applyTimeout = this.uData.getMaximumDuration() > 0;
        long startTime = TimeThread.getTime();
        long purgeMaxTime = (long)this.getTimeoutInSeconds() * 1000L;
        long endMaxTime = startTime + purgeMaxTime;
        this.app.printProgress(this.formatter.getFormattedProgress(AdminToolMessages.INFO_REPLICATION_PURGE_HISTORICAL_LOCAL_ENVIRONMENT.get()));
        PointAdder pointAdder = new PointAdder(this.app);
        pointAdder.start();
        try {
            cfgClass = Class.forName(this.configClass);
        }
        catch (Exception e) {
            pointAdder.stop();
            Message message = CoreMessages.ERR_CANNOT_LOAD_CONFIG_HANDLER_CLASS.get(this.configClass, StaticUtils.stackTraceToSingleLineString(e));
            this.app.println(message);
            LOG.log(Level.SEVERE, "Error loading configuration class " + this.configClass + ": " + e, e);
            return ReplicationCliReturnCode.ERROR_LOCAL_PURGE_HISTORICAL_CLASS_LOAD;
        }
        try {
            DirectoryEnvironmentConfig environmentConfig = new DirectoryEnvironmentConfig();
            environmentConfig.setConfigClass(cfgClass);
            environmentConfig.setConfigFile(new File(this.configFile));
            environmentConfig.setDisableConnectionHandlers(true);
            EmbeddedUtils.startServer(environmentConfig);
        }
        catch (OpenDsException ode) {
            pointAdder.stop();
            Message message = ode.getMessageObject();
            CoreMessages.ERR_CANNOT_LOAD_CONFIG_HANDLER_CLASS.get(this.configClass, StaticUtils.stackTraceToSingleLineString(ode));
            this.app.println(message);
            LOG.log(Level.SEVERE, "Error starting server with file " + this.configFile + ": " + ode, ode);
            return ReplicationCliReturnCode.ERROR_LOCAL_PURGE_HISTORICAL_SERVER_START;
        }
        pointAdder.stop();
        this.app.printProgress(this.formatter.getFormattedDone());
        this.app.printlnProgress();
        this.app.printlnProgress();
        this.app.printProgress(this.formatter.getFormattedProgress(AdminToolMessages.INFO_REPLICATION_PURGE_HISTORICAL_LOCAL_STARTING.get()));
        this.app.printlnProgress();
        if (applyTimeout && this.timeoutOccurred(endMaxTime)) {
            return this.handleTimeout();
        }
        try {
            for (String baseDN : this.uData.getBaseDNs()) {
                DN dn = DN.decode(baseDN);
                LDAPReplicationDomain domain = LDAPReplicationDomain.retrievesReplicationDomain(dn);
                domain.purgeConflictsHistorical(null, startTime + purgeMaxTime);
            }
        }
        catch (DirectoryException de) {
            if (de.getResultCode() == ResultCode.ADMIN_LIMIT_EXCEEDED) {
                return this.handleTimeout();
            }
            return this.handleGenericExecuting(de);
        }
        return ReplicationCliReturnCode.SUCCESSFUL;
    }

    private ReplicationCliReturnCode handleGenericExecuting(OpenDsException ode) {
        LOG.log(Level.SEVERE, "Error executing purge historical: " + ode, ode);
        this.app.println();
        this.app.println(AdminToolMessages.ERR_REPLICATION_PURGE_HISTORICAL_EXECUTING.get(ode.getMessageObject()));
        return ReplicationCliReturnCode.ERROR_LOCAL_PURGE_HISTORICAL_EXECUTING;
    }

    private ReplicationCliReturnCode handleTimeout() {
        this.app.println();
        this.app.println(AdminToolMessages.ERR_REPLICATION_PURGE_HISTORICAL_TIMEOUT.get(this.getTimeoutInSeconds()));
        return ReplicationCliReturnCode.ERROR_LOCAL_PURGE_HISTORICAL_TIMEOUT;
    }

    private int getTimeoutInSeconds() {
        return this.uData.getMaximumDuration();
    }

    private boolean timeoutOccurred(long endMaxTime) {
        return TimeThread.getTime() > endMaxTime;
    }
}

