/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.net.Socket;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RecordingInputStream;
import org.opends.server.util.ServerConstants;

public class LDAPReader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Socket socket;
    private ASN1Reader asn1Reader;
    private RecordingInputStream debugInputStream;

    public LDAPReader(Socket socket) throws IOException {
        this.socket = socket;
        this.debugInputStream = new RecordingInputStream(socket.getInputStream());
        this.asn1Reader = ASN1.getReader(this.debugInputStream);
    }

    public LDAPMessage readMessage() throws IOException, ASN1Exception, LDAPException {
        this.debugInputStream.setRecordingEnabled(DebugLogger.debugEnabled());
        if (!this.asn1Reader.hasNextElement()) {
            return null;
        }
        LDAPMessage message = org.opends.server.protocols.ldap.LDAPReader.readMessage(this.asn1Reader);
        if (this.debugInputStream.isRecordingEnabled()) {
            ByteString bytesRead = this.debugInputStream.getRecordedBytes();
            this.debugInputStream.clearRecordedBytes();
            StringBuilder builder = new StringBuilder();
            builder.append("bytes read from wire(len=");
            builder.append(bytesRead.length());
            builder.append("):");
            builder.append(ServerConstants.EOL);
            bytesRead.toHexPlusAscii(builder, 4);
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, builder.toString());
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, message.toString());
        }
        return message;
    }

    public void close() {
        block6: {
            block5: {
                try {
                    this.asn1Reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

