/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.JavaPropertiesToolArgumentParser;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.ConsoleApplication;

public class JavaPropertiesTool
extends ConsoleApplication {
    private JavaPropertiesToolArgumentParser argParser;
    private static final String DEFAULT_JAVA_HOME_PROP_NAME = "default.java-home";
    private static final String DEFAULT_JAVA_ARGS_PROP_NAME = "default.java-args";
    private static final String OVERWRITE_ENV_JAVA_HOME_PROP_NAME = "overwrite-env-java-home";
    private static final String OVERWRITE_ENV_JAVA_ARGS_PROP_NAME = "overwrite-env-java-args";

    public JavaPropertiesTool(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = JavaPropertiesTool.mainCLI(args, System.out, System.err, System.in);
        System.exit(retCode);
    }

    public static int mainCLI(String[] args) {
        return JavaPropertiesTool.mainCLI(args, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        System.setProperty("org.opends.quicksetup.cli", "true");
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        JavaPropertiesTool tool = new JavaPropertiesTool(out, err, inStream);
        return tool.execute(args);
    }

    public int execute(String[] args) {
        BufferedWriter writer;
        BufferedReader reader;
        this.argParser = new JavaPropertiesToolArgumentParser(JavaPropertiesTool.class.getName());
        try {
            this.argParser.initializeArguments();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            return ErrorReturnCode.ERROR_UNEXPECTED.getReturnCode();
        }
        try {
            this.argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.println(message);
            this.println();
            this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
            return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
        }
        if (this.argParser.usageOrVersionDisplayed()) {
            return ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode();
        }
        Properties properties = new Properties();
        String propertiesFile = this.argParser.propertiesFileArg.getValue();
        try {
            reader = new BufferedReader(new FileReader(propertiesFile));
        }
        catch (FileNotFoundException fnfe) {
            this.println(ToolMessages.ERR_JAVAPROPERTIES_WITH_PROPERTIES_FILE.get(propertiesFile));
            return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
        }
        try {
            JavaPropertiesTool.updateProperties(reader, properties);
        }
        catch (IOException ioe) {
            this.println(ToolMessages.ERR_JAVAPROPERTIES_WITH_PROPERTIES_FILE.get(propertiesFile));
            return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
        }
        String destinationFile = this.argParser.destinationFileArg.getValue();
        try {
            File f = new File(destinationFile);
            writer = new BufferedWriter(new FileWriter(f));
            f.setReadable(true, false);
        }
        catch (IOException ioe) {
            this.println(ToolMessages.ERR_JAVAPROPERTIES_WITH_DESTINATION_FILE.get(destinationFile));
            return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        boolean overwriteEnvJavaHome = true;
        boolean overwriteEnvJavaArgs = true;
        String defaultJavaHome = null;
        String defaultJavaArgs = null;
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            String value = properties.getProperty(name);
            if (value == null) continue;
            if (name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME)) {
                defaultJavaHome = value;
                continue;
            }
            if (name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME)) {
                defaultJavaArgs = value;
                continue;
            }
            if (name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME)) {
                if (!"false".equalsIgnoreCase(value)) continue;
                overwriteEnvJavaHome = false;
                continue;
            }
            if (!name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !"false".equalsIgnoreCase(value)) continue;
            overwriteEnvJavaArgs = false;
        }
        try {
            String value = Utils.isWindows() ? this.getWindowsContents(overwriteEnvJavaHome, overwriteEnvJavaArgs, defaultJavaHome, defaultJavaArgs, properties) : this.getUnixContents(overwriteEnvJavaHome, overwriteEnvJavaArgs, defaultJavaHome, defaultJavaArgs, properties);
            writer.write(value);
            writer.newLine();
            writer.close();
        }
        catch (IOException ioe) {
            this.println(Utils.getThrowableMsg(ToolMessages.ERR_JAVAPROPERTIES_WRITING_DESTINATION_FILE.get(destinationFile), ioe));
            return ErrorReturnCode.ERROR_WRITING_FILE.getReturnCode();
        }
        File f1 = new File(this.argParser.destinationFileArg.getValue());
        File f2 = new File(this.argParser.destinationFileArg.getDefaultValue());
        if (f1.equals(f2)) {
            this.printProgress(ToolMessages.INFO_JAVAPROPERTIES_SUCCESSFUL.get(this.argParser.propertiesFileArg.getValue()));
        } else {
            this.printProgress(ToolMessages.INFO_JAVAPROPERTIES_SUCCESSFUL_NON_DEFAULT.get(this.argParser.destinationFileArg.getValue(), this.argParser.propertiesFileArg.getValue(), this.argParser.destinationFileArg.getDefaultValue()));
        }
        this.printlnProgress();
        return ErrorReturnCode.SUCCESSFUL.getReturnCode();
    }

    public static void updateProperties(BufferedReader reader, Properties properties) throws IOException {
        String line;
        boolean slashInLastLine = false;
        String key = null;
        StringBuilder sbValue = null;
        while ((line = reader.readLine()) != null) {
            int index;
            boolean hasSlash;
            if ((line = line.trim()).startsWith("#")) continue;
            if (!slashInLastLine) {
                key = null;
                sbValue = new StringBuilder();
                int index2 = line.indexOf(61);
                if (index2 > 0 && (key = line.substring(0, index2)).indexOf(32) != -1) {
                    key = null;
                }
            }
            if (hasSlash = line.endsWith(" \\")) {
                line = line.substring(0, line.length() - 1);
            }
            String lineValue = null;
            if (slashInLastLine) {
                lineValue = line;
            } else if (key != null && (index = line.indexOf(61)) != -1 && index + 1 < line.length()) {
                lineValue = line.substring(index + 1);
            }
            if (lineValue != null && lineValue.length() > 0) {
                if (sbValue == null) {
                    sbValue = new StringBuilder();
                }
                sbValue.append(lineValue);
            }
            if (!hasSlash && key != null && sbValue != null) {
                properties.put(key, sbValue.toString());
            }
            slashInLastLine = hasSlash;
        }
    }

    @Override
    public boolean isQuiet() {
        return this.argParser.quietArg.isPresent();
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    private String getUnixContents(boolean overwriteJavaHome, boolean overwriteJavaArgs, String defaultJavaHome, String defaultJavaArgs, Properties properties) {
        String s;
        String s2;
        String value;
        String name;
        StringBuilder buf = new StringBuilder();
        buf.append("#!/bin/sh" + ServerConstants.EOL + ServerConstants.EOL);
        if (!overwriteJavaHome) {
            buf.append("# See if the environment variables for java home are set" + ServerConstants.EOL + "# in the path and try to figure it out." + ServerConstants.EOL + "if test ! -f \"${OPENDJ_JAVA_BIN}\"" + ServerConstants.EOL + "then" + ServerConstants.EOL + "  if test ! -d \"${OPENDJ_JAVA_HOME}\"" + ServerConstants.EOL + "  then" + ServerConstants.EOL + "    if test ! -f \"${OPENDS_JAVA_BIN}\"" + ServerConstants.EOL + "    then" + ServerConstants.EOL + "      if test ! -d \"${OPENDS_JAVA_HOME}\"" + ServerConstants.EOL);
        }
        boolean propertiesAdded = false;
        Enumeration<?> propertyNames = properties.propertyNames();
        int nIfs = 0;
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            value = properties.getProperty(name);
            if (value == null || name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-home")) continue;
            propertiesAdded = true;
            if (nIfs > 0) {
                s2 = !overwriteJavaHome ? "    " : "";
                buf.append(s2 + "elif test \"${SCRIPT_NAME}.java-home\" = \"" + name + "\"" + ServerConstants.EOL);
            } else if (!overwriteJavaHome) {
                buf.append("  then" + ServerConstants.EOL + "    if test \"${SCRIPT_NAME}.java-home\" = \"" + name + "\"" + ServerConstants.EOL);
                s2 = "    ";
            } else {
                buf.append("if test \"${SCRIPT_NAME}.java-home\" = \"" + name + "\"" + ServerConstants.EOL);
                s2 = "";
            }
            buf.append(s2 + "then" + ServerConstants.EOL + s2 + "  TEMP=\"" + value + "/bin/java\"" + ServerConstants.EOL + s2 + "  if test -f \"${TEMP}\"" + ServerConstants.EOL + s2 + "  then" + ServerConstants.EOL + s2 + "    OPENDJ_JAVA_BIN=\"" + value + "/bin/java\"" + ServerConstants.EOL + s2 + "    export OPENDJ_JAVA_BIN" + ServerConstants.EOL + s2 + "  fi" + ServerConstants.EOL);
            ++nIfs;
        }
        if (defaultJavaHome != null) {
            if (propertiesAdded) {
                s = !overwriteJavaHome ? "    " : "";
                buf.append(s + "else" + ServerConstants.EOL + s + "  OPENDJ_JAVA_BIN=\"" + defaultJavaHome + "/bin/java\"" + ServerConstants.EOL + s + "  export OPENDJ_JAVA_BIN" + ServerConstants.EOL);
            } else if (!overwriteJavaHome) {
                buf.append("  then" + ServerConstants.EOL + "    TEMP=\"" + defaultJavaHome + "/bin/java\"" + ServerConstants.EOL + "    if test -f \"${TEMP}\"" + ServerConstants.EOL + "    then" + ServerConstants.EOL + "      OPENDJ_JAVA_BIN=\"${TEMP}\"" + ServerConstants.EOL + "      export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "    fi" + ServerConstants.EOL);
            } else {
                buf.append("OPENDJ_JAVA_BIN=\"" + defaultJavaHome + "/bin/java\"" + ServerConstants.EOL + "export OPENDJ_JAVA_BIN" + ServerConstants.EOL);
            }
            propertiesAdded = true;
        }
        if (nIfs > 0) {
            s = !overwriteJavaHome ? "    " : "";
            buf.append(s + "fi" + ServerConstants.EOL);
        }
        if (!overwriteJavaHome) {
            if (!propertiesAdded) {
                buf.append("  then" + ServerConstants.EOL + "  OPENDJ_JAVA_BIN=\"${OPENDJ_JAVA_BIN}\"" + ServerConstants.EOL);
            }
            buf.append("      else" + ServerConstants.EOL + "        OPENDJ_JAVA_BIN=\"${OPENDJ_JAVA_HOME}/bin/java\"" + ServerConstants.EOL + "        export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "      fi" + ServerConstants.EOL + "    else" + ServerConstants.EOL + "      OPENDJ_JAVA_BIN=\"${OPENDS_JAVA_BIN}\"" + ServerConstants.EOL + "      export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "    fi" + ServerConstants.EOL + "  else" + ServerConstants.EOL + "    OPENDJ_JAVA_BIN=\"${OPENDS_JAVA_HOME}/bin/java\"" + ServerConstants.EOL + "    export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "  fi" + ServerConstants.EOL + "fi" + ServerConstants.EOL + ServerConstants.EOL);
        } else if (defaultJavaHome == null) {
            buf.append(ServerConstants.EOL + "if test ! -f \"${OPENDJ_JAVA_BIN}\"" + ServerConstants.EOL + "then" + ServerConstants.EOL + "  if test ! -d \"${OPENDJ_JAVA_HOME}\"" + ServerConstants.EOL + "  then" + ServerConstants.EOL + "    if test ! -f \"${OPENDS_JAVA_BIN}\"" + ServerConstants.EOL + "    then" + ServerConstants.EOL + "      if test ! -d \"${OPENDS_JAVA_HOME}\"" + ServerConstants.EOL + "      then" + ServerConstants.EOL + "        if test ! -f \"${JAVA_BIN}\"" + ServerConstants.EOL + "        then" + ServerConstants.EOL + "          if test ! -d \"${JAVA_HOME}\"" + ServerConstants.EOL + "          then" + ServerConstants.EOL + "            OPENDJ_JAVA_BIN=`which java 2> /dev/null`" + ServerConstants.EOL + "            if test ${?} -eq 0" + ServerConstants.EOL + "            then" + ServerConstants.EOL + "              export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "            else" + ServerConstants.EOL + "              echo \"You must specify the path to a valid Java 6.0 " + "or higher version in the\"" + ServerConstants.EOL + "              echo \"properties file and then run the " + "dsjavaproperties  tool. \"" + ServerConstants.EOL + "              echo \"The procedure to follow is:\"" + ServerConstants.EOL + "              echo \"You must specify the path to a valid Java 6.0 " + "or higher version.  The \"" + ServerConstants.EOL + "              echo \"procedure to follow is:\"" + ServerConstants.EOL + "              echo \"1. Delete the file " + "${INSTANCE_ROOT}/lib/set-java-home\"" + ServerConstants.EOL + "              echo \"2. Set the environment variable " + "OPENDJ_JAVA_HOME to the root of a valid \"" + ServerConstants.EOL + "              echo \"Java 6.0 installation.\"" + ServerConstants.EOL + "              echo \"If you want to have specificjava  settings for" + " each command line you must\"" + ServerConstants.EOL + "              echo \"follow the steps 3 and 4\"" + ServerConstants.EOL + "              echo \"3. Edit the properties file specifying the " + "java binary and the java arguments\"" + ServerConstants.EOL + "              echo \"for each command line.  The java properties " + "file is located in:\"" + ServerConstants.EOL + "              echo \"${INSTANCE_ROOT}/config/java.properties.\"" + ServerConstants.EOL + "              echo \"4. Run the command-line " + "${INSTANCE_ROOT}/bin/dsjavaproperties\"" + ServerConstants.EOL + "              exit 1" + ServerConstants.EOL + "            fi" + ServerConstants.EOL + "          else" + ServerConstants.EOL + "            OPENDJ_JAVA_BIN=\"${JAVA_HOME}/bin/java\"" + ServerConstants.EOL + "            export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "          fi" + ServerConstants.EOL + "        else" + ServerConstants.EOL + "          OPENDJ_JAVA_BIN=\"${JAVA_BIN}\"" + ServerConstants.EOL + "          export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "        fi" + ServerConstants.EOL + "      else" + ServerConstants.EOL + "        OPENDJ_JAVA_BIN=\"${OPENDS_JAVA_HOME}/bin/java\"" + ServerConstants.EOL + "        export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "      fi" + ServerConstants.EOL + "    else" + ServerConstants.EOL + "      OPENDJ_JAVA_BIN=\"${OPENDS_JAVA_BIN}\"" + ServerConstants.EOL + "      export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "    fi" + ServerConstants.EOL + "  else" + ServerConstants.EOL + "    OPENDJ_JAVA_BIN=\"${OPENDJ_JAVA_HOME}/bin/java\"" + ServerConstants.EOL + "    export OPENDJ_JAVA_BIN" + ServerConstants.EOL + "  fi" + ServerConstants.EOL + "fi" + ServerConstants.EOL + ServerConstants.EOL);
        }
        if (!overwriteJavaArgs) {
            buf.append(ServerConstants.EOL + "# See if the environment variables for arguments are set." + ServerConstants.EOL + "if test -z \"${OPENDJ_JAVA_ARGS}\"" + ServerConstants.EOL + "then" + ServerConstants.EOL + "  if test -z \"${OPENDS_JAVA_ARGS}\"" + ServerConstants.EOL);
        }
        propertiesAdded = false;
        propertyNames = properties.propertyNames();
        nIfs = 0;
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            value = properties.getProperty(name);
            String string = s2 = overwriteJavaArgs ? "" : "  ";
            if (value == null || name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-args")) continue;
            propertiesAdded = true;
            if (nIfs > 0) {
                buf.append(s2 + "  elif test \"${SCRIPT_NAME}.java-args\" = \"" + name + "\"" + ServerConstants.EOL);
            } else if (!overwriteJavaArgs) {
                buf.append("  then" + ServerConstants.EOL + "    if test \"${SCRIPT_NAME}.java-args\" = \"" + name + "\"" + ServerConstants.EOL);
            } else {
                buf.append("  if test \"${SCRIPT_NAME}.java-args\" = \"" + name + "\"" + ServerConstants.EOL);
            }
            buf.append(s2 + "  then" + ServerConstants.EOL + s2 + "    OPENDJ_JAVA_ARGS=\"" + value + "\"" + ServerConstants.EOL + s2 + "    export OPENDJ_JAVA_ARGS" + ServerConstants.EOL);
            ++nIfs;
        }
        if (defaultJavaArgs != null) {
            String string = s = overwriteJavaArgs ? "" : "  ";
            if (propertiesAdded) {
                buf.append(s + "  else" + ServerConstants.EOL + s + "    OPENDJ_JAVA_ARGS=\"" + defaultJavaArgs + "\"" + ServerConstants.EOL + s + "    export OPENDJ_JAVA_ARGS" + ServerConstants.EOL);
            } else if (!overwriteJavaArgs) {
                buf.append("    then" + ServerConstants.EOL + "      OPENDJ_JAVA_ARGS=\"" + defaultJavaArgs + "\"" + ServerConstants.EOL + "      export OPENDJ_JAVA_ARGS" + ServerConstants.EOL);
            } else {
                buf.append(ServerConstants.EOL + "  OPENDJ_JAVA_ARGS=\"" + defaultJavaArgs + "\"" + ServerConstants.EOL + "  export OPENDJ_JAVA_ARGS" + ServerConstants.EOL);
            }
            propertiesAdded = true;
        }
        if (nIfs > 0) {
            s = overwriteJavaArgs ? "" : "    ";
            buf.append(s + "fi" + ServerConstants.EOL);
        }
        if (!overwriteJavaArgs) {
            if (!propertiesAdded) {
                buf.append("  then" + ServerConstants.EOL + "    OPENDJ_JAVA_ARGS=${OPENDJ_JAVA_ARGS}" + ServerConstants.EOL);
            }
            buf.append("  else" + ServerConstants.EOL + "    OPENDJ_JAVA_ARGS=${OPENDS_JAVA_ARGS}" + ServerConstants.EOL + "    export OPENDJ_JAVA_ARGS" + ServerConstants.EOL + "  fi" + ServerConstants.EOL + "fi" + ServerConstants.EOL);
        }
        return buf.toString();
    }

    private String getWindowsContents(boolean overwriteJavaHome, boolean overwriteJavaArgs, String defaultJavaHome, String defaultJavaArgs, Properties properties) {
        String scriptName;
        String value;
        String scriptName2;
        String name;
        String javaArgsLabel2;
        String javaArgsLabel1;
        String javaHomeLabel2;
        String javaHomeLabel1;
        StringBuilder buf = new StringBuilder();
        String CHECK_ENV_JAVA_HOME = "checkEnvJavaHome";
        String CHECK_ENV_JAVA_ARGS = "checkEnvJavaArgs";
        String CHECK_JAVA_HOME = "checkJavaHome";
        String CHECK_JAVA_ARGS = "checkJavaArgs";
        String CHECK_DEFAULT_JAVA_HOME = "checkDefaultJavaHome";
        String CHECK_DEFAULT_JAVA_ARGS = "checkDefaultJavaArgs";
        String LEGACY = "Legacy";
        if (!overwriteJavaHome) {
            javaHomeLabel1 = "checkEnvJavaHome";
            javaHomeLabel2 = "checkJavaHome";
        } else {
            javaHomeLabel1 = "checkJavaHome";
            javaHomeLabel2 = "checkEnvJavaHome";
        }
        if (!overwriteJavaArgs) {
            javaArgsLabel1 = "checkEnvJavaArgs";
            javaArgsLabel2 = "checkJavaArgs";
        } else {
            javaArgsLabel1 = "checkJavaArgs";
            javaArgsLabel2 = "checkEnvJavaArgs";
        }
        buf.append("goto " + javaHomeLabel1 + ServerConstants.EOL + ServerConstants.EOL);
        buf.append(":checkEnvJavaHome" + ServerConstants.EOL + "if \"%OPENDJ_JAVA_BIN%\" == \"\" goto checkEnvJavaHome" + "Legacy" + ServerConstants.EOL + "if not exist \"%OPENDJ_JAVA_BIN%\" goto checkEnvJavaHome" + "Legacy" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL + ":checkEnvJavaHome" + "Legacy" + ServerConstants.EOL + "if \"%OPENDS_JAVA_BIN%\" == \"\" goto checkOpendjJavaHome" + ServerConstants.EOL + "if not exist \"%OPENDS_JAVA_BIN%\" goto checkOpendjJavaHome" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL + ":checkOpendjJavaHome" + ServerConstants.EOL);
        if (javaHomeLabel1 == "checkEnvJavaHome") {
            buf.append("if \"%OPENDJ_JAVA_HOME%\" == \"\" goto " + javaHomeLabel2 + "Legacy" + ServerConstants.EOL + "set TEMP=%OPENDJ_JAVA_HOME%\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + javaHomeLabel2 + "Legacy" + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL + ":" + javaHomeLabel2 + "Legacy" + ServerConstants.EOL + "if \"%OPENDS_JAVA_HOME%\" == \"\" goto " + javaHomeLabel2 + ServerConstants.EOL + "set TEMP=%OPENDS_JAVA_HOME%\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + javaHomeLabel2 + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
        } else {
            buf.append("if \"%OPENDJ_JAVA_HOME%\" == \"\" goto " + javaArgsLabel1 + "Legacy" + ServerConstants.EOL + "set TEMP=%OPENDJ_JAVA_HOME%\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + javaArgsLabel1 + "Legacy" + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL + ":" + javaArgsLabel1 + "Legacy" + ServerConstants.EOL + "if \"%OPENDS_JAVA_HOME%\" == \"\" goto " + javaArgsLabel1 + ServerConstants.EOL + "set TEMP=%OPENDS_JAVA_HOME%\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + javaArgsLabel1 + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
        }
        if (defaultJavaHome != null) {
            if (javaHomeLabel1 == "checkEnvJavaHome") {
                buf.append(":checkDefaultJavaHome" + ServerConstants.EOL + "set TEMP=" + defaultJavaHome + "\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + javaArgsLabel1 + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
            } else {
                buf.append(":checkDefaultJavaHome" + ServerConstants.EOL + "set TEMP=" + defaultJavaHome + "\\bin\\java.exe" + ServerConstants.EOL + "if not exist \"%TEMP%\" goto " + "checkEnvJavaHome" + ServerConstants.EOL + "set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
            }
        }
        buf.append(":checkJavaHome" + ServerConstants.EOL);
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            if (name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-home")) continue;
            scriptName2 = name.substring(0, name.length() - ".java-home".length());
            buf.append("if \"%SCRIPT_NAME%.java-home\" == \"" + name + "\" goto check" + scriptName2 + "JavaHome" + ServerConstants.EOL);
        }
        if (defaultJavaHome != null) {
            buf.append("goto checkDefaultJavaHome" + ServerConstants.EOL + ServerConstants.EOL);
        } else if (javaHomeLabel1 != "checkEnvJavaHome") {
            buf.append("goto checkEnvJavaHome" + ServerConstants.EOL + ServerConstants.EOL);
        } else {
            buf.append("goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
        }
        propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            value = properties.getProperty(name);
            if (name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-home")) continue;
            scriptName = name.substring(0, name.length() - ".java-home".length());
            buf.append(":check" + scriptName + "JavaHome" + ServerConstants.EOL + "set TEMP=" + value + "\\bin\\java.exe" + ServerConstants.EOL);
            if (defaultJavaHome != null) {
                buf.append("if not exist \"%TEMP%\" goto checkDefaultJavaHome" + ServerConstants.EOL);
            } else if (javaHomeLabel1 != "checkEnvJavaHome") {
                buf.append("if not exist \"%TEMP%\" goto checkEnvJavaHome" + ServerConstants.EOL);
            }
            buf.append("set OPENDJ_JAVA_BIN=%TEMP%" + ServerConstants.EOL + "goto " + javaArgsLabel1 + ServerConstants.EOL + ServerConstants.EOL);
        }
        buf.append(":checkEnvJavaArgs" + ServerConstants.EOL);
        if (javaArgsLabel1 == "checkEnvJavaArgs") {
            buf.append("if \"%OPENDJ_JAVA_ARGS%\" == \"\" goto " + javaArgsLabel2 + "Legacy" + ServerConstants.EOL + "goto end" + ServerConstants.EOL + ServerConstants.EOL + ":" + javaArgsLabel2 + "Legacy" + ServerConstants.EOL + "if \"%OPENDS_JAVA_ARGS%\" == \"\" goto " + javaArgsLabel2 + ServerConstants.EOL + "set OPENDJ_JAVA_ARGS=%OPENDS_JAVA_ARGS%" + ServerConstants.EOL + "goto end" + ServerConstants.EOL + ServerConstants.EOL);
        } else {
            buf.append("goto end" + ServerConstants.EOL + ServerConstants.EOL);
        }
        if (defaultJavaArgs != null) {
            buf.append(":checkDefaultJavaArgs" + ServerConstants.EOL + "set OPENDJ_JAVA_ARGS=" + defaultJavaArgs + ServerConstants.EOL + "goto end" + ServerConstants.EOL + ServerConstants.EOL);
        }
        buf.append(":checkJavaArgs" + ServerConstants.EOL);
        propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            if (name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-args")) continue;
            scriptName2 = name.substring(0, name.length() - ".java-args".length());
            buf.append("if \"%SCRIPT_NAME%.java-args\" == \"" + name + "\" goto check" + scriptName2 + "JavaArgs" + ServerConstants.EOL);
        }
        if (defaultJavaArgs != null) {
            buf.append("goto checkDefaultJavaArgs" + ServerConstants.EOL + ServerConstants.EOL);
        } else if (javaArgsLabel1 != "checkEnvJavaArgs") {
            buf.append("goto checkEnvJavaArgs" + ServerConstants.EOL + ServerConstants.EOL);
        } else {
            buf.append("goto end" + ServerConstants.EOL + ServerConstants.EOL);
        }
        propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            name = propertyNames.nextElement().toString();
            value = properties.getProperty(name);
            if (name.equalsIgnoreCase(DEFAULT_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(DEFAULT_JAVA_ARGS_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_HOME_PROP_NAME) || name.equalsIgnoreCase(OVERWRITE_ENV_JAVA_ARGS_PROP_NAME) || !name.endsWith(".java-args")) continue;
            scriptName = name.substring(0, name.length() - ".java-args".length());
            buf.append(":check" + scriptName + "JavaArgs" + ServerConstants.EOL + "set OPENDJ_JAVA_ARGS=" + value + ServerConstants.EOL + "goto end" + ServerConstants.EOL + ServerConstants.EOL);
        }
        buf.append(":end" + ServerConstants.EOL);
        return buf.toString();
    }

    public static enum ErrorReturnCode {
        SUCCESSFUL(0),
        SUCCESSFUL_NOP(0),
        ERROR_UNEXPECTED(1),
        ERROR_USER_DATA(2),
        ERROR_WRITING_FILE(3);

        private int returnCode;

        private ErrorReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

