/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.ExportTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

public class ExportLDIF
extends TaskTool {
    private BooleanArgument appendToLDIF = null;
    private BooleanArgument compressLDIF = null;
    private BooleanArgument displayUsage = null;
    private BooleanArgument encryptLDIF = null;
    private BooleanArgument excludeOperationalAttrs = null;
    private BooleanArgument signHash = null;
    private IntegerArgument wrapColumn = null;
    private StringArgument backendID = null;
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument excludeAttributeStrings = null;
    private StringArgument excludeBranchStrings = null;
    private StringArgument excludeFilterStrings = null;
    private StringArgument includeAttributeStrings = null;
    private StringArgument includeBranchStrings = null;
    private StringArgument includeFilterStrings = null;
    private StringArgument ldifFile = null;

    public static void main(String[] args) {
        int retCode = ExportLDIF.mainExportLDIF(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainExportLDIF(String[] args) {
        return ExportLDIF.mainExportLDIF(args, true, System.out, System.err);
    }

    public static int mainExportLDIF(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        ExportLDIF tool = new ExportLDIF();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.ExportLDIF", ToolMessages.INFO_LDIFEXPORT_TOOL_DESCRIPTION.get());
        try {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            argParser.addArgument(this.configClass);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            argParser.addArgument(this.configFile);
            this.ldifFile = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", true, false, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_LDIF_FILE.get());
            argParser.addArgument(this.ldifFile);
            this.appendToLDIF = new BooleanArgument("appendldif", Character.valueOf('a'), "appendToLDIF", ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_APPEND_TO_LDIF.get());
            argParser.addArgument(this.appendToLDIF);
            this.backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_BACKEND_ID.get());
            argParser.addArgument(this.backendID);
            this.includeBranchStrings = new StringArgument("includebranch", Character.valueOf('b'), "includeBranch", false, true, true, ToolMessages.INFO_BRANCH_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_INCLUDE_BRANCH.get());
            argParser.addArgument(this.includeBranchStrings);
            this.excludeBranchStrings = new StringArgument("excludebranch", Character.valueOf('B'), "excludeBranch", false, true, true, ToolMessages.INFO_BRANCH_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_EXCLUDE_BRANCH.get());
            argParser.addArgument(this.excludeBranchStrings);
            this.includeAttributeStrings = new StringArgument("includeattribute", Character.valueOf('i'), "includeAttribute", false, true, true, ToolMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_INCLUDE_ATTRIBUTE.get());
            argParser.addArgument(this.includeAttributeStrings);
            this.excludeAttributeStrings = new StringArgument("excludeattribute", Character.valueOf('e'), "excludeAttribute", false, true, true, ToolMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_EXCLUDE_ATTRIBUTE.get());
            argParser.addArgument(this.excludeAttributeStrings);
            this.includeFilterStrings = new StringArgument("includefilter", Character.valueOf('I'), "includeFilter", false, true, true, ToolMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_INCLUDE_FILTER.get());
            argParser.addArgument(this.includeFilterStrings);
            this.excludeFilterStrings = new StringArgument("excludefilter", Character.valueOf('E'), "excludeFilter", false, true, true, ToolMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_EXCLUDE_FILTER.get());
            argParser.addArgument(this.excludeFilterStrings);
            this.excludeOperationalAttrs = new BooleanArgument("excludeoperational", Character.valueOf('O'), "excludeOperational", ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_EXCLUDE_OPERATIONAL.get());
            argParser.addArgument(this.excludeOperationalAttrs);
            this.wrapColumn = new IntegerArgument("wrapcolumn", null, "wrapColumn", false, false, true, ToolMessages.INFO_WRAP_COLUMN_PLACEHOLDER.get(), 0, null, true, 0, false, 0, ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_WRAP_COLUMN.get());
            argParser.addArgument(this.wrapColumn);
            this.compressLDIF = new BooleanArgument("compressldif", Character.valueOf('c'), "compress", ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_COMPRESS_LDIF.get());
            argParser.addArgument(this.compressLDIF);
            this.encryptLDIF = new BooleanArgument("encryptldif", Character.valueOf('y'), "encryptLDIF", ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_ENCRYPT_LDIF.get());
            this.encryptLDIF.setHidden(true);
            argParser.addArgument(this.encryptLDIF);
            this.signHash = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", ToolMessages.INFO_LDIFEXPORT_DESCRIPTION_SIGN_HASH.get());
            this.signHash.setHidden(true);
            argParser.addArgument(this.signHash);
            this.displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(this.displayUsage);
            argParser.setUsageArgument(this.displayUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.getArguments().initArgumentsWithConfiguration();
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        try {
            argParser.parseArguments(args);
            this.validateTaskArgs();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        catch (CLIException ce) {
            err.println(StaticUtils.wrapText(ce.getMessageObject(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return this.process(argParser, initializeServer, out, err);
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        LinkedList<String> excludeBranches;
        LinkedList<String> includeBranches;
        LinkedList<String> excludeFilters;
        LinkedList<String> includeFilters;
        LinkedList<String> excludeAttributes;
        LinkedList<String> includeAttributes;
        ArrayList<ByteString> values = new ArrayList<ByteString>(1);
        values.add(ByteString.valueOf(this.ldifFile.getValue()));
        attributes.add(new LDAPAttribute("ds-task-export-ldif-file", values));
        values = new ArrayList(1);
        values.add(ByteString.valueOf(this.backendID.getValue()));
        attributes.add(new LDAPAttribute("ds-task-export-backend-id", values));
        if (this.appendToLDIF.getValue() != null && !this.appendToLDIF.getValue().equals(this.appendToLDIF.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.appendToLDIF.getValue()));
            attributes.add(new LDAPAttribute("ds-task-export-append-to-ldif", values));
        }
        if (this.compressLDIF.getValue() != null && !this.compressLDIF.getValue().equals(this.compressLDIF.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.compressLDIF.getValue()));
            attributes.add(new LDAPAttribute("ds-task-export-compress-ldif", values));
        }
        if (this.encryptLDIF.getValue() != null && !this.encryptLDIF.getValue().equals(this.encryptLDIF.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.encryptLDIF.getValue()));
            attributes.add(new LDAPAttribute("ds-task-export-encrypt-ldif", values));
        }
        if (this.signHash.getValue() != null && !this.signHash.getValue().equals(this.signHash.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.signHash.getValue()));
            attributes.add(new LDAPAttribute("ds-task-export-sign-hash", values));
        }
        if ((includeAttributes = this.includeAttributeStrings.getValues()) != null && includeAttributes.size() > 0) {
            values = new ArrayList(includeAttributes.size());
            for (String includeAttribute : includeAttributes) {
                values.add(ByteString.valueOf(includeAttribute));
            }
            attributes.add(new LDAPAttribute("ds-task-export-include-attribute", values));
        }
        if ((excludeAttributes = this.excludeAttributeStrings.getValues()) != null && excludeAttributes.size() > 0) {
            values = new ArrayList(excludeAttributes.size());
            for (String excludeAttribute : excludeAttributes) {
                values.add(ByteString.valueOf(excludeAttribute));
            }
            attributes.add(new LDAPAttribute("ds-task-export-exclude-attribute", values));
        }
        if ((includeFilters = this.includeFilterStrings.getValues()) != null && includeFilters.size() > 0) {
            values = new ArrayList(includeFilters.size());
            for (String includeFilter : includeFilters) {
                values.add(ByteString.valueOf(includeFilter));
            }
            attributes.add(new LDAPAttribute("ds-task-export-include-filter", values));
        }
        if ((excludeFilters = this.excludeFilterStrings.getValues()) != null && excludeFilters.size() > 0) {
            values = new ArrayList(excludeFilters.size());
            for (String excludeFilter : excludeFilters) {
                values.add(ByteString.valueOf(excludeFilter));
            }
            attributes.add(new LDAPAttribute("ds-task-export-exclude-filter", values));
        }
        if ((includeBranches = this.includeBranchStrings.getValues()) != null && includeBranches.size() > 0) {
            values = new ArrayList(includeBranches.size());
            for (String includeBranche : includeBranches) {
                values.add(ByteString.valueOf(includeBranche));
            }
            attributes.add(new LDAPAttribute("ds-task-export-include-branch", values));
        }
        if ((excludeBranches = this.excludeBranchStrings.getValues()) != null && excludeBranches.size() > 0) {
            values = new ArrayList(excludeBranches.size());
            for (String excludeBranche : excludeBranches) {
                values.add(ByteString.valueOf(excludeBranche));
            }
            attributes.add(new LDAPAttribute("ds-task-export-exclude-branch", values));
        }
        if (this.wrapColumn.getValue() != null && !this.wrapColumn.getValue().equals(this.wrapColumn.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.wrapColumn.getValue()));
            attributes.add(new LDAPAttribute("ds-task-export-wrap-column", values));
        }
        if (this.excludeOperationalAttrs.isPresent()) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf("false"));
            attributes.add(new LDAPAttribute("ds-task-export-include-operational-attributes", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-export";
    }

    @Override
    public Class<?> getTaskClass() {
        return ExportTask.class;
    }

    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        Message message;
        ArrayList<DN> includeBranches;
        ArrayList<SearchFilter> includeFilters;
        ArrayList<SearchFilter> excludeFilters;
        HashSet<AttributeType> includeAttributes;
        HashSet<AttributeType> excludeAttributes;
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            Message message2;
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message3 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message4 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message5 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message8 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message9 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message10 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message14 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getToolStartupTextErrorPublisher(new TextWriter.STREAM(out));
                TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                DebugLogger.addDebugLogPublisher(debugLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
            try {
                HashSet<PluginType> pluginTypes = new HashSet<PluginType>(1);
                pluginTypes.add(PluginType.LDIF_EXPORT);
                directoryServer.initializePlugins(pluginTypes);
            }
            catch (ConfigException ce) {
                message2 = ToolMessages.ERR_LDIFEXPORT_CANNOT_INITIALIZE_PLUGINS.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                message2 = ToolMessages.ERR_LDIFEXPORT_CANNOT_INITIALIZE_PLUGINS.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                message2 = ToolMessages.ERR_LDIFEXPORT_CANNOT_INITIALIZE_PLUGINS.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (this.excludeAttributeStrings == null) {
            excludeAttributes = null;
        } else {
            excludeAttributes = new HashSet<AttributeType>();
            for (String attrName : this.excludeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                excludeAttributes.add(attrType);
            }
        }
        if (this.includeAttributeStrings == null) {
            includeAttributes = null;
        } else {
            includeAttributes = new HashSet<AttributeType>();
            for (String attrName : this.includeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
        }
        if (this.excludeFilterStrings == null) {
            excludeFilters = null;
        } else {
            excludeFilters = new ArrayList<SearchFilter>();
            for (String filterString : this.excludeFilterStrings.getValues()) {
                try {
                    excludeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    Message message15 = ToolMessages.ERR_LDIFEXPORT_CANNOT_PARSE_EXCLUDE_FILTER.get(filterString, de.getMessageObject());
                    ErrorLogger.logError(message15);
                    return 1;
                }
                catch (Exception e) {
                    Message message16 = ToolMessages.ERR_LDIFEXPORT_CANNOT_PARSE_EXCLUDE_FILTER.get(filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message16);
                    return 1;
                }
            }
        }
        if (this.includeFilterStrings == null) {
            includeFilters = null;
        } else {
            includeFilters = new ArrayList<SearchFilter>();
            for (String filterString : this.includeFilterStrings.getValues()) {
                try {
                    includeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    Message message17 = ToolMessages.ERR_LDIFEXPORT_CANNOT_PARSE_INCLUDE_FILTER.get(filterString, de.getMessageObject());
                    ErrorLogger.logError(message17);
                    return 1;
                }
                catch (Exception e) {
                    Message message18 = ToolMessages.ERR_LDIFEXPORT_CANNOT_PARSE_INCLUDE_FILTER.get(filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message18);
                    return 1;
                }
            }
        }
        Backend backend = null;
        List<DN> baseDNList = null;
        ArrayList<DN> defaultIncludeBranches = null;
        ArrayList<DN> excludeBranches = null;
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            if (!this.backendID.getValue().equals(b.getBackendID())) continue;
            if (backend == null) {
                backend = b;
                baseDNList = dnList.get(i);
                defaultIncludeBranches = dnList.get(i);
                continue;
            }
            Message message19 = ToolMessages.ERR_LDIFEXPORT_MULTIPLE_BACKENDS_FOR_ID.get(this.backendID.getValue());
            ErrorLogger.logError(message19);
            return 1;
        }
        if (backend == null) {
            Message message20 = ToolMessages.ERR_LDIFEXPORT_NO_BACKENDS_FOR_ID.get(this.backendID.getValue());
            ErrorLogger.logError(message20);
            return 1;
        }
        if (!backend.supportsLDIFExport()) {
            Message message21 = ToolMessages.ERR_LDIFEXPORT_CANNOT_EXPORT_BACKEND.get(this.backendID.getValue());
            ErrorLogger.logError(message21);
            return 1;
        }
        if (this.excludeBranchStrings.isPresent()) {
            excludeBranches = new ArrayList<DN>();
            for (String s : this.excludeBranchStrings.getValues()) {
                DN excludeBranch;
                try {
                    excludeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    Message message22 = ToolMessages.ERR_LDIFEXPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, de.getMessageObject());
                    ErrorLogger.logError(message22);
                    return 1;
                }
                catch (Exception e) {
                    Message message23 = ToolMessages.ERR_LDIFEXPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message23);
                    return 1;
                }
                if (excludeBranches.contains(excludeBranch)) continue;
                excludeBranches.add(excludeBranch);
            }
        }
        if (this.includeBranchStrings.isPresent()) {
            includeBranches = new ArrayList<DN>();
            for (String s : this.includeBranchStrings.getValues()) {
                DN includeBranch;
                try {
                    includeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    Message message24 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, de.getMessageObject());
                    ErrorLogger.logError(message24);
                    return 1;
                }
                catch (Exception e) {
                    Message message25 = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message25);
                    return 1;
                }
                if (!Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) {
                    Message message26 = ToolMessages.ERR_LDIFEXPORT_INVALID_INCLUDE_BASE.get(s, this.backendID.getValue());
                    ErrorLogger.logError(message26);
                    return 1;
                }
                includeBranches.add(includeBranch);
            }
        } else {
            includeBranches = defaultIncludeBranches;
        }
        ExistingFileBehavior existingBehavior = this.appendToLDIF.isPresent() ? ExistingFileBehavior.APPEND : ExistingFileBehavior.OVERWRITE;
        LDIFExportConfig exportConfig = new LDIFExportConfig(this.ldifFile.getValue(), existingBehavior);
        exportConfig.setCompressData(this.compressLDIF.isPresent());
        exportConfig.setEncryptData(this.encryptLDIF.isPresent());
        exportConfig.setExcludeAttributes(excludeAttributes);
        exportConfig.setExcludeBranches(excludeBranches);
        exportConfig.setExcludeFilters(excludeFilters);
        exportConfig.setIncludeAttributes(includeAttributes);
        exportConfig.setIncludeBranches(includeBranches);
        exportConfig.setIncludeFilters(includeFilters);
        exportConfig.setSignHash(this.signHash.isPresent());
        exportConfig.setIncludeOperationalAttributes(!this.excludeOperationalAttrs.isPresent());
        exportConfig.setInvokeExportPlugins(true);
        try {
            exportConfig.setWrapColumn(this.wrapColumn.getIntValue());
        }
        catch (ArgumentException ae) {
            Message message27 = ToolMessages.ERR_LDIFEXPORT_CANNOT_DECODE_WRAP_COLUMN_AS_INTEGER.get(this.wrapColumn.getValue());
            ErrorLogger.logError(message27);
            return 1;
        }
        DN[] baseDNs = new DN[baseDNList.size()];
        baseDNList.toArray(baseDNs);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message28 = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message28);
                return 1;
            }
        }
        catch (Exception e) {
            Message message29 = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message29);
            return 1;
        }
        boolean errorOccurred = false;
        try {
            backend.exportLDIF(exportConfig);
        }
        catch (DirectoryException de) {
            message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(de.getMessageObject());
            ErrorLogger.logError(message);
            errorOccurred = true;
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            errorOccurred = true;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message30 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message30);
            }
        }
        catch (Exception e) {
            message = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        exportConfig.close();
        if (!errorOccurred) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getTaskId() {
        return null;
    }
}

