/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public class BackendToolUtils {
    public static int getBackends(ArrayList<Backend> backendList, ArrayList<BackendCfg> entryList, ArrayList<List<DN>> dnList) {
        ConfigEntry baseEntry;
        DN backendBaseDN;
        try {
            backendBaseDN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException de) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BACKEND_BASE_DN.get("cn=Backends,cn=config", de.getMessageObject());
            ErrorLogger.logError(message);
            return 1;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BACKEND_BASE_DN.get("cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            return 1;
        }
        try {
            baseEntry = DirectoryServer.getConfigEntry(backendBaseDN);
        }
        catch (ConfigException ce) {
            Message message = ToolMessages.ERR_CANNOT_RETRIEVE_BACKEND_BASE_ENTRY.get("cn=Backends,cn=config", ce.getMessage());
            ErrorLogger.logError(message);
            return 1;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_RETRIEVE_BACKEND_BASE_ENTRY.get("cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            return 1;
        }
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        for (ConfigEntry configEntry : baseEntry.getChildren().values()) {
            BackendCfg cfg;
            Backend backend;
            Class<?> backendClass;
            Message message;
            String backendClassName;
            Message message2;
            String backendID;
            try {
                StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BACKEND_ID.get(), true, false, true);
                StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
                if (idAttr == null) continue;
                backendID = idAttr.activeValue();
            }
            catch (ConfigException ce) {
                message2 = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_ID.get(String.valueOf(configEntry.getDN()), ce.getMessage());
                ErrorLogger.logError(message2);
                return 1;
            }
            catch (Exception e) {
                message2 = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_ID.get(String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message2);
                return 1;
            }
            try {
                StringConfigAttribute classStub = new StringConfigAttribute("ds-cfg-java-class", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_CLASS.get(), true, false, false);
                StringConfigAttribute classAttr = (StringConfigAttribute)configEntry.getConfigAttribute(classStub);
                if (classAttr == null) continue;
                backendClassName = classAttr.activeValue();
            }
            catch (ConfigException ce) {
                message = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_CLASS.get(String.valueOf(configEntry.getDN()), ce.getMessage());
                ErrorLogger.logError(message);
                return 1;
            }
            catch (Exception e) {
                message = ToolMessages.ERR_CANNOT_DETERMINE_BACKEND_CLASS.get(String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
                return 1;
            }
            try {
                backendClass = Class.forName(backendClassName);
            }
            catch (Exception e) {
                Message message3 = ToolMessages.ERR_CANNOT_LOAD_BACKEND_CLASS.get(backendClassName, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message3);
                return 1;
            }
            try {
                backend = (Backend)backendClass.newInstance();
                backend.setBackendID(backendID);
                cfg = root.getBackend(backendID);
                backend.configureBackend(cfg);
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_CANNOT_INSTANTIATE_BACKEND_CLASS.get(backendClassName, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message4);
                return 1;
            }
            List<DN> baseDNs = null;
            try {
                DNConfigAttribute baseDNStub = new DNConfigAttribute("ds-cfg-base-dn", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BASE_DNS.get(), true, true, true);
                DNConfigAttribute baseDNAttr = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
                if (baseDNAttr == null) {
                    Message message5 = ToolMessages.ERR_NO_BASES_FOR_BACKEND.get(String.valueOf(configEntry.getDN()));
                    ErrorLogger.logError(message5);
                } else {
                    baseDNs = baseDNAttr.activeValues();
                }
            }
            catch (Exception e) {
                Message message6 = ToolMessages.ERR_CANNOT_DETERMINE_BASES_FOR_BACKEND.get(String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message6);
                return 1;
            }
            backendList.add(backend);
            entryList.add(cfg);
            dnList.add(baseDNs);
        }
        return 0;
    }
}

