/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;

public class InitializeTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String domainString = null;
    private int source;
    private LDAPReplicationDomain domain = null;
    private TaskState initState;
    long total = 0L;
    long left = 0L;
    private Message taskCompletionError = null;

    @Override
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_INITIALIZE_NAME.get();
    }

    @Override
    public void initializeTask() throws DirectoryException {
        if (TaskState.isDone(this.getTaskState())) {
            return;
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-initialize-domain-dn", true);
        AttributeType typeSourceScope = DirectoryServer.getAttributeType("ds-task-initialize-replica-server-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        try {
            DN dn = DN.decode(this.domainString);
            this.domain = LDAPReplicationDomain.retrievesReplicationDomain(dn);
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_DN.get());
            mb.append(e.getMessage());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, e);
        }
        attrList = taskEntry.getAttribute(typeSourceScope);
        String sourceString = TaskUtils.getSingleValueString(attrList);
        this.source = this.domain.decodeSource(sourceString);
        this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(0));
        this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskState runTask() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] InitializeTask is starting on domain: %s  from source:%d", this.domain.getServiceID(), this.source);
        }
        this.initState = this.getTaskState();
        try {
            this.domain.initializeFromRemote(this.source, this);
            TaskState taskState = this.initState;
            synchronized (taskState) {
                while (this.initState == TaskState.RUNNING) {
                    ((Object)((Object)this.initState)).wait(1000L);
                    this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(this.left));
                    this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(this.total - this.left));
                }
            }
            this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(this.left));
            this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(this.total - this.left));
            if (this.taskCompletionError != null) {
                this.logError(this.taskCompletionError);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (DirectoryException de) {
            this.logError(de.getMessageObject());
            this.initState = TaskState.STOPPED_BY_ERROR;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] InitializeTask is ending with state:%s", this.initState.toString());
        }
        return this.initState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskCompletionState(DirectoryException de) {
        this.initState = TaskState.STOPPED_BY_ERROR;
        try {
            if (de == null) {
                this.initState = TaskState.COMPLETED_SUCCESSFULLY;
            } else {
                this.taskCompletionError = de.getMessageObject();
            }
        }
        finally {
            TaskState taskState = this.initState;
            synchronized (taskState) {
                ((Object)((Object)this.initState)).notify();
            }
        }
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setLeft(long left) {
        this.left = left;
    }
}

