/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

public class AddSchemaFileTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    TreeSet<String> filesToAdd;

    @Override
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_ADD_SCHEMA_FILE_NAME.get();
    }

    @Override
    public void initializeTask() throws DirectoryException {
        AttributeType attrType;
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.UPDATE_SCHEMA, operation)) {
            Message message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        List<Attribute> attrList = taskEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-task-schema-file-name", true));
        if (attrList == null || attrList.isEmpty()) {
            Message message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_NO_FILENAME.get("ds-task-schema-file-name", String.valueOf(taskEntry.getDN()));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        String schemaInstanceDirectory = SchemaConfigManager.getSchemaDirectoryPath();
        this.filesToAdd = new TreeSet();
        for (Attribute a : attrList) {
            for (AttributeValue v : a) {
                String filename = v.getValue().toString();
                this.filesToAdd.add(filename);
                try {
                    File schemaFile = new File(schemaInstanceDirectory, filename);
                    if (schemaFile.exists()) continue;
                    Message message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_NO_SUCH_FILE.get(filename, schemaInstanceDirectory);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_ERROR_CHECKING_FOR_FILE.get(filename, schemaInstanceDirectory, StaticUtils.getExceptionMessage(e));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, e);
                }
            }
        }
        Schema schema = DirectoryServer.getSchema().duplicate();
        for (String schemaFile : this.filesToAdd) {
            Message message;
            try {
                SchemaConfigManager.loadSchemaFile(schema, schemaFile);
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_ERROR_LOADING_SCHEMA_FILE.get(String.valueOf(schemaFile), ce.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, ce);
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_ERROR_LOADING_SCHEMA_FILE.get(String.valueOf(schemaFile), ie.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected TaskState runTask() {
        DN schemaDN = DirectoryServer.getSchemaDN();
        Lock schemaLock = LockManager.lockWrite(schemaDN);
        if (schemaLock == null) {
            Message message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_CANNOT_LOCK_SCHEMA.get(String.valueOf(schemaDN));
            this.logError(message);
            return TaskState.STOPPED_BY_ERROR;
        }
        try {
            Message message;
            LinkedList<Modification> mods = new LinkedList<Modification>();
            Schema schema = DirectoryServer.getSchema().duplicate();
            for (String schemaFile : this.filesToAdd) {
                TaskState taskState;
                try {
                    List<Modification> modList = SchemaConfigManager.loadSchemaFile(schema, schemaFile);
                    for (Modification m : modList) {
                        Attribute a = m.getAttribute();
                        AttributeBuilder builder = new AttributeBuilder(a.getAttributeType(), a.getName());
                        for (AttributeValue v : a) {
                            String s = v.getValue().toString();
                            if (!s.contains("X-SCHEMA-FILE")) {
                                if (s.endsWith(" )")) {
                                    s = s.substring(0, s.length() - 1) + "X-SCHEMA-FILE" + " '" + schemaFile + "' )";
                                } else if (s.endsWith(")")) {
                                    s = s.substring(0, s.length() - 1) + " " + "X-SCHEMA-FILE" + " '" + schemaFile + "' )";
                                }
                            }
                            builder.add(AttributeValues.create(a.getAttributeType(), s));
                        }
                        mods.add(new Modification(m.getModificationType(), builder.toAttribute()));
                    }
                }
                catch (ConfigException ce) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                    }
                    message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_ERROR_LOADING_SCHEMA_FILE.get(String.valueOf(schemaFile), ce.getMessage());
                    this.logError(message);
                    taskState = TaskState.STOPPED_BY_ERROR;
                    LockManager.unlock(schemaDN, schemaLock);
                    return taskState;
                }
                catch (InitializationException ie) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                    message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_ERROR_LOADING_SCHEMA_FILE.get(String.valueOf(schemaFile), ie.getMessage());
                    this.logError(message);
                    taskState = TaskState.STOPPED_BY_ERROR;
                    LockManager.unlock(schemaDN, schemaLock);
                    return taskState;
                }
            }
            if (!mods.isEmpty()) {
                for (SynchronizationProvider provider : DirectoryServer.getSynchronizationProviders()) {
                    try {
                        provider.processSchemaChange(mods);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = TaskMessages.ERR_TASK_ADDSCHEMAFILE_CANNOT_NOTIFY_SYNC_PROVIDER.get(provider.getClass().getName(), StaticUtils.getExceptionMessage(e));
                        this.logError(message);
                    }
                }
                Schema.writeConcatenatedSchema();
            }
            schema.setYoungestModificationTime(System.currentTimeMillis());
            DirectoryServer.setSchema(schema);
            TaskState taskState = TaskState.COMPLETED_SUCCESSFULLY;
            return taskState;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LockManager.unlock(schemaDN, schemaLock);
        }
    }
}

