/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

class UUIDEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "uuidMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.1.16.2";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.1.16.1";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        if (value.length() != 36) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH.get(value.toString(), value.length());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    ErrorLogger.logError(message);
                    return value.toByteString();
                }
            }
            return value.toByteString();
        }
        StringBuilder builder = new StringBuilder(36);
        block24: for (int i = 0; i < 36; ++i) {
            char c = (char)value.byteAt(i);
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (c != '-') {
                        Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH.get(value.toString(), i, String.valueOf(c));
                        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                            case REJECT: {
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                            }
                            case WARN: {
                                ErrorLogger.logError(message);
                                return value.toByteString();
                            }
                        }
                        return value.toByteString();
                    }
                    builder.append(c);
                    continue block24;
                }
                default: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            builder.append(c);
                            continue block24;
                        }
                        case 'A': {
                            builder.append('a');
                            continue block24;
                        }
                        case 'B': {
                            builder.append('b');
                            continue block24;
                        }
                        case 'C': {
                            builder.append('c');
                            continue block24;
                        }
                        case 'D': {
                            builder.append('d');
                            continue block24;
                        }
                        case 'E': {
                            builder.append('e');
                            continue block24;
                        }
                        case 'F': {
                            builder.append('f');
                            continue block24;
                        }
                    }
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX.get(value.toString(), i, String.valueOf(value.byteAt(i)));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            ErrorLogger.logError(message);
                            return value.toByteString();
                        }
                    }
                    return value.toByteString();
                }
            }
        }
        return ByteString.valueOf(builder.toString());
    }
}

