/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.ExtensibleIndexer;
import org.opends.server.api.ExtensibleMatchingRule;
import org.opends.server.api.IndexQueryFactory;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.MatchingRuleFactory;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.IndexConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class TimeBasedMatchingRuleFactory
extends MatchingRuleFactory<MatchingRuleCfg> {
    private MatchingRule greaterThanRTMRule;
    private MatchingRule lessThanRTMRule;
    private MatchingRule partialDTMatchingRule;
    private Set<MatchingRule> matchingRules;
    private static final TimeZone TIME_ZONE_UTC_OBJ = TimeZone.getTimeZone("UTC");
    private static final char SECOND = 's';
    private static final char MINUTE = 'm';
    private static final char HOUR = 'h';
    private static final char MONTH = 'M';
    private static final char DATE = 'D';
    private static final char YEAR = 'Y';

    @Override
    public void initializeMatchingRule(MatchingRuleCfg configuration) throws ConfigException, InitializationException {
        this.matchingRules = new HashSet<MatchingRule>();
        this.greaterThanRTMRule = new RelativeTimeGTOrderingMatchingRule();
        this.matchingRules.add(this.greaterThanRTMRule);
        this.lessThanRTMRule = new RelativeTimeLTOrderingMatchingRule();
        this.matchingRules.add(this.lessThanRTMRule);
        this.partialDTMatchingRule = new PartialDateAndTimeMatchingRule();
        this.matchingRules.add(this.partialDTMatchingRule);
    }

    @Override
    public Collection<MatchingRule> getMatchingRules() {
        return Collections.unmodifiableCollection(this.matchingRules);
    }

    private final class PartialDateAndTimeExtensibleIndexer
    extends ExtensibleIndexer {
        private final PartialDateAndTimeMatchingRule matchingRule;

        private PartialDateAndTimeExtensibleIndexer(PartialDateAndTimeMatchingRule matchingRule) {
            this.matchingRule = matchingRule;
        }

        @Override
        public void getKeys(AttributeValue value, Set<byte[]> keys) {
            this.matchingRule.timeKeys(value.getValue(), keys);
        }

        @Override
        public void getKeys(AttributeValue attValue, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
            HashSet<byte[]> keys = new HashSet<byte[]>();
            this.getKeys(attValue, keys);
            for (byte[] key : keys) {
                Boolean cInsert = modifiedKeys.get(key);
                if (cInsert == null) {
                    modifiedKeys.put(key, insert);
                    continue;
                }
                if (cInsert.equals(insert)) continue;
                modifiedKeys.remove(key);
            }
        }

        @Override
        public String getPreferredIndexName() {
            return "pdt";
        }

        @Override
        public String getExtensibleIndexID() {
            return "ext";
        }
    }

    private final class PartialDateAndTimeMatchingRule
    extends TimeBasedMatchingRule
    implements ExtensibleMatchingRule {
        private ExtensibleIndexer indexer;

        private PartialDateAndTimeMatchingRule() {
        }

        @Override
        public String getName() {
            return "partialDateAndTimeMatchingRule";
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.26027.1.4.7";
        }

        @Override
        public Collection<String> getAllNames() {
            return Collections.singleton(this.getName());
        }

        @Override
        public ByteString normalizeAssertionValue(ByteSequence value) throws DirectoryException {
            int second = -1;
            int minute = -1;
            int hour = -1;
            int date = 0;
            int year = 0;
            int number = 0;
            int month = -1;
            int length = value.length();
            for (int index = 0; index < length; ++index) {
                byte b = value.byteAt(index);
                if (StaticUtils.isDigit((char)b)) {
                    switch (value.byteAt(index)) {
                        case 48: {
                            number *= 10;
                            break;
                        }
                        case 49: {
                            number = number * 10 + 1;
                            break;
                        }
                        case 50: {
                            number = number * 10 + 2;
                            break;
                        }
                        case 51: {
                            number = number * 10 + 3;
                            break;
                        }
                        case 52: {
                            number = number * 10 + 4;
                            break;
                        }
                        case 53: {
                            number = number * 10 + 5;
                            break;
                        }
                        case 54: {
                            number = number * 10 + 6;
                            break;
                        }
                        case 55: {
                            number = number * 10 + 7;
                            break;
                        }
                        case 56: {
                            number = number * 10 + 8;
                            break;
                        }
                        case 57: {
                            number = number * 10 + 9;
                        }
                    }
                    continue;
                }
                Message message = null;
                switch (value.byteAt(index)) {
                    case 115: {
                        if (second > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_SECOND_ASSERTION_FORMAT.get(value.toString(), date);
                            break;
                        }
                        second = number;
                        break;
                    }
                    case 109: {
                        if (minute > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_MINUTE_ASSERTION_FORMAT.get(value.toString(), date);
                            break;
                        }
                        minute = number;
                        break;
                    }
                    case 104: {
                        if (hour > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_HOUR_ASSERTION_FORMAT.get(value.toString(), date);
                            break;
                        }
                        hour = number;
                        break;
                    }
                    case 68: {
                        if (number == 0) {
                            message = SchemaMessages.WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT.get(value.toString(), number);
                            break;
                        }
                        if (date > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_DATE_ASSERTION_FORMAT.get(value.toString(), date);
                            break;
                        }
                        date = number;
                        break;
                    }
                    case 77: {
                        if (number == 0) {
                            message = SchemaMessages.WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT.get(value.toString(), number);
                            break;
                        }
                        if (month > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_MONTH_ASSERTION_FORMAT.get(value.toString(), month);
                            break;
                        }
                        month = number;
                        break;
                    }
                    case 89: {
                        if (number == 0) {
                            message = SchemaMessages.WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT.get(value.toString(), number);
                            break;
                        }
                        if (year > 0) {
                            message = SchemaMessages.WARN_ATTR_DUPLICATE_YEAR_ASSERTION_FORMAT.get(value.toString(), year);
                            break;
                        }
                        year = number;
                        break;
                    }
                    default: {
                        message = SchemaMessages.WARN_ATTR_INVALID_PARTIAL_TIME_ASSERTION_FORMAT.get(value.toString(), Character.valueOf((char)value.byteAt(index)));
                    }
                }
                if (message != null) {
                    ErrorLogger.logError(message);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                number = 0;
            }
            if (year < 0) {
                Message message = SchemaMessages.WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT.get(value.toString(), year);
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            switch (month) {
                case -1: {
                    break;
                }
                case 1: {
                    month = 0;
                    break;
                }
                case 2: {
                    month = 1;
                    break;
                }
                case 3: {
                    month = 2;
                    break;
                }
                case 4: {
                    month = 3;
                    break;
                }
                case 5: {
                    month = 4;
                    break;
                }
                case 6: {
                    month = 5;
                    break;
                }
                case 7: {
                    month = 6;
                    break;
                }
                case 8: {
                    month = 7;
                    break;
                }
                case 9: {
                    month = 8;
                    break;
                }
                case 10: {
                    month = 9;
                    break;
                }
                case 11: {
                    month = 10;
                    break;
                }
                case 12: {
                    month = 11;
                    break;
                }
                default: {
                    Message message = SchemaMessages.WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT.get(value.toString(), month);
                    ErrorLogger.logError(message);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
            boolean invalidDate = false;
            switch (date) {
                case 29: {
                    if (month != 1 || year % 4 == 0) break;
                    invalidDate = true;
                    break;
                }
                case 31: {
                    if (month == -1 || month == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11) break;
                    invalidDate = true;
                    break;
                }
                default: {
                    if (date >= 0 && date <= 31) break;
                    invalidDate = true;
                }
            }
            if (invalidDate) {
                Message message = SchemaMessages.WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT.get(value.toString(), date);
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (hour < -1 || hour > 23) {
                Message message = SchemaMessages.WARN_ATTR_INVALID_HOUR_ASSERTION_FORMAT.get(value.toString(), date);
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (minute < -1 || minute > 59) {
                Message message = SchemaMessages.WARN_ATTR_INVALID_MINUTE_ASSERTION_FORMAT.get(value.toString(), date);
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (second < -1 || second > 60) {
                Message message = SchemaMessages.WARN_ATTR_INVALID_SECOND_ASSERTION_FORMAT.get(value.toString(), date);
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            ByteBuffer bb = ByteBuffer.allocate(24);
            bb.putInt(second);
            bb.putInt(minute);
            bb.putInt(hour);
            bb.putInt(date);
            bb.putInt(month);
            bb.putInt(year);
            return ByteString.wrap(bb.array());
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            long timeInMS = ((ByteString)attributeValue).toLong();
            GregorianCalendar cal = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
            cal.setLenient(false);
            cal.setTimeInMillis(timeInMS);
            int second = cal.get(13);
            int minute = cal.get(12);
            int hour = cal.get(11);
            int date = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            ByteBuffer bb = ByteBuffer.wrap(assertionValue.toByteArray());
            int assertSecond = bb.getInt(0);
            int assertMinute = bb.getInt(4);
            int assertHour = bb.getInt(8);
            int assertDate = bb.getInt(12);
            int assertMonth = bb.getInt(16);
            int assertYear = bb.getInt(20);
            if (assertSecond != -1 && assertSecond != second) {
                return ConditionResult.FALSE;
            }
            if (assertMinute != -1 && assertMinute != minute) {
                return ConditionResult.FALSE;
            }
            if (assertHour != -1 && assertHour != hour) {
                return ConditionResult.FALSE;
            }
            if (assertDate != 0 && assertDate != date) {
                return ConditionResult.FALSE;
            }
            if (assertMonth != -1 && assertMonth != month) {
                return ConditionResult.FALSE;
            }
            if (assertYear != 0 && assertYear != year) {
                return ConditionResult.FALSE;
            }
            return ConditionResult.TRUE;
        }

        @Override
        public Collection<ExtensibleIndexer> getIndexers(IndexConfig config) {
            if (this.indexer == null) {
                this.indexer = new PartialDateAndTimeExtensibleIndexer(this);
            }
            return Collections.singletonList(this.indexer);
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            byte[] arr = this.normalizeAssertionValue(assertionValue).toByteArray();
            ByteBuffer bb = ByteBuffer.wrap(arr);
            int assertSecond = bb.getInt(0);
            int assertMinute = bb.getInt(4);
            int assertHour = bb.getInt(8);
            int assertDate = bb.getInt(12);
            int assertMonth = bb.getInt(16);
            int assertYear = bb.getInt(20);
            ArrayList<T> queries = new ArrayList<T>();
            if (assertSecond >= 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertSecond, 's')));
            }
            if (assertMinute >= 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertMinute, 'm')));
            }
            if (assertHour >= 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertHour, 'h')));
            }
            if (assertDate > 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertDate, 'D')));
            }
            if (assertMonth >= 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertMonth, 'M')));
            }
            if (assertYear > 0) {
                queries.add(factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.getKey(assertYear, 'Y')));
            }
            return factory.createIntersectionQuery(queries);
        }

        private void timeKeys(ByteString attributeValue, Set<byte[]> keys) {
            long timeInMS = 0L;
            try {
                timeInMS = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(attributeValue);
            }
            catch (DirectoryException de) {
                return;
            }
            GregorianCalendar cal = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
            cal.setTimeInMillis(timeInMS);
            int second = cal.get(13);
            int minute = cal.get(12);
            int hour = cal.get(11);
            int date = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            if (second >= 0) {
                keys.add(this.getKey(second, 's').toByteArray());
            }
            if (minute >= 0) {
                keys.add(this.getKey(minute, 'm').toByteArray());
            }
            if (hour >= 0) {
                keys.add(this.getKey(hour, 'h').toByteArray());
            }
            if (date > 0) {
                keys.add(this.getKey(date, 'D').toByteArray());
            }
            if (month >= 0) {
                keys.add(this.getKey(month, 'M').toByteArray());
            }
            if (year > 0) {
                keys.add(this.getKey(year, 'Y').toByteArray());
            }
        }

        private ByteString getKey(int value, char type) {
            ByteStringBuilder builder = new ByteStringBuilder();
            builder.append(type);
            builder.append(value);
            return builder.toByteString();
        }
    }

    private final class RelativeTimeExtensibleIndexer
    extends ExtensibleIndexer {
        private final RelativeTimeOrderingMatchingRule matchingRule;

        private RelativeTimeExtensibleIndexer(RelativeTimeOrderingMatchingRule matchingRule) {
            this.matchingRule = matchingRule;
        }

        @Override
        public String getExtensibleIndexID() {
            return "ext";
        }

        @Override
        public final void getKeys(AttributeValue value, Set<byte[]> keys) {
            try {
                ByteString key = this.matchingRule.normalizeValue(value.getValue());
                keys.add(key.toByteArray());
            }
            catch (DirectoryException de) {
                // empty catch block
            }
        }

        @Override
        public final void getKeys(AttributeValue value, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
            HashSet<byte[]> keys = new HashSet<byte[]>();
            this.getKeys(value, keys);
            for (byte[] key : keys) {
                Boolean cInsert = modifiedKeys.get(key);
                if (cInsert == null) {
                    modifiedKeys.put(key, insert);
                    continue;
                }
                if (cInsert.equals(insert)) continue;
                modifiedKeys.remove(key);
            }
        }

        @Override
        public String getPreferredIndexName() {
            return "rt";
        }
    }

    private final class RelativeTimeLTOrderingMatchingRule
    extends RelativeTimeOrderingMatchingRule {
        private final List<String> names;
        private static final long serialVersionUID = -5122459830973558441L;

        RelativeTimeLTOrderingMatchingRule() {
            this.names = new ArrayList<String>();
            this.names.add("relativeTimeLTOrderingMatch");
            this.names.add("relativeTimeOrderingMatch.lt");
        }

        @Override
        public String getName() {
            return "relativeTimeLTOrderingMatch";
        }

        @Override
        public Collection<String> getAllNames() {
            return Collections.unmodifiableList(this.names);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.26027.1.4.6";
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = this.compareValues(attributeValue, assertionValue);
            if (ret < 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), ByteString.empty(), this.normalizeAssertionValue(assertionValue), false, false);
        }
    }

    private final class RelativeTimeGTOrderingMatchingRule
    extends RelativeTimeOrderingMatchingRule {
        private final List<String> names;
        private static final long serialVersionUID = 7247241496402474136L;

        RelativeTimeGTOrderingMatchingRule() {
            this.names = new ArrayList<String>();
            this.names.add("relativeTimeGTOrderingMatch");
            this.names.add("relativeTimeOrderingMatch.gt");
        }

        @Override
        public String getName() {
            return "relativeTimeGTOrderingMatch";
        }

        @Override
        public Collection<String> getAllNames() {
            return Collections.unmodifiableList(this.names);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.26027.1.4.5";
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = this.compareValues(attributeValue, assertionValue);
            if (ret > 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), this.normalizeAssertionValue(assertionValue), ByteString.empty(), false, false);
        }
    }

    private abstract class RelativeTimeOrderingMatchingRule
    extends TimeBasedMatchingRule
    implements OrderingMatchingRule {
        private static final long serialVersionUID = -3501812894473163490L;
        protected ExtensibleIndexer indexer;

        private RelativeTimeOrderingMatchingRule() {
        }

        @Override
        public ByteString normalizeAssertionValue(ByteSequence value) throws DirectoryException {
            int index = 0;
            boolean signed = false;
            byte firstByte = value.byteAt(0);
            if (firstByte == 45) {
                signed = true;
                index = 1;
            } else if (firstByte == 43) {
                index = 1;
            }
            long second = 0L;
            long minute = 0L;
            long hour = 0L;
            long day = 0L;
            long week = 0L;
            boolean containsTimeUnit = false;
            long number = 0L;
            while (index < value.length()) {
                byte b = value.byteAt(index);
                if (StaticUtils.isDigit((char)b)) {
                    switch (value.byteAt(index)) {
                        case 48: {
                            number *= 10L;
                            break;
                        }
                        case 49: {
                            number = number * 10L + 1L;
                            break;
                        }
                        case 50: {
                            number = number * 10L + 2L;
                            break;
                        }
                        case 51: {
                            number = number * 10L + 3L;
                            break;
                        }
                        case 52: {
                            number = number * 10L + 4L;
                            break;
                        }
                        case 53: {
                            number = number * 10L + 5L;
                            break;
                        }
                        case 54: {
                            number = number * 10L + 6L;
                            break;
                        }
                        case 55: {
                            number = number * 10L + 7L;
                            break;
                        }
                        case 56: {
                            number = number * 10L + 8L;
                            break;
                        }
                        case 57: {
                            number = number * 10L + 9L;
                        }
                    }
                } else {
                    Message message = null;
                    if (containsTimeUnit) {
                        message = SchemaMessages.WARN_ATTR_CONFLICTING_ASSERTION_FORMAT.get(value.toString());
                    } else {
                        switch (value.byteAt(index)) {
                            case 115: {
                                second = number;
                                break;
                            }
                            case 109: {
                                minute = number;
                                break;
                            }
                            case 104: {
                                hour = number;
                                break;
                            }
                            case 100: {
                                day = number;
                                break;
                            }
                            case 119: {
                                week = number;
                                break;
                            }
                            default: {
                                message = SchemaMessages.WARN_ATTR_INVALID_RELATIVE_TIME_ASSERTION_FORMAT.get(value.toString(), Character.valueOf((char)value.byteAt(index)));
                            }
                        }
                    }
                    if (message != null) {
                        ErrorLogger.logError(message);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    containsTimeUnit = true;
                    number = 0L;
                }
                ++index;
            }
            if (!containsTimeUnit) {
                second = number;
            }
            long delta = (second + minute * 60L + hour * 3600L + day * 24L * 3600L + week * 7L * 24L * 3600L) * 1000L;
            long now = TimeThread.getTime();
            return signed ? ByteString.valueOf(now - delta) : ByteString.valueOf(now + delta);
        }

        @Override
        public int compareValues(ByteSequence value1, ByteSequence value2) {
            return value1.compareTo(value2);
        }

        @Override
        public int compare(byte[] arg0, byte[] arg1) {
            return StaticUtils.compare(arg0, arg1);
        }

        @Override
        public Collection<ExtensibleIndexer> getIndexers(IndexConfig config) {
            if (this.indexer == null) {
                this.indexer = new RelativeTimeExtensibleIndexer(this);
            }
            return Collections.singletonList(this.indexer);
        }
    }

    private abstract class TimeBasedMatchingRule
    extends AbstractMatchingRule
    implements ExtensibleMatchingRule {
        private TimeBasedMatchingRule() {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getSyntaxOID() {
            return "1.3.6.1.4.1.1466.115.121.1.24";
        }

        @Override
        public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
            try {
                long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value);
                return ByteString.valueOf(timestamp);
            }
            catch (DirectoryException de) {
                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                    case REJECT: {
                        throw de;
                    }
                    case WARN: {
                        ErrorLogger.logError(de.getMessageObject());
                        return value.toByteString();
                    }
                }
                return value.toByteString();
            }
        }
    }
}

