/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteSequence;

public class TelexNumberSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "TelexNumber"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "TelexNumber"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "TelexNumber"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "TelexNumber";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.52";
    }

    @Override
    public String getDescription() {
        return "Telex Number";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        int pos;
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength < 5) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_TOO_SHORT.get(valueString));
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get(valueString, String.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get(valueString, String.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_TRUNCATED.get(valueString));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = valueString.charAt(pos++))) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get(valueString, String.valueOf(c), pos - 1));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (!PrintableString.isPrintableCharacter(c)) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get(valueString, String.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        if (pos >= valueLength) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_TRUNCATED.get(valueString));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = valueString.charAt(pos++))) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get(valueString, String.valueOf(c), pos - 1));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (!PrintableString.isPrintableCharacter(c)) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get(valueString, String.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

