/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

class ObjectIdentifierFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "objectIdentifierFirstComponentMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.30";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value, buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        String value2String;
        int pos;
        String value1String = value1.toString();
        int value1Length = value1String.length();
        if (value1Length == 0 || value1String.charAt(0) != '(') {
            return false;
        }
        for (pos = 1; pos < value1Length && value1String.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= value1Length) {
            return false;
        }
        int startPos = pos++;
        while (pos < value1Length && value1String.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos >= value1Length) {
            return false;
        }
        String oid = value1String.substring(startPos, pos);
        if (oid.equals(value2String = value2.toString())) {
            return true;
        }
        AttributeType attrType1 = DirectoryServer.getAttributeType(oid);
        if (attrType1 != null) {
            AttributeType attrType2 = DirectoryServer.getAttributeType(value2String);
            if (attrType2 == null) {
                return false;
            }
            return attrType1.equals(attrType2);
        }
        ObjectClass oc1 = DirectoryServer.getObjectClass(oid);
        if (oc1 != null) {
            ObjectClass oc2 = DirectoryServer.getObjectClass(value2String);
            if (oc2 == null) {
                return false;
            }
            return oc1.equals(oc2);
        }
        AttributeSyntax syntax1 = DirectoryServer.getAttributeSyntax(oid, false);
        if (syntax1 != null) {
            AttributeSyntax syntax2 = DirectoryServer.getAttributeSyntax(value2String, false);
            if (syntax2 == null) {
                return false;
            }
            return syntax1.equals(syntax2);
        }
        MatchingRule mr1 = DirectoryServer.getMatchingRule(oid);
        if (mr1 != null) {
            MatchingRule mr2 = DirectoryServer.getMatchingRule(value2String);
            if (mr2 == null) {
                return false;
            }
            return mr1.equals(mr2);
        }
        NameForm nf1 = DirectoryServer.getNameForm(oid);
        if (nf1 != null) {
            NameForm nf2 = DirectoryServer.getNameForm(value2String);
            if (nf2 == null) {
                return false;
            }
            return nf1.equals(nf2);
        }
        return false;
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }
}

