/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class MatchingRuleSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "MatchingRuleDescription"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "MatchingRuleDescription"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "MatchingRuleDescription"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "MatchingRuleDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.30";
    }

    @Override
    public String getDescription() {
        return "Matching Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        char c;
        int pos;
        String valueStr = value.toString();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_EMPTY_VALUE.get());
            return false;
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c)));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1));
                        return false;
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1));
                    return false;
                }
                lastWasPeriod = false;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1));
                return false;
            }
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        ConcurrentHashMap<String, String> names = new ConcurrentHashMap<String, String>();
        AttributeSyntax syntax = null;
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block19: while (true) {
            StringBuilder tokenNameBuffer = new StringBuilder();
            try {
                pos = MatchingRuleSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                invalidReason.append(de.getMessageObject());
                return false;
            }
            String tokenName = tokenNameBuffer.toString();
            String lowerTokenName = StaticUtils.toLowerCase(tokenName);
            if (tokenName.equals(")")) {
                if (pos >= length) break;
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1));
                return false;
            }
            if (lowerTokenName.equals("name")) {
                StringBuilder lowerBuffer;
                StringBuilder userBuffer;
                if ((c = valueStr.charAt(pos++)) == '\'') {
                    userBuffer = new StringBuilder();
                    lowerBuffer = new StringBuilder();
                    try {
                        pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        invalidReason.append(de.getMessageObject());
                        return false;
                    }
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    continue;
                }
                if (c == '(') {
                    userBuffer = new StringBuilder();
                    lowerBuffer = new StringBuilder();
                    try {
                        pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        invalidReason.append(de.getMessageObject());
                        return false;
                    }
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block19;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        try {
                            pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            invalidReason.append(de.getMessageObject());
                            return false;
                        }
                        names.put(lowerBuffer.toString(), userBuffer.toString());
                    }
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1));
                return false;
            }
            if (lowerTokenName.equals("desc")) {
                StringBuilder descriptionBuffer = new StringBuilder();
                try {
                    pos = MatchingRuleSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    invalidReason.append(de.getMessageObject());
                    return false;
                }
            }
            if (lowerTokenName.equals("obsolete")) continue;
            if (lowerTokenName.equals("syntax")) {
                StringBuilder oidBuffer = new StringBuilder();
                try {
                    pos = MatchingRuleSyntax.readWOID(lowerStr, oidBuffer, pos);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    invalidReason.append(de.getMessageObject());
                    return false;
                }
                syntax = DirectoryServer.getAttributeSyntax(oidBuffer.toString(), false);
                if (syntax != null) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_UNKNOWN_SYNTAX.get(valueStr, oidBuffer.toString());
                ErrorLogger.logError(message);
                syntax = DirectoryServer.getDefaultAttributeSyntax();
                continue;
            }
            CopyOnWriteArrayList<String> valueList = new CopyOnWriteArrayList<String>();
            try {
                pos = MatchingRuleSyntax.readExtraParameterValues(valueStr, valueList, pos);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                invalidReason.append(de.getMessageObject());
                return false;
            }
            extraProperties.put(tokenName, valueList);
        }
        if (syntax == null) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_MR_NO_SYNTAX.get(valueStr));
            return false;
        }
        return true;
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_DOUBLE_PERIOD_IN_NUMERIC_OID.get(lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_NUMERIC_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR_IN_STRING_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_CHAR.get(lowerStr, String.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, CopyOnWriteArrayList<String> valueList, int startPos) throws DirectoryException {
        Message message;
        int length;
        block18: {
            StringBuilder valueBuffer;
            length = valueStr.length();
            char c = '\u0000';
            while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                ++startPos;
            }
            if (startPos >= length) {
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2);
            }
            if (c == '\'') {
                valueBuffer = new StringBuilder();
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
                    valueBuffer.append(c);
                    ++startPos;
                }
                ++startPos;
                valueList.add(valueBuffer.toString());
            } else {
                if (c == '(') {
                    ++startPos;
                    while (true) {
                        if (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                            ++startPos;
                            continue;
                        }
                        if (startPos >= length) {
                            message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        if (c == ')') {
                            ++startPos;
                            break block18;
                        }
                        if (c == '(') {
                            message = SchemaMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), startPos);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        if (c == '\'') {
                            valueBuffer = new StringBuilder();
                            ++startPos;
                            while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
                                valueBuffer.append(c);
                                ++startPos;
                            }
                            valueList.add(valueBuffer.toString());
                            ++startPos;
                        } else {
                            valueBuffer = new StringBuilder();
                            while (startPos < length && (c = valueStr.charAt(startPos)) != ' ') {
                                valueBuffer.append(c);
                                ++startPos;
                            }
                            valueList.add(valueBuffer.toString());
                        }
                        if (startPos >= length) break;
                    }
                    message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                valueBuffer = new StringBuilder();
                while (startPos < length && (c = valueStr.charAt(startPos)) != ' ') {
                    valueBuffer.append(c);
                    ++startPos;
                }
                valueList.add(valueBuffer.toString());
            }
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            message = SchemaMessages.ERR_ATTR_SYNTAX_MR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

