/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.GuideSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.util.StaticUtils;

public class EnhancedGuideSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.17", "EnhancedGuide"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.18", "EnhancedGuide"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.19", "EnhancedGuide"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "EnhancedGuide";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.21";
    }

    @Override
    public String getDescription() {
        return "Enhanced Guide";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.toString());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SHARP.get(valueStr));
            return false;
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_OC.get(valueStr));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(ocName, 0, ocLength, invalidReason)) {
            return false;
        }
        int lastSharpPos = valueStr.lastIndexOf(35);
        if (lastSharpPos == sharpPos) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_FINAL_SHARP.get(valueStr));
            return false;
        }
        String scopeStr = valueStr.substring(lastSharpPos + 1).trim();
        if (!(scopeStr.equals("baseobject") || scopeStr.equals("onelevel") || scopeStr.equals("wholesubtree") || scopeStr.equals("subordinatesubtree"))) {
            if (scopeStr.length() == 0) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SCOPE.get(valueStr));
            } else {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_INVALID_SCOPE.get(valueStr, scopeStr));
            }
            return false;
        }
        String criteria = valueStr.substring(sharpPos + 1, lastSharpPos).trim();
        int criteriaLength = criteria.length();
        if (criteriaLength == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_CRITERIA.get(valueStr));
            return false;
        }
        return GuideSyntax.criteriaIsValid(criteria, valueStr, invalidReason);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

