/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

class DoubleMetaphoneApproximateMatchingRule
extends ApproximateMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "ds-mr-double-metaphone-approx";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getDescription() {
        return "Double Metaphone Approximate Match";
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        String valueString = value.toString();
        int length = valueString.length();
        if (length == 0) {
            return ByteString.empty();
        }
        int last = length - 1;
        valueString = valueString.toUpperCase() + "     ";
        StringBuilder metaphone = new StringBuilder(4);
        int pos = 0;
        String substring = valueString.substring(0, 2);
        if (substring.equals("GN") || substring.equals("KN") || substring.equals("PN") || substring.equals("WR") || substring.equals("PS")) {
            ++pos;
        } else if (valueString.charAt(0) == 'X') {
            metaphone.append("S");
            ++pos;
        }
        block36: while (metaphone.length() < 4 && pos < length) {
            switch (valueString.charAt(pos)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (pos == 0) {
                        metaphone.append("A");
                    }
                    ++pos;
                    continue block36;
                }
                case 'B': {
                    metaphone.append("P");
                    if (valueString.charAt(++pos) != 'B') continue block36;
                    ++pos;
                    continue block36;
                }
                case 'C': {
                    char posMinusOne;
                    char posPlusTwo;
                    char posMinusTwo;
                    if (pos > 1 && !this.isVowel(posMinusTwo = valueString.charAt(pos - 2)) && this.hasSubstring(valueString, pos - 1, "ACH") && (posPlusTwo = valueString.charAt(pos + 2)) != 'I' && (posPlusTwo != 'E' || valueString.charAt(pos + 3) == 'R' && (posMinusTwo == 'B' || posMinusTwo == 'M'))) {
                        metaphone.append("K");
                        pos += 2;
                        continue block36;
                    }
                    if (pos == 0 && this.hasSubstring(valueString, pos + 1, "AESAR")) {
                        metaphone.append("S");
                        pos += 2;
                        continue block36;
                    }
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H') {
                        if (this.hasSubstring(valueString, pos + 2, "IA")) {
                            metaphone.append("K");
                            pos += 2;
                            continue block36;
                        }
                        if (this.hasSubstring(valueString, pos + 2, "AE")) {
                            metaphone.append("K");
                            pos += 2;
                            continue block36;
                        }
                        if (pos == 0 && !this.hasSubstring(valueString, 2, "ORE") && (this.hasSubstring(valueString, 2, "ARAC") || this.hasSubstring(valueString, 2, "ARIS") || this.hasSubstring(valueString, 2, "OR") || this.hasSubstring(valueString, 2, "YM") || this.hasSubstring(valueString, 2, "IA") || this.hasSubstring(valueString, 2, "EM"))) {
                            metaphone.append("K");
                            pos += 2;
                            continue block36;
                        }
                        if (this.isGermanic(valueString) || this.hasSubstring(valueString, pos - 2, "ORCHES") || this.hasSubstring(valueString, pos - 2, "ARCHIT") || this.hasSubstring(valueString, pos - 2, "ORCHID") || (posPlusTwo = valueString.charAt(pos + 2)) == 'T' || posPlusTwo == 'S' || (pos == 0 || (posMinusOne = valueString.charAt(pos - 1)) == 'A' || posMinusOne == 'O' || posMinusOne == 'U' || posMinusOne == 'E') && (posPlusTwo == 'L' || posPlusTwo == 'R' || posPlusTwo == 'N' || posPlusTwo == 'M' || posPlusTwo == 'B' || posPlusTwo == 'H' || posPlusTwo == 'F' || posPlusTwo == 'V' || posPlusTwo == 'W')) {
                            metaphone.append("K");
                            pos += 2;
                            continue block36;
                        }
                        if (pos > 0) {
                            if (this.hasSubstring(valueString, 0, "MC")) {
                                metaphone.append("K");
                            } else {
                                metaphone.append("X");
                            }
                        } else {
                            metaphone.append("X");
                        }
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'Z' && !this.hasSubstring(valueString, pos - 2, "WI")) {
                        metaphone.append("S");
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'I' && valueString.charAt(pos + 2) == 'A') {
                        metaphone.append("X");
                        pos += 3;
                        continue block36;
                    }
                    if (posPlusOne == 'C' && (pos != 1 || valueString.charAt(0) != 'M')) {
                        posPlusTwo = valueString.charAt(pos + 2);
                        if (!(posPlusTwo != 'I' && posPlusTwo != 'E' && posPlusTwo != 'H' || posPlusTwo == 'H' && valueString.charAt(pos + 3) == 'U')) {
                            if (pos == 1 && valueString.charAt(pos - 1) == 'A' || this.hasSubstring(valueString, pos - 1, "UCCEE") || this.hasSubstring(valueString, pos - 1, "UCCES")) {
                                metaphone.append("K");
                                pos += 2;
                                continue block36;
                            }
                            metaphone.append("X");
                            pos += 3;
                            continue block36;
                        }
                        metaphone.append("K");
                        pos += 2;
                        continue block36;
                    }
                    posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'K' || posPlusOne == 'G' || posPlusOne == 'Q') {
                        metaphone.append("K");
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'I' || posPlusOne == 'E' || posPlusOne == 'Y') {
                        metaphone.append("S");
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("K");
                    switch (valueString.charAt(pos + 1)) {
                        case ' ': {
                            switch (valueString.charAt(pos + 2)) {
                                case 'C': 
                                case 'G': 
                                case 'Q': {
                                    pos += 3;
                                    continue block36;
                                }
                            }
                            ++pos;
                            continue block36;
                        }
                        case 'K': 
                        case 'Q': {
                            pos += 2;
                            continue block36;
                        }
                        case 'C': {
                            switch (valueString.charAt(pos + 2)) {
                                case 'E': 
                                case 'I': {
                                    ++pos;
                                    continue block36;
                                }
                            }
                            pos += 2;
                            continue block36;
                        }
                    }
                    ++pos;
                    continue block36;
                }
                case 'D': {
                    char posPlusTwo;
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'G') {
                        posPlusTwo = valueString.charAt(pos + 2);
                        if (posPlusTwo == 'I' || posPlusTwo == 'E' || posPlusTwo == 'Y') {
                            metaphone.append("J");
                            pos += 3;
                            continue block36;
                        }
                        metaphone.append("TK");
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'T' || posPlusOne == 'D') {
                        metaphone.append("T");
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("T");
                    ++pos;
                    continue block36;
                }
                case 'F': {
                    metaphone.append("F");
                    if (valueString.charAt(++pos) != 'F') continue block36;
                    ++pos;
                    continue block36;
                }
                case 'G': {
                    char posMinusOne;
                    char posMinusTwo;
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H') {
                        char posMinusFour;
                        char posMinusThree;
                        if (pos > 0 && !this.isVowel(valueString.charAt(pos - 1))) {
                            metaphone.append("K");
                            pos += 2;
                            continue block36;
                        }
                        if (pos == 0) {
                            if (valueString.charAt(pos + 2) == 'I') {
                                metaphone.append("J");
                            } else {
                                metaphone.append("K");
                            }
                            pos += 2;
                            continue block36;
                        }
                        if (pos > 1 && ((posMinusTwo = valueString.charAt(pos - 2)) == 'B' || posMinusTwo == 'H' || posMinusTwo == 'D') || pos > 2 && ((posMinusThree = valueString.charAt(pos - 3)) == 'B' || posMinusThree == 'H' || posMinusThree == 'D') || pos > 3 && ((posMinusFour = valueString.charAt(pos - 4)) == 'B' || posMinusFour == 'H')) {
                            pos += 2;
                            continue block36;
                        }
                        if (pos > 2 && valueString.charAt(pos - 1) == 'U' && ((posMinusThree = valueString.charAt(pos - 3)) == 'C' || posMinusThree == 'G' || posMinusThree == 'L' || posMinusThree == 'R' || posMinusThree == 'T')) {
                            metaphone.append("F");
                        } else if (pos > 0 && valueString.charAt(pos - 1) != 'I') {
                            metaphone.append("K");
                        }
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'N') {
                        if (pos == 1 && this.isVowel(valueString.charAt(0)) && !this.isSlavoGermanic(valueString)) {
                            metaphone.append("KN");
                            pos += 2;
                            continue block36;
                        }
                        if (!this.hasSubstring(valueString, pos + 2, "EY") && !this.isSlavoGermanic(valueString)) {
                            metaphone.append("N");
                        } else {
                            metaphone.append("KN");
                        }
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'L' && valueString.charAt(pos + 2) == 'I') {
                        metaphone.append("KL");
                        pos += 2;
                        continue block36;
                    }
                    if (pos == 0 && (posPlusOne == 'Y' || (substring = valueString.substring(pos + 1, pos + 3)).equals("ES") || substring.equals("EP") || substring.equals("EB") || substring.equals("EL") || substring.equals("EY") || substring.equals("IB") || substring.equals("IL") || substring.equals("IN") || substring.equals("IE") || substring.equals("EI") || substring.equals("ER"))) {
                        metaphone.append("K");
                        pos += 2;
                        continue block36;
                    }
                    char posPlusTwo = valueString.charAt(pos + 2);
                    if (!((posPlusOne != 'E' || posPlusTwo != 'R') && posPlusOne != 'Y' || (posMinusOne = valueString.charAt(pos - 1)) == 'E' || posMinusOne == 'I' || this.hasSubstring(valueString, 0, "DANGER") || this.hasSubstring(valueString, 0, "RANGER") || this.hasSubstring(valueString, 0, "MANGER") || this.hasSubstring(valueString, pos - 1, "RGY") || this.hasSubstring(valueString, pos - 1, "OGY"))) {
                        metaphone.append("K");
                        pos += 2;
                        continue block36;
                    }
                    if (posPlusOne == 'E' || posPlusOne == 'I' || posPlusOne == 'Y' || this.hasSubstring(valueString, pos - 1, "AGGI") || this.hasSubstring(valueString, pos - 1, "OGGI")) {
                        if (this.isGermanic(valueString) || this.hasSubstring(valueString, pos + 1, "ET")) {
                            metaphone.append("K");
                        } else {
                            metaphone.append("J");
                        }
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("K");
                    ++pos;
                    if (posPlusOne != 'G') continue block36;
                    ++pos;
                    continue block36;
                }
                case 'H': {
                    if (this.isVowel(valueString.charAt(pos + 1)) && (pos == 0 || this.isVowel(valueString.charAt(pos - 1)))) {
                        metaphone.append("H");
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'J': {
                    if (this.hasSubstring(valueString, 0, "SAN ")) {
                        metaphone.append("H");
                        ++pos;
                        continue block36;
                    }
                    if (this.hasSubstring(valueString, pos, "JOSE")) {
                        if (pos == 0 && valueString.charAt(pos + 4) == ' ') {
                            metaphone.append("H");
                        } else {
                            metaphone.append("J");
                        }
                        ++pos;
                        continue block36;
                    }
                    metaphone.append("J");
                    if (valueString.charAt(pos + 1) == 'J') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'K': {
                    metaphone.append("K");
                    if (valueString.charAt(pos + 1) == 'K') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'L': {
                    metaphone.append("L");
                    if (valueString.charAt(pos + 1) == 'L') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'M': {
                    metaphone.append("M");
                    if (valueString.charAt(pos + 1) == 'M') {
                        ++pos;
                    } else if (this.hasSubstring(valueString, pos - 1, "UMB") && (pos + 1 == last || this.hasSubstring(valueString, pos + 2, "ER"))) {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'N': {
                    metaphone.append("N");
                    if (valueString.charAt(pos + 1) == 'N') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'P': {
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H') {
                        metaphone.append("F");
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("P");
                    if (posPlusOne == 'P' || posPlusOne == 'B') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'Q': {
                    metaphone.append("K");
                    if (valueString.charAt(pos + 1) == 'Q') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'R': {
                    if (pos == last && !this.isSlavoGermanic(valueString) && this.hasSubstring(valueString, pos - 2, "IE") && !this.hasSubstring(valueString, pos - 4, "ME") && !this.hasSubstring(valueString, pos - 4, "MA")) {
                        ++pos;
                        continue block36;
                    }
                    metaphone.append("R");
                    if (valueString.charAt(pos + 1) == 'R') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'S': {
                    char posPlusTwo;
                    if (this.hasSubstring(valueString, pos - 1, "ISL") || this.hasSubstring(valueString, pos - 1, "YSL")) {
                        ++pos;
                        continue block36;
                    }
                    if (this.hasSubstring(valueString, pos + 1, "UGAR")) {
                        metaphone.append("X");
                        ++pos;
                        continue block36;
                    }
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H') {
                        if (this.hasSubstring(valueString, pos + 1, "HEIM") || this.hasSubstring(valueString, pos + 1, "HOEK") || this.hasSubstring(valueString, pos + 1, "HOLM") || this.hasSubstring(valueString, pos + 1, "HOLZ")) {
                            metaphone.append("S");
                        } else {
                            metaphone.append("X");
                        }
                        pos += 2;
                        continue block36;
                    }
                    if (this.hasSubstring(valueString, pos + 1, "IO") || this.hasSubstring(valueString, pos + 1, "IA")) {
                        metaphone.append("S");
                        pos += 3;
                        continue block36;
                    }
                    if (posPlusOne == 'Z') {
                        metaphone.append("S");
                        pos += 2;
                        continue block36;
                    }
                    if (pos == 0 && (posPlusOne == 'M' || posPlusOne == 'N' || posPlusOne == 'L' || posPlusOne == 'W')) {
                        metaphone.append("S");
                        ++pos;
                        continue block36;
                    }
                    if (posPlusOne == 'C') {
                        posPlusTwo = valueString.charAt(pos + 2);
                        if (posPlusTwo == 'H') {
                            if (this.hasSubstring(valueString, pos + 3, "OO") || this.hasSubstring(valueString, pos + 3, "UY") || this.hasSubstring(valueString, pos + 3, "ED") || this.hasSubstring(valueString, pos + 3, "EM")) {
                                metaphone.append("SK");
                            } else {
                                metaphone.append("X");
                            }
                            pos += 3;
                            continue block36;
                        }
                        if (posPlusTwo == 'I' || posPlusTwo == 'E' || posPlusTwo == 'Y') {
                            metaphone.append("S");
                            pos += 3;
                            continue block36;
                        }
                        metaphone.append("SK");
                        pos += 3;
                        continue block36;
                    }
                    if (pos != last || !this.hasSubstring(valueString, pos - 2, "AI") && !this.hasSubstring(valueString, pos - 2, "OI")) {
                        metaphone.append("S");
                    }
                    if (posPlusOne == 'S' || posPlusOne == 'Z') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'T': {
                    if (this.hasSubstring(valueString, pos, "TION") || this.hasSubstring(valueString, pos, "TIA") || this.hasSubstring(valueString, pos, "TCH")) {
                        metaphone.append("X");
                        pos += 3;
                        continue block36;
                    }
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H' || posPlusOne == 'T' && valueString.charAt(pos + 2) == 'H') {
                        if (this.isGermanic(valueString) || this.hasSubstring(valueString, pos + 2, "OM") || this.hasSubstring(valueString, pos + 2, "AM")) {
                            metaphone.append("T");
                        } else {
                            metaphone.append("0");
                        }
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("T");
                    if (posPlusOne == 'T' || posPlusOne == 'D') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'V': {
                    metaphone.append("F");
                    if (valueString.charAt(pos + 1) == 'V') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'W': {
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'R') {
                        metaphone.append("R");
                        pos += 2;
                        continue block36;
                    }
                    if (pos == 0 && (this.isVowel(posPlusOne) || posPlusOne == 'H')) {
                        metaphone.append("A");
                        pos += 2;
                        continue block36;
                    }
                    if (this.hasSubstring(valueString, pos + 1, "WICZ") || this.hasSubstring(valueString, pos + 1, "WITZ")) {
                        metaphone.append("TS");
                        pos += 4;
                        continue block36;
                    }
                    ++pos;
                    continue block36;
                }
                case 'X': {
                    char posPlusOne;
                    if (pos != last || !this.hasSubstring(valueString, pos - 3, "IAU") && !this.hasSubstring(valueString, pos - 3, "EAU") && !this.hasSubstring(valueString, pos - 2, "AU") && !this.hasSubstring(valueString, pos - 2, "OU")) {
                        metaphone.append("KS");
                    }
                    if ((posPlusOne = valueString.charAt(pos + 1)) == 'C' || posPlusOne == 'X') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case 'Z': {
                    char posPlusOne = valueString.charAt(pos + 1);
                    if (posPlusOne == 'H') {
                        metaphone.append("J");
                        pos += 2;
                        continue block36;
                    }
                    metaphone.append("S");
                    if (posPlusOne == 'Z') {
                        ++pos;
                    }
                    ++pos;
                    continue block36;
                }
                case '\u00c7': {
                    metaphone.append("S");
                    ++pos;
                    continue block36;
                }
                case '\u00d1': {
                    metaphone.append("N");
                    ++pos;
                    continue block36;
                }
            }
            ++pos;
        }
        return ByteString.valueOf(metaphone.toString());
    }

    @Override
    public boolean approximatelyMatch(ByteSequence value1, ByteSequence value2) {
        return value1.equals(value2);
    }

    private boolean hasSubstring(String value, int start, String substring) {
        try {
            if (start < 0) {
                return false;
            }
            int end = start + substring.length();
            if (end > value.length()) {
                return false;
            }
            int i = 0;
            for (int pos = start; pos < end; ++pos) {
                if (value.charAt(pos) != substring.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    private boolean isVowel(char c) {
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    private boolean isSlavoGermanic(String s) {
        return s.contains("W") || s.contains("K") || s.contains("CZ") || s.contains("WITZ");
    }

    private boolean isGermanic(String s) {
        return s.startsWith("VAN ") || s.startsWith("VON ") || s.startsWith("SCH");
    }
}

