/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.schema.StringPrepProfile;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.ServerConstants;

class DirectoryStringFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "directoryStringFirstComponentMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.31";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        int pos;
        String value1String = value1.toString();
        int value1Length = value1String.length();
        if (value1Length == 0 || value1String.charAt(0) != '(') {
            return false;
        }
        for (pos = 1; pos < value1Length && value1String.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= value1Length) {
            return false;
        }
        int startPos = pos++;
        while (pos < value1Length && value1String.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos >= value1Length) {
            return false;
        }
        String compareStr = value1String.substring(startPos, pos);
        String value2String = value2.toString();
        return value2String.equals(compareStr);
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }
}

