/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CertificateAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;

public class CertificateSyntax
extends AttributeSyntax<CertificateAttributeSyntaxCfg>
implements ConfigurationChangeListener<CertificateAttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    private volatile CertificateAttributeSyntaxCfg config;

    @Override
    public void initializeSyntax(CertificateAttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.17", "Certificate"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.18", "Certificate"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.19", "Certificate"));
        }
        this.config = configuration;
        this.config.addCertificateChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CertificateAttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CertificateAttributeSyntaxCfg configuration) {
        this.config = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public String getSyntaxName() {
        return "Certificate";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.8";
    }

    @Override
    public String getDescription() {
        return "Certificate";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        if (!this.config.isStrictFormat()) {
            return true;
        }
        long x509Version = 0L;
        ASN1Reader reader = ASN1.getReader(value);
        try {
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.readStartSequence();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.readStartSequence();
            if (reader.hasNextElement() && reader.peekType() == -96) {
                reader.readStartExplicitTag();
                if (!reader.hasNextElement() || reader.peekType() != 2) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                    return false;
                }
                x509Version = reader.readInteger();
                if (x509Version < 0L || x509Version > 2L) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_INVALID_VERSION.get(x509Version));
                    return false;
                }
                if (x509Version == 0L) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_INVALID_DER.get());
                    return false;
                }
                reader.readEndExplicitTag();
            }
            if (!reader.hasNextElement() || reader.peekType() != 2) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (reader.hasNextElement() && reader.peekType() == -127) {
                if (x509Version < 1L) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                    return false;
                }
                reader.skipElement();
            }
            if (reader.hasNextElement() && reader.peekType() == -126) {
                if (x509Version < 1L) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                    return false;
                }
                reader.skipElement();
            }
            if (reader.hasNextElement() && reader.peekType() == -93) {
                if (x509Version < 2L) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                    return false;
                }
                reader.readStartExplicitTag();
                if (!reader.hasNextElement() || reader.peekType() != 48) {
                    invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                    return false;
                }
                reader.readEndExplicitTag();
            }
            if (reader.hasNextElement()) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.readEndSequence();
            if (!reader.hasNextElement() || reader.peekType() != 48) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (!reader.hasNextElement() || reader.peekType() != 3) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.skipElement();
            if (reader.hasNextElement()) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
            reader.readEndSequence();
            if (reader.hasNextElement()) {
                invalidReason.append(SchemaMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get());
                return false;
            }
        }
        catch (ASN1Exception e) {
            System.out.println(e.getMessageObject());
            invalidReason.append(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }
}

