/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;

public class BooleanSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    public static final AttributeValueDecoder<Boolean> DECODER = new AttributeValueDecoder<Boolean>(){

        @Override
        public Boolean decode(AttributeValue value) throws DirectoryException {
            ByteString normalizedValue = value.getNormalizedValue();
            if (normalizedValue.equals(ServerConstants.TRUE_VALUE)) {
                return true;
            }
            if (normalizedValue.equals(ServerConstants.FALSE_VALUE)) {
                return false;
            }
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get(normalizedValue.toString());
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
    };

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.13");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.13", "Boolean"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "Boolean";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.7";
    }

    @Override
    public String getDescription() {
        return "Boolean";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        boolean returnValue;
        String valueString = value.toString().toUpperCase();
        boolean bl = returnValue = valueString.equals("TRUE") || valueString.equals("YES") || valueString.equals("ON") || valueString.equals("1") || valueString.equals("FALSE") || valueString.equals("NO") || valueString.equals("OFF") || valueString.equals("0");
        if (!returnValue) {
            invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get(value.toString()));
        }
        return returnValue;
    }

    public static AttributeValue createBooleanValue(boolean b) {
        if (b) {
            return AttributeValues.create(ServerConstants.TRUE_VALUE, ServerConstants.TRUE_VALUE);
        }
        return AttributeValues.create(ServerConstants.FALSE_VALUE, ServerConstants.FALSE_VALUE);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

