/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachine;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatMsg;
import org.opends.server.replication.protocol.InitializeRcvAckMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.service.ListenerThread;
import org.opends.server.replication.service.ReplInputStream;
import org.opends.server.replication.service.ReplOutputStream;
import org.opends.server.replication.service.ReplicationBroker;
import org.opends.server.tasks.InitializeTargetTask;
import org.opends.server.tasks.InitializeTask;
import org.opends.server.types.Attribute;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public abstract class ReplicationDomain {
    protected ServerStatus status = ServerStatus.NOT_CONNECTED_STATUS;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final String serviceID;
    private final int serverID;
    protected ReplicationBroker broker = null;
    private final Map<ChangeNumber, UpdateMsg> waitingAckMsgs = new ConcurrentHashMap<ChangeNumber, UpdateMsg>();
    protected IEContext ieContext = null;
    private ListenerThread listenerThread;
    private static Map<String, ReplicationDomain> domains = new HashMap<String, ReplicationDomain>();
    private boolean assured = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte assuredSdLevel = 1;
    private long assuredTimeout = 2000L;
    private byte groupId = 1;
    private final List<String> refUrls = new ArrayList<String>();
    private AtomicInteger numProcessedUpdates = new AtomicInteger(0);
    private AtomicInteger numRcvdUpdates = new AtomicInteger(0);
    private AtomicInteger numSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrNotAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrTimeoutUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrWrongStatusUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrReplayErrorUpdates = new AtomicInteger(0);
    private final Map<Integer, Integer> assuredSrServerNotAcknowledgedUpdates = new HashMap<Integer, Integer>();
    private AtomicInteger assuredSrReceivedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrReceivedUpdatesAcked = new AtomicInteger(0);
    private AtomicInteger assuredSrReceivedUpdatesNotAcked = new AtomicInteger(0);
    private AtomicInteger assuredSdSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSdAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSdTimeoutUpdates = new AtomicInteger(0);
    private final Map<Integer, Integer> assuredSdServerTimeoutUpdates = new HashMap<Integer, Integer>();
    protected int initWindow = 100;
    private Date lastStatusChangeDate = new Date();
    private final ServerState state;
    private final ChangeNumberGenerator generator;
    private final Object eclIncludesLock = new Object();
    private final Map<Integer, Set<String>> eclIncludesByServer = new HashMap<Integer, Set<String>>();
    private Set<String> eclIncludesAllServers = Collections.emptySet();
    private final Map<Integer, Set<String>> eclIncludesForDeletesByServer = new HashMap<Integer, Set<String>>();
    private Set<String> eclIncludesForDeletesAllServers = Collections.emptySet();
    private final Object sessionLock = new Object();

    public ChangeNumberGenerator getGenerator() {
        return this.generator;
    }

    public ReplicationDomain(String serviceID, int serverID, int initWindow) {
        this.serviceID = serviceID;
        this.serverID = serverID;
        this.initWindow = initWindow;
        this.state = new ServerState();
        this.generator = new ChangeNumberGenerator(serverID, this.state);
        domains.put(serviceID, this);
    }

    public ReplicationDomain(String serviceID, int serverID) {
        this.serviceID = serviceID;
        this.serverID = serverID;
        this.state = new ServerState();
        this.generator = new ChangeNumberGenerator(serverID, this.state);
        domains.put(serviceID, this);
    }

    public ReplicationDomain(String serviceID, int serverID, ServerState serverState) {
        this.serviceID = serviceID;
        this.serverID = serverID;
        this.state = serverState;
        this.generator = new ChangeNumberGenerator(serverID, this.state);
        domains.put(serviceID, this);
    }

    public void sessionInitiated(ServerStatus initStatus, ServerState replicationServerState, long generationID, Session session) {
        if (!StatusMachine.isValidInitialStatus(initStatus)) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_INIT_STATUS.get(initStatus.toString(), this.serviceID, Integer.toString(this.serverID));
            ErrorLogger.logError(msg);
        } else {
            this.status = initStatus;
        }
        this.generator.adjust(this.state);
        this.generator.adjust(replicationServerState);
    }

    private void receiveChangeStatus(ChangeStatusMsg csMsg) {
        ServerStatus reqStatus;
        StatusMachineEvent event;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication domain " + this.serviceID + " received change status message:\n" + csMsg);
        }
        if ((event = StatusMachineEvent.statusToEvent(reqStatus = csMsg.getRequestedStatus())) == StatusMachineEvent.INVALID_EVENT) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_REQUESTED_STATUS.get(reqStatus.toString(), this.serviceID, Integer.toString(this.serverID));
            ErrorLogger.logError(msg);
            return;
        }
        this.setNewStatus(event);
    }

    void toNotConnectedStatus() {
        this.setNewStatus(StatusMachineEvent.TO_NOT_CONNECTED_STATUS_EVENT);
    }

    private void updateDomainForNewStatus() {
        switch (this.status) {
            case NOT_CONNECTED_STATUS: {
                break;
            }
            case NORMAL_STATUS: {
                break;
            }
            case DEGRADED_STATUS: {
                break;
            }
            case FULL_UPDATE_STATUS: {
                this.broker.signalStatusChange(this.status);
                break;
            }
            case BAD_GEN_ID_STATUS: {
                break;
            }
            default: {
                if (!DebugLogger.debugEnabled()) break;
                TRACER.debugInfo("updateDomainForNewStatus: unexpected status: " + (Object)((Object)this.status));
            }
        }
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public int getServerId() {
        return this.serverID;
    }

    public boolean isAssured() {
        return this.assured;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getAssuredSdLevel() {
        return this.assuredSdLevel;
    }

    public long getAssuredTimeout() {
        return this.assuredTimeout;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public List<String> getRefUrls() {
        return this.refUrls;
    }

    public List<DSInfo> getReplicasList() {
        return this.broker.getDsList();
    }

    public DSInfo isRemoteDSConnected(int serverId) {
        for (DSInfo remoteDS : this.getReplicasList()) {
            if (remoteDS.getDsId() != serverId) continue;
            return remoteDS;
        }
        return null;
    }

    public Map<Integer, ServerState> getReplicaStates() {
        return this.broker.getReplicaStates();
    }

    public List<RSInfo> getRsList() {
        return this.broker.getRsList();
    }

    public int getRsServerId() {
        return this.broker.getRsServerId();
    }

    private void incProcessedUpdates() {
        this.numProcessedUpdates.incrementAndGet();
    }

    int getNumProcessedUpdates() {
        if (this.numProcessedUpdates != null) {
            return this.numProcessedUpdates.get();
        }
        return 0;
    }

    int getNumRcvdUpdates() {
        if (this.numRcvdUpdates != null) {
            return this.numRcvdUpdates.get();
        }
        return 0;
    }

    int getNumSentUpdates() {
        if (this.numSentUpdates != null) {
            return this.numSentUpdates.get();
        }
        return 0;
    }

    public void setURLs(Set<String> referralsUrl) {
        this.refUrls.addAll(referralsUrl);
    }

    public void setAssuredTimeout(long assuredTimeout) {
        this.assuredTimeout = assuredTimeout;
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }

    public void setAssuredSdLevel(byte assuredSdLevel) {
        this.assuredSdLevel = assuredSdLevel;
    }

    public void setAssuredMode(AssuredMode dataMode) {
        this.assuredMode = dataMode;
    }

    public void setAssured(boolean assured) {
        this.assured = assured;
    }

    UpdateMsg receive() {
        UpdateMsg update = null;
        while (update == null) {
            RoutableMsg initReqMsg = null;
            try {
                ReplicationMsg msg = this.broker.receive(true, true, false);
                if (msg == null) {
                    return null;
                }
                if (DebugLogger.debugEnabled() && !(msg instanceof HeartbeatMsg)) {
                    TRACER.debugVerbose("Message received <" + msg + ">");
                }
                if (msg instanceof AckMsg) {
                    AckMsg ack = (AckMsg)msg;
                    this.receiveAck(ack);
                } else if (msg instanceof InitializeRequestMsg) {
                    initReqMsg = (InitializeRequestMsg)msg;
                } else if (msg instanceof InitializeTargetMsg) {
                    InitializeTargetMsg initTargetMsg = (InitializeTargetMsg)msg;
                    this.initialize(initTargetMsg, initTargetMsg.getSenderID());
                } else if (msg instanceof ErrorMsg) {
                    ErrorMsg errorMsg = (ErrorMsg)msg;
                    if (this.ieContext != null) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("[IE] processErrorMsg:" + this.serverID + " serviceID: " + this.serviceID + " Error Msg received: " + errorMsg);
                        }
                        if (errorMsg.getCreationTime() > this.ieContext.startTime) {
                            this.processErrorMsg(errorMsg);
                        } else {
                            ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
                        }
                    } else {
                        ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
                    }
                } else if (msg instanceof ChangeStatusMsg) {
                    ChangeStatusMsg csMsg = (ChangeStatusMsg)msg;
                    this.receiveChangeStatus(csMsg);
                } else if (msg instanceof UpdateMsg) {
                    update = (UpdateMsg)msg;
                    this.generator.adjust(update.getChangeNumber());
                } else if (msg instanceof InitializeRcvAckMsg && this.ieContext != null) {
                    InitializeRcvAckMsg ackMsg = (InitializeRcvAckMsg)msg;
                    this.ieContext.setAckVal(ackMsg.getSenderID(), ackMsg.getNumAck());
                }
            }
            catch (SocketTimeoutException e) {
                // empty catch block
            }
            if (initReqMsg == null) continue;
            ExportThread exportThread = new ExportThread(initReqMsg.getSenderID(), ((InitializeRequestMsg)initReqMsg).getInitWindow());
            exportThread.start();
        }
        this.numRcvdUpdates.incrementAndGet();
        byte rsGroupId = this.broker.getRsGroupId();
        if (update.isAssured() && update.getAssuredMode() == AssuredMode.SAFE_READ_MODE && rsGroupId == this.groupId) {
            this.assuredSrReceivedUpdates.incrementAndGet();
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssuredErrorsByServer(Map<Integer, Integer> errorsByServer, Integer sid) {
        Map<Integer, Integer> map = errorsByServer;
        synchronized (map) {
            Integer serverErrCount = errorsByServer.get(sid);
            if (serverErrCount == null) {
                errorsByServer.put(sid, 1);
            } else {
                int val = serverErrCount;
                errorsByServer.put(sid, ++val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAck(AckMsg ack) {
        block17: {
            AssuredMode updateAssuredMode;
            block18: {
                ChangeNumber changeNumber = ack.getChangeNumber();
                UpdateMsg update = this.waitingAckMsgs.remove(changeNumber);
                if (update == null) break block17;
                UpdateMsg updateMsg = update;
                synchronized (updateMsg) {
                    update.notify();
                }
                boolean hasTimeout = ack.hasTimeout();
                boolean hasReplayErrors = ack.hasReplayError();
                boolean hasWrongStatus = ack.hasWrongStatus();
                updateAssuredMode = update.getAssuredMode();
                if (!hasTimeout && !hasReplayErrors && !hasWrongStatus) break block18;
                Message errorMsg = ReplicationMessages.NOTE_DS_RECEIVED_ACK_ERROR.get(this.serviceID, Integer.toString(this.serverID), update.toString(), ack.errorsToString());
                ErrorLogger.logError(errorMsg);
                List<Integer> failedServers = ack.getFailedServers();
                switch (updateAssuredMode) {
                    case SAFE_READ_MODE: {
                        this.assuredSrNotAcknowledgedUpdates.incrementAndGet();
                        if (hasTimeout) {
                            this.assuredSrTimeoutUpdates.incrementAndGet();
                        }
                        if (hasReplayErrors) {
                            this.assuredSrReplayErrorUpdates.incrementAndGet();
                        }
                        if (hasWrongStatus) {
                            this.assuredSrWrongStatusUpdates.incrementAndGet();
                        }
                        if (failedServers == null) break;
                        for (Integer sid : failedServers) {
                            this.updateAssuredErrorsByServer(this.assuredSrServerNotAcknowledgedUpdates, sid);
                        }
                        break block17;
                    }
                    case SAFE_DATA_MODE: {
                        if (hasTimeout) {
                            this.assuredSdTimeoutUpdates.incrementAndGet();
                        }
                        if (failedServers == null) break;
                        for (Integer sid : failedServers) {
                            this.updateAssuredErrorsByServer(this.assuredSdServerTimeoutUpdates, sid);
                        }
                        break block17;
                    }
                }
                break block17;
            }
            switch (updateAssuredMode) {
                case SAFE_READ_MODE: {
                    this.assuredSrAcknowledgedUpdates.incrementAndGet();
                    break;
                }
                case SAFE_DATA_MODE: {
                    this.assuredSdAcknowledgedUpdates.incrementAndGet();
                    break;
                }
            }
        }
    }

    public int decodeTarget(String targetString) throws DirectoryException {
        if (targetString.equalsIgnoreCase("all")) {
            return -2;
        }
        try {
            int target = Integer.decode(targetString);
            if (target >= 0) {
                // empty if block
            }
            return target;
        }
        catch (Exception e) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_INVALID_EXPORT_TARGET.get();
            throw new DirectoryException(resultCode, message, e);
        }
    }

    public void initializeRemote(int target, Task initTask) throws DirectoryException {
        this.initializeRemote(target, this.serverID, initTask, this.initWindow);
    }

    protected void initializeRemote(int serverToInitialize, int serverRunningTheTask, Task initTask, int initWindow) throws DirectoryException {
        Message msg;
        String cause;
        Message msg2;
        DirectoryException exportRootException = null;
        this.acquireIEContext(false);
        if (serverToInitialize == -2) {
            msg2 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_START_ALL.get(this.countEntries(), this.serviceID, this.serverID);
            ErrorLogger.logError(msg2);
            for (DSInfo dsi : this.getReplicasList()) {
                this.ieContext.startList.add(dsi.getDsId());
            }
            for (DSInfo dsi : this.getReplicasList()) {
                if (dsi.getProtocolVersion() < 4) continue;
                this.ieContext.setAckVal(dsi.getDsId(), 0);
            }
        } else {
            msg2 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_START.get(this.countEntries(), this.serviceID, this.serverID, serverToInitialize);
            ErrorLogger.logError(msg2);
            this.ieContext.startList.add(serverToInitialize);
            for (DSInfo dsi : this.getReplicasList()) {
                if (dsi.getDsId() != serverToInitialize || dsi.getProtocolVersion() < 4) continue;
                this.ieContext.setAckVal(dsi.getDsId(), 0);
            }
        }
        int attempt = 0;
        boolean done = false;
        while (!done && ++attempt < 2) {
            try {
                this.ieContext.exportTarget = serverToInitialize;
                if (initTask != null) {
                    this.ieContext.initializeTask = initTask;
                }
                this.ieContext.initializeCounters(this.countEntries());
                this.ieContext.msgCnt = 0;
                this.ieContext.initNumLostConnections = this.broker.getNumLostConnections();
                this.ieContext.initWindow = initWindow;
                InitializeTargetMsg initTargetMsg = new InitializeTargetMsg(this.serviceID, this.serverID, serverToInitialize, serverRunningTheTask, this.ieContext.entryCount, initWindow);
                this.broker.publish(initTargetMsg);
                this.waitForRemoteStartOfInit();
                if (!this.ieContext.failureList.isEmpty()) {
                    throw new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_NO_SUCCESS_START_FROM_SERVERS.get(this.ieContext.failureList.toString()));
                }
                this.exportBackend(new BufferedOutputStream(new ReplOutputStream(this)));
                DoneMsg doneMsg = new DoneMsg(this.serverID, initTargetMsg.getDestination());
                this.broker.publish(doneMsg);
            }
            catch (DirectoryException exportException) {
                exportRootException = this.ieContext.exception != null ? this.ieContext.exception : exportException;
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] In " + this.getReplicationMonitorInstanceName() + " export ends with " + " connected=" + this.broker.isConnected() + " exportRootException=" + exportRootException);
            }
            if (exportRootException != null) {
                try {
                    if (!this.broker.isConnected()) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("[IE] Exporter wait for reconnection by the listener thread");
                        }
                        int att = 0;
                        while (!this.broker.shuttingDown() && !this.broker.isConnected() && ++att < 100) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (initTask != null && this.broker.isConnected() && serverToInitialize != -2) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ErrorLogger.logError(ReplicationMessages.NOTE_RESENDING_INIT_TARGET.get(exportRootException.getLocalizedMessage()));
                        continue;
                    }
                    ErrorMsg errorMsg = new ErrorMsg(serverToInitialize, exportRootException.getMessageObject());
                    this.broker.publish(errorMsg);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            done = true;
        }
        this.waitForRemoteEndOfInit();
        if (!this.ieContext.failureList.isEmpty() && exportRootException == null) {
            exportRootException = new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_NO_SUCCESS_END_FROM_SERVERS.get(Long.toString(this.getGenerationID()), this.ieContext.failureList.toString()));
        }
        this.releaseIEContext();
        String string = cause = exportRootException != null ? exportRootException.getLocalizedMessage() : "";
        if (serverToInitialize == -2) {
            msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_END_ALL.get(this.serviceID, this.serverID, cause);
            ErrorLogger.logError(msg);
        } else {
            msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_END.get(this.serviceID, this.serverID, serverToInitialize, cause);
            ErrorLogger.logError(msg);
        }
        if (exportRootException != null) {
            throw exportRootException;
        }
    }

    private String getReplicationMonitorInstanceName() {
        return this.broker.getReplicationMonitor().getMonitorInstanceName();
    }

    private void waitForRemoteStartOfInit() {
        boolean done;
        int waitResultAttempt = 0;
        HashSet<Integer> replicasWeAreWaitingFor = new HashSet<Integer>(0);
        replicasWeAreWaitingFor.addAll(this.ieContext.startList);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] wait for start replicasWeAreWaitingFor=" + replicasWeAreWaitingFor);
        }
        block2: do {
            done = true;
            for (DSInfo dsi : this.getReplicasList()) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("[IE] wait for start dsid " + dsi.getDsId() + " " + (Object)((Object)dsi.getStatus()) + " " + dsi.getGenerationId() + " " + this.getGenerationID());
                }
                if (!this.ieContext.startList.contains(dsi.getDsId())) continue;
                if (dsi.getStatus() != ServerStatus.FULL_UPDATE_STATUS) {
                    done = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ++waitResultAttempt;
                    continue block2;
                }
                replicasWeAreWaitingFor.remove(dsi.getDsId());
            }
        } while (!done && waitResultAttempt < 1200 && !this.broker.shuttingDown());
        this.ieContext.failureList.addAll(replicasWeAreWaitingFor);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] wait for start ends with " + this.ieContext.failureList);
        }
    }

    private void waitForRemoteEndOfInit() {
        boolean done;
        HashSet<Integer> replicasWeAreWaitingFor = new HashSet<Integer>(0);
        for (Integer sid : this.ieContext.startList) {
            replicasWeAreWaitingFor.add(sid);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] wait for end replicasWeAreWaitingFor=" + replicasWeAreWaitingFor);
        }
        for (DSInfo dsi : this.getReplicasList()) {
            replicasWeAreWaitingFor.add(dsi.getDsId());
        }
        do {
            done = true;
            int reconnectMaxDelayInSec = 10;
            int reconnectWait = 0;
            Iterator it = replicasWeAreWaitingFor.iterator();
            while (it.hasNext()) {
                int serverId = (Integer)it.next();
                if (this.ieContext.failureList.contains(serverId)) continue;
                DSInfo dsInfo = this.isRemoteDSConnected(serverId);
                if (dsInfo == null) {
                    if ((reconnectWait = (int)((short)(reconnectWait + 1))) >= reconnectMaxDelayInSec) continue;
                    done = false;
                    continue;
                }
                if (dsInfo.getStatus() == ServerStatus.FULL_UPDATE_STATUS) {
                    done = false;
                    break;
                }
                if (dsInfo.getGenerationId() != this.getGenerationID()) continue;
                it.remove();
            }
            if (done) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!done && !this.broker.shuttingDown());
        this.ieContext.failureList.addAll(replicasWeAreWaitingFor);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] wait for end ends with " + this.ieContext.failureList);
        }
    }

    public ServerState getServerState() {
        return this.state;
    }

    private synchronized void acquireIEContext(boolean importInProgress) throws DirectoryException {
        if (this.ieContext != null) {
            Message message = ReplicationMessages.ERR_SIMULTANEOUS_IMPORT_EXPORT_REJECTED.get();
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        this.ieContext = new IEContext(importInProgress);
    }

    private synchronized void releaseIEContext() {
        this.ieContext = null;
    }

    private void processErrorMsg(ErrorMsg errorMsg) {
        if (this.ieContext != null && this.ieContext.exportTarget != -2) {
            if (this.ieContext.getException() == null) {
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, errorMsg.getDetails()));
            }
            if (this.ieContext.initializeTask instanceof InitializeTask) {
                ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(this.ieContext.getException());
                this.releaseIEContext();
            }
        }
    }

    protected byte[] receiveEntryBytes() {
        while (true) {
            try {
                Object errMsg;
                while (true) {
                    ReplicationMsg msg = this.broker.receive(false, false, true);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("[IE] In " + this.getReplicationMonitorInstanceName() + ", receiveEntryBytes " + msg);
                    }
                    if (msg == null) {
                        if (this.broker.shuttingDown()) {
                            return null;
                        }
                        if (this.ieContext.getException() == null) {
                            this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_RS_DISCONNECTION_DURING_IMPORT.get(this.broker.getReplicationServer())));
                        }
                        return null;
                    }
                    if (msg instanceof EntryMsg) {
                        EntryMsg entryMsg = (EntryMsg)msg;
                        byte[] entryBytes = entryMsg.getEntryBytes();
                        this.ieContext.updateCounters(this.countEntryLimits(entryBytes));
                        if (this.ieContext.exporterProtocolVersion >= 4) {
                            if (++this.ieContext.msgCnt != entryMsg.getMsgId()) {
                                if (this.ieContext.getException() == null) {
                                    this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_BAD_MSG_ID_SEQ_DURING_IMPORT.get(String.valueOf(this.ieContext.msgCnt), String.valueOf(entryMsg.getMsgId()))));
                                }
                                return null;
                            }
                            if (this.ieContext.msgCnt % (this.ieContext.initWindow / 2) == 0) {
                                InitializeRcvAckMsg amsg = new InitializeRcvAckMsg(this.serverID, entryMsg.getSenderID(), this.ieContext.msgCnt);
                                this.broker.publish(amsg, false);
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugInfo("[IE] In " + this.getReplicationMonitorInstanceName() + ", publish InitializeRcvAckMsg" + amsg);
                                }
                            }
                        }
                        return entryBytes;
                    }
                    if (msg instanceof DoneMsg) {
                        return null;
                    }
                    if (msg instanceof ErrorMsg) {
                        if (this.ieContext.getException() != null || ((ErrorMsg)(errMsg = (ErrorMsg)msg)).getCreationTime() <= this.ieContext.startTime) continue;
                        this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ((ErrorMsg)errMsg).getDetails()));
                        return null;
                    }
                    if (msg instanceof TopologyMsg && this.isRemoteDSConnected(this.ieContext.importSource) == null) break;
                }
                errMsg = Message.raw(Category.SYNC, Severity.NOTICE, ReplicationMessages.ERR_INIT_EXPORTER_DISCONNECTION.get(this.serviceID, Integer.toString(this.serverID), Integer.toString(this.ieContext.importSource)), new Object[0]);
                if (this.ieContext.getException() == null) {
                    this.ieContext.setException(new DirectoryException(ResultCode.OTHER, (Message)errMsg));
                }
                return null;
            }
            catch (Exception e) {
                if (this.ieContext.getException() != null) continue;
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_IMPORT_FAILURE.get(e.getLocalizedMessage())));
                continue;
            }
            break;
        }
    }

    private int countEntryLimits(byte[] entryBytes) {
        return this.countEntryLimits(entryBytes, 0, entryBytes.length);
    }

    private int countEntryLimits(byte[] entryBytes, int pos, int length) {
        int entryCount = 0;
        for (int count = 0; count <= length - 2; ++count) {
            if (entryBytes[pos + count] != 10 || entryBytes[pos + count + 1] != 10) continue;
            ++entryCount;
            ++count;
        }
        return entryCount;
    }

    public void exportLDIFEntry(byte[] lDIFEntry, int pos, int length) throws IOException {
        boolean sent;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] Entering exportLDIFEntry entry=" + Arrays.toString(lDIFEntry));
        }
        EntryMsg entryMessage = new EntryMsg(this.serverID, this.ieContext.getExportTarget(), lDIFEntry, pos, length, ++this.ieContext.msgCnt);
        while (!this.broker.shuttingDown()) {
            if (this.ieContext.getException() != null) {
                throw new IOException(this.ieContext.getException().getMessage());
            }
            int slowestServerId = this.ieContext.getSlowestServer();
            if (this.isRemoteDSConnected(slowestServerId) == null) {
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_HEARTBEAT_LOST_DURING_EXPORT.get(Integer.toString(this.ieContext.getSlowestServer()))));
                throw new IOException("IOException with nested DirectoryException", this.ieContext.getException());
            }
            int ourLastExportedCnt = this.ieContext.msgCnt;
            int slowestCnt = (Integer)this.ieContext.ackVals.get(slowestServerId);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] Entering exportLDIFEntry waiting  our=" + ourLastExportedCnt + " slowest=" + slowestCnt);
            }
            if (ourLastExportedCnt - slowestCnt > this.ieContext.initWindow) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("[IE] Entering exportLDIFEntry waiting");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.broker.hasConnectionError() && this.broker.getNumLostConnections() == this.ieContext.initNumLostConnections) continue;
                DirectoryException de = new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_RS_DISCONNECTION_DURING_EXPORT.get(Integer.toString(this.broker.getRsServerId())));
                if (this.ieContext.getException() == null) {
                    this.ieContext.setException(de);
                }
                throw new IOException(de.getMessage());
            }
            if (!DebugLogger.debugEnabled()) break;
            TRACER.debugInfo("[IE] slowest got to us => stop waiting");
            break;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] Entering exportLDIFEntry pub entry=" + Arrays.toString(lDIFEntry));
        }
        if (!(sent = this.broker.publish(entryMessage, false)) || this.broker.hasConnectionError() || this.broker.getNumLostConnections() != this.ieContext.initNumLostConnections) {
            DirectoryException de = new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INIT_RS_DISCONNECTION_DURING_EXPORT.get(Integer.toString(this.broker.getRsServerId())));
            if (this.ieContext.getException() == null) {
                this.ieContext.setException(de);
            }
            throw new IOException(de.getMessage());
        }
        try {
            this.ieContext.updateCounters(this.countEntryLimits(lDIFEntry, pos, length));
        }
        catch (DirectoryException de) {
            if (this.ieContext.getException() == null) {
                this.ieContext.setException(de);
            }
            throw new IOException(de.getMessage());
        }
    }

    public void initializeFromRemote(int source) throws DirectoryException {
        this.initializeFromRemote(source, null);
    }

    public void initializeRemote(int target) throws DirectoryException {
        this.initializeRemote(target, null);
    }

    public void initializeFromRemote(int source, Task initTask) throws DirectoryException {
        Message errMsg = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("[IE] Entering initializeFromRemote for " + this);
        }
        if (!this.broker.isConnected()) {
            errMsg = ReplicationMessages.ERR_INITIALIZATION_FAILED_NOCONN.get(this.getServiceID());
        }
        try {
            this.acquireIEContext(true);
            this.ieContext.initializeTask = initTask;
            this.ieContext.attemptCnt = 0;
            this.ieContext.initReqMsgSent = new InitializeRequestMsg(this.serviceID, this.serverID, source, this.initWindow);
            this.broker.publish(this.ieContext.initReqMsgSent);
        }
        catch (DirectoryException de) {
            errMsg = de.getMessageObject();
        }
        catch (Exception e) {
            errMsg = Message.raw(Category.SYNC, Severity.NOTICE, e.getLocalizedMessage(), new Object[0]);
            ErrorLogger.logError(errMsg);
        }
        if (errMsg != null) {
            this.releaseIEContext();
            de = new DirectoryException(ResultCode.OTHER, errMsg);
            throw de;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void initialize(InitializeTargetMsg initTargetMsgReceived, int requesterServerId) {
        block34: {
            Message msg;
            InitializeTask initFromTask;
            block31: {
                initFromTask = null;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("[IE] Entering initialize - domain=" + this);
                }
                int source = initTargetMsgReceived.getSenderID();
                msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_START.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID);
                ErrorLogger.logError(msg);
                this.setNewStatus(StatusMachineEvent.TO_FULL_UPDATE_STATUS_EVENT);
                if (initTargetMsgReceived.getInitiatorID() != (long)this.serverID) {
                    this.acquireIEContext(true);
                }
                this.ieContext.importSource = source;
                this.ieContext.initializeCounters(initTargetMsgReceived.getEntryCount());
                this.ieContext.initWindow = initTargetMsgReceived.getInitWindow();
                this.ieContext.exporterProtocolVersion = this.getProtocolVersion(source);
                initFromTask = (InitializeTask)this.ieContext.initializeTask;
                this.importBackend(new ReplInputStream(this));
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("[IE] Domain=" + this + " ends import with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected());
                }
                this.broker.reStart(false);
                if (this.ieContext.getException() != null && this.broker.isConnected() && initFromTask != null && (this.ieContext.attemptCnt = (short)(this.ieContext.attemptCnt + 1)) < 2) {
                    try {
                        Thread.sleep(1000L);
                        ErrorLogger.logError(ReplicationMessages.NOTE_RESENDING_INIT_FROM_REMOTE_REQUEST.get(this.ieContext.getException().getLocalizedMessage()));
                        this.broker.publish(this.ieContext.initReqMsgSent);
                        this.ieContext.initializeCounters(0L);
                        this.ieContext.exception = null;
                        this.ieContext.msgCnt = 0;
                        return;
                    }
                    catch (Exception e) {
                        ErrorLogger.logError(ReplicationMessages.ERR_SENDING_NEW_ATTEMPT_INIT_REQUEST.get(e.getLocalizedMessage(), this.ieContext.getException().getLocalizedMessage()));
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("[IE] Domain=" + this + " ends initialization with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected() + " task=" + initFromTask + " attempt=" + this.ieContext.attemptCnt);
                }
                try {
                    if (this.broker.isConnected() && this.ieContext.getException() != null) {
                        ErrorMsg errorMsg = new ErrorMsg(requesterServerId, this.ieContext.getException().getMessageObject());
                        this.broker.publish(errorMsg);
                    }
                    if (initFromTask == null) break block31;
                    initFromTask.updateTaskCompletionState(this.ieContext.getException());
                }
                catch (Throwable throwable) {
                    Message msg2 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
                    ErrorLogger.logError(msg2);
                    this.releaseIEContext();
                    throw throwable;
                }
            }
            msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
            ErrorLogger.logError(msg);
            this.releaseIEContext();
            break block34;
            catch (DirectoryException e) {
                block33: {
                    block32: {
                        try {
                            if (this.ieContext.getException() != null) break block32;
                            this.ieContext.setException(e);
                        }
                        catch (Throwable throwable) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("[IE] Domain=" + this + " ends import with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected());
                            }
                            this.broker.reStart(false);
                            if (this.ieContext.getException() != null && this.broker.isConnected() && initFromTask != null && (this.ieContext.attemptCnt = (short)(this.ieContext.attemptCnt + 1)) < 2) {
                                try {
                                    Thread.sleep(1000L);
                                    ErrorLogger.logError(ReplicationMessages.NOTE_RESENDING_INIT_FROM_REMOTE_REQUEST.get(this.ieContext.getException().getLocalizedMessage()));
                                    this.broker.publish(this.ieContext.initReqMsgSent);
                                    this.ieContext.initializeCounters(0L);
                                    this.ieContext.exception = null;
                                    this.ieContext.msgCnt = 0;
                                    return;
                                }
                                catch (Exception e2) {
                                    ErrorLogger.logError(ReplicationMessages.ERR_SENDING_NEW_ATTEMPT_INIT_REQUEST.get(e2.getLocalizedMessage(), this.ieContext.getException().getLocalizedMessage()));
                                }
                            }
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("[IE] Domain=" + this + " ends initialization with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected() + " task=" + initFromTask + " attempt=" + this.ieContext.attemptCnt);
                            }
                            try {
                                if (this.broker.isConnected() && this.ieContext.getException() != null) {
                                    ErrorMsg errorMsg = new ErrorMsg(requesterServerId, this.ieContext.getException().getMessageObject());
                                    this.broker.publish(errorMsg);
                                }
                                if (initFromTask != null) {
                                    initFromTask.updateTaskCompletionState(this.ieContext.getException());
                                }
                            }
                            catch (Throwable throwable2) {
                                Message msg3 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
                                ErrorLogger.logError(msg3);
                                this.releaseIEContext();
                                throw throwable2;
                            }
                            Message msg4 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
                            ErrorLogger.logError(msg4);
                            this.releaseIEContext();
                            throw throwable;
                        }
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("[IE] Domain=" + this + " ends import with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected());
                    }
                    this.broker.reStart(false);
                    if (this.ieContext.getException() != null && this.broker.isConnected() && initFromTask != null && (this.ieContext.attemptCnt = (short)(this.ieContext.attemptCnt + 1)) < 2) {
                        try {
                            Thread.sleep(1000L);
                            ErrorLogger.logError(ReplicationMessages.NOTE_RESENDING_INIT_FROM_REMOTE_REQUEST.get(this.ieContext.getException().getLocalizedMessage()));
                            this.broker.publish(this.ieContext.initReqMsgSent);
                            this.ieContext.initializeCounters(0L);
                            this.ieContext.exception = null;
                            this.ieContext.msgCnt = 0;
                            return;
                        }
                        catch (Exception e3) {
                            ErrorLogger.logError(ReplicationMessages.ERR_SENDING_NEW_ATTEMPT_INIT_REQUEST.get(e3.getLocalizedMessage(), this.ieContext.getException().getLocalizedMessage()));
                        }
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("[IE] Domain=" + this + " ends initialization with exception=" + this.ieContext.getException() + " connected=" + this.broker.isConnected() + " task=" + initFromTask + " attempt=" + this.ieContext.attemptCnt);
                    }
                    try {
                        if (this.broker.isConnected() && this.ieContext.getException() != null) {
                            ErrorMsg errorMsg = new ErrorMsg(requesterServerId, this.ieContext.getException().getMessageObject());
                            this.broker.publish(errorMsg);
                        }
                        if (initFromTask == null) break block33;
                        initFromTask.updateTaskCompletionState(this.ieContext.getException());
                    }
                    catch (Throwable throwable) {
                        Message msg5 = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
                        ErrorLogger.logError(msg5);
                        this.releaseIEContext();
                        throw throwable;
                    }
                }
                msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(this.serviceID, initTargetMsgReceived.getSenderID(), this.serverID, this.ieContext.getException() != null ? this.ieContext.getException().getLocalizedMessage() : "");
                ErrorLogger.logError(msg);
                this.releaseIEContext();
            }
        }
    }

    short getProtocolVersion(int dsServerId) {
        short protocolVersion = -1;
        for (DSInfo dsi : this.getReplicasList()) {
            if (dsi.getDsId() != dsServerId) continue;
            protocolVersion = dsi.getProtocolVersion();
            break;
        }
        return protocolVersion;
    }

    protected void setNewStatus(StatusMachineEvent event) {
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_DS_CANNOT_CHANGE_STATUS.get(this.serviceID, Integer.toString(this.serverID), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return;
        }
        if (newStatus != this.status) {
            this.lastStatusChangeDate = new Date();
            if (newStatus == ServerStatus.NOT_CONNECTED_STATUS) {
                this.resetMonitoringCounters();
            }
            this.status = newStatus;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Replication domain " + this.serviceID + " new status is: " + (Object)((Object)this.status));
            }
            this.updateDomainForNewStatus();
        }
    }

    public boolean ieRunning() {
        return this.ieContext != null;
    }

    private void checkGenerationID(long generationID) throws DirectoryException {
        boolean allSet = true;
        for (int i = 0; i < 50; ++i) {
            allSet = true;
            for (RSInfo rsInfo : this.getRsList()) {
                if (rsInfo.getGenerationId() == -1L || rsInfo.getGenerationId() == generationID) continue;
                try {
                    Thread.sleep(i * 100);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                allSet = false;
                break;
            }
            if (allSet) break;
        }
        if (!allSet) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_RESET_GENERATION_ID_FAILED.get(this.serviceID);
            throw new DirectoryException(resultCode, message);
        }
    }

    public void resetReplicationLog() throws DirectoryException {
        this.resetGenerationId(-1L);
        this.checkGenerationID(-1L);
        this.disableService();
        this.enableService();
        int count = 0;
        while (!this.isConnected() && count < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.resetGenerationId(this.getGenerationID());
        this.checkGenerationID(this.getGenerationID());
    }

    public void resetGenerationId(Long generationIdNewValue) throws DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Server id " + this.serverID + " and domain " + this.serviceID + " resetGenerationId " + generationIdNewValue);
        }
        ResetGenerationIdMsg genIdMessage = generationIdNewValue == null ? new ResetGenerationIdMsg(this.getGenerationID()) : new ResetGenerationIdMsg(generationIdNewValue);
        if (!this.isConnected()) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_RESET_GENERATION_CONN_ERR_ID.get(this.serviceID, Integer.toString(this.serverID), Long.toString(genIdMessage.getGenerationId()));
            throw new DirectoryException(resultCode, message);
        }
        this.broker.publish(genIdMessage);
        if (generationIdNewValue == null) {
            this.checkGenerationID(this.getGenerationID());
        } else {
            this.checkGenerationID(generationIdNewValue);
        }
    }

    int getMaxRcvWindow() {
        if (this.broker != null) {
            return this.broker.getMaxRcvWindow();
        }
        return 0;
    }

    int getCurrentRcvWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentRcvWindow();
        }
        return 0;
    }

    int getMaxSendWindow() {
        if (this.broker != null) {
            return this.broker.getMaxSendWindow();
        }
        return 0;
    }

    int getCurrentSendWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentSendWindow();
        }
        return 0;
    }

    int getNumLostConnections() {
        if (this.broker != null) {
            return this.broker.getNumLostConnections();
        }
        return 0;
    }

    boolean isSessionEncrypted() {
        return this.broker != null && this.broker.isSessionEncrypted();
    }

    void processUpdateDoneSynchronous(UpdateMsg msg) {
        this.processUpdateDone(msg, null);
        this.state.update(msg.getChangeNumber());
    }

    public boolean isConnected() {
        return this.broker != null && this.broker.isConnected();
    }

    public boolean hasConnectionError() {
        return this.broker == null || this.broker.hasConnectionError();
    }

    public String getReplicationServer() {
        if (this.broker != null) {
            return this.broker.getReplicationServer();
        }
        return "Not connected";
    }

    public int getAssuredSrSentUpdates() {
        return this.assuredSrSentUpdates.get();
    }

    public int getAssuredSrAcknowledgedUpdates() {
        return this.assuredSrAcknowledgedUpdates.get();
    }

    public int getAssuredSrNotAcknowledgedUpdates() {
        return this.assuredSrNotAcknowledgedUpdates.get();
    }

    public int getAssuredSrTimeoutUpdates() {
        return this.assuredSrTimeoutUpdates.get();
    }

    public int getAssuredSrWrongStatusUpdates() {
        return this.assuredSrWrongStatusUpdates.get();
    }

    public int getAssuredSrReplayErrorUpdates() {
        return this.assuredSrReplayErrorUpdates.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Integer> getAssuredSrServerNotAcknowledgedUpdates() {
        Map<Integer, Integer> map = this.assuredSrServerNotAcknowledgedUpdates;
        synchronized (map) {
            return new HashMap<Integer, Integer>(this.assuredSrServerNotAcknowledgedUpdates);
        }
    }

    public int getAssuredSrReceivedUpdates() {
        return this.assuredSrReceivedUpdates.get();
    }

    public int getAssuredSrReceivedUpdatesAcked() {
        return this.assuredSrReceivedUpdatesAcked.get();
    }

    public int getAssuredSrReceivedUpdatesNotAcked() {
        return this.assuredSrReceivedUpdatesNotAcked.get();
    }

    public int getAssuredSdSentUpdates() {
        return this.assuredSdSentUpdates.get();
    }

    public int getAssuredSdAcknowledgedUpdates() {
        return this.assuredSdAcknowledgedUpdates.get();
    }

    public int getAssuredSdTimeoutUpdates() {
        return this.assuredSdTimeoutUpdates.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Integer> getAssuredSdServerTimeoutUpdates() {
        Map<Integer, Integer> map = this.assuredSdServerTimeoutUpdates;
        synchronized (map) {
            return new HashMap<Integer, Integer>(this.assuredSdServerTimeoutUpdates);
        }
    }

    public Date getLastStatusChangeDate() {
        return this.lastStatusChangeDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMonitoringCounters() {
        this.numProcessedUpdates = new AtomicInteger(0);
        this.numRcvdUpdates = new AtomicInteger(0);
        this.numSentUpdates = new AtomicInteger(0);
        this.assuredSrSentUpdates = new AtomicInteger(0);
        this.assuredSrAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSrNotAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSrTimeoutUpdates = new AtomicInteger(0);
        this.assuredSrWrongStatusUpdates = new AtomicInteger(0);
        this.assuredSrReplayErrorUpdates = new AtomicInteger(0);
        Map<Integer, Integer> map = this.assuredSrServerNotAcknowledgedUpdates;
        synchronized (map) {
            this.assuredSrServerNotAcknowledgedUpdates.clear();
        }
        this.assuredSrReceivedUpdates = new AtomicInteger(0);
        this.assuredSrReceivedUpdatesAcked = new AtomicInteger(0);
        this.assuredSrReceivedUpdatesNotAcked = new AtomicInteger(0);
        this.assuredSdSentUpdates = new AtomicInteger(0);
        this.assuredSdAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSdTimeoutUpdates = new AtomicInteger(0);
        map = this.assuredSdServerTimeoutUpdates;
        synchronized (map) {
            this.assuredSdServerTimeoutUpdates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPublishService(Collection<String> replicationServers, int window, long heartbeatInterval, long changetimeHeartbeatInterval) throws ConfigException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.broker == null) {
                this.broker = new ReplicationBroker(this, this.state, this.serviceID, this.serverID, window, this.getGenerationID(), heartbeatInterval, new ReplSessionSecurity(), this.getGroupId(), changetimeHeartbeatInterval);
                this.broker.start(replicationServers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListenService() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.listenerThread = new ListenerThread(this);
            this.listenerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableService() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.broker != null) {
                this.broker.stop();
            }
            if (this.listenerThread != null) {
                this.listenerThread.shutdown();
                this.listenerThread.waitForShutdown();
                this.listenerThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableService() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.broker.start();
            this.listenerThread = new ListenerThread(this);
            this.listenerThread.start();
        }
    }

    public void stopDomain() {
        this.disableService();
        domains.remove(this.serviceID);
    }

    public void changeConfig(Collection<String> replicationServers, int windowSize, long heartbeatInterval, byte groupId) {
        this.groupId = groupId;
        if (this.broker != null && this.broker.changeConfig(replicationServers, windowSize, heartbeatInterval, groupId)) {
            this.disableService();
            this.enableService();
        }
    }

    public void changeConfig(Set<String> includeAttributes, Set<String> includeAttributesForDeletes) {
        if (this.setEclIncludes(this.serverID, includeAttributes, includeAttributesForDeletes) && this.broker != null) {
            this.disableService();
            this.enableService();
        }
    }

    protected abstract void exportBackend(OutputStream var1) throws DirectoryException;

    protected abstract void importBackend(InputStream var1) throws DirectoryException;

    public abstract long countEntries() throws DirectoryException;

    public abstract boolean processUpdate(UpdateMsg var1, AtomicBoolean var2);

    public void processUpdateDone(UpdateMsg msg, String replayErrorMsg) {
        this.broker.updateWindowAfterReplay();
        byte rsGroupId = this.broker.getRsGroupId();
        if (msg.isAssured() && this.broker.getProtocolVersion() >= 2) {
            AssuredMode msgAssuredMode = msg.getAssuredMode();
            if (msgAssuredMode == AssuredMode.SAFE_READ_MODE) {
                if (rsGroupId == this.groupId) {
                    AckMsg ackMsg = new AckMsg(msg.getChangeNumber());
                    if (replayErrorMsg != null) {
                        ackMsg.setHasReplayError(true);
                        ArrayList<Integer> idList = new ArrayList<Integer>();
                        idList.add(this.serverID);
                        ackMsg.setFailedServers(idList);
                    }
                    this.broker.publish(ackMsg);
                    if (replayErrorMsg != null) {
                        this.assuredSrReceivedUpdatesNotAcked.incrementAndGet();
                    } else {
                        this.assuredSrReceivedUpdatesAcked.incrementAndGet();
                    }
                }
            } else if (this.assuredMode != AssuredMode.SAFE_DATA_MODE) {
                Message errorMsg = ReplicationMessages.ERR_DS_UNKNOWN_ASSURED_MODE.get(Integer.toString(this.serverID), msgAssuredMode.toString(), this.serviceID, msg.toString());
                ErrorLogger.logError(errorMsg);
            }
        }
        this.incProcessedUpdates();
    }

    protected void prepareWaitForAckIfAssuredEnabled(UpdateMsg msg) {
        byte rsGroupId = this.broker.getRsGroupId();
        if (this.assured && rsGroupId == this.groupId) {
            msg.setAssured(true);
            msg.setAssuredMode(this.assuredMode);
            if (this.assuredMode == AssuredMode.SAFE_DATA_MODE) {
                msg.setSafeDataLevel(this.assuredSdLevel);
            }
            this.waitingAckMsgs.put(msg.getChangeNumber(), msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAckIfAssuredEnabled(UpdateMsg msg) throws TimeoutException {
        byte rsGroupId = this.broker.getRsGroupId();
        if (this.assured && rsGroupId == this.groupId) {
            switch (this.assuredMode) {
                case SAFE_READ_MODE: {
                    this.assuredSrSentUpdates.incrementAndGet();
                    break;
                }
                case SAFE_DATA_MODE: {
                    this.assuredSdSentUpdates.incrementAndGet();
                    break;
                }
            }
        } else {
            return;
        }
        long startTime = System.currentTimeMillis();
        UpdateMsg updateMsg = msg;
        synchronized (updateMsg) {
            ChangeNumber cn = msg.getChangeNumber();
            while (this.waitingAckMsgs.containsKey(cn)) {
                try {
                    msg.wait(10L);
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) break;
                    TRACER.debugInfo("waitForAck method interrupted for replication serviceID: " + this.serviceID);
                    break;
                }
                if (System.currentTimeMillis() - startTime < this.assuredTimeout) continue;
                UpdateMsg update = this.waitingAckMsgs.remove(cn);
                if (update == null) break;
                switch (msg.getAssuredMode()) {
                    case SAFE_READ_MODE: {
                        this.assuredSrNotAcknowledgedUpdates.incrementAndGet();
                        this.assuredSrTimeoutUpdates.incrementAndGet();
                        this.updateAssuredErrorsByServer(this.assuredSrServerNotAcknowledgedUpdates, this.broker.getRsServerId());
                        break;
                    }
                    case SAFE_DATA_MODE: {
                        this.assuredSdTimeoutUpdates.incrementAndGet();
                        this.updateAssuredErrorsByServer(this.assuredSdServerTimeoutUpdates, this.broker.getRsServerId());
                        break;
                    }
                }
                throw new TimeoutException("No ack received for message cn: " + cn + " and replication servceID: " + this.serviceID + " after " + this.assuredTimeout + " ms.");
            }
        }
    }

    public void publish(UpdateMsg msg) {
        this.broker.publish(msg);
        this.state.update(msg.getChangeNumber());
        this.numSentUpdates.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] msg) {
        UpdateMsg update;
        ReplicationDomain replicationDomain = this;
        synchronized (replicationDomain) {
            update = new UpdateMsg(this.generator.newChangeNumber(), msg);
            this.prepareWaitForAckIfAssuredEnabled(update);
            this.publish(update);
        }
        try {
            this.waitForAckIfAssuredEnabled(update);
        }
        catch (TimeoutException ex) {
            Message errorMsg = ReplicationMessages.NOTE_DS_ACK_TIMEOUT.get(this.serviceID, Long.toString(this.assuredTimeout), update.toString());
            ErrorLogger.logError(errorMsg);
        }
    }

    public abstract long getGenerationID();

    public Collection<Attribute> getAdditionalMonitoring() {
        return new ArrayList<Attribute>();
    }

    public boolean importInProgress() {
        return this.ieContext != null && this.ieContext.importInProgress;
    }

    public boolean exportInProgress() {
        return this.ieContext != null && !this.ieContext.importInProgress;
    }

    long getLeftEntryCount() {
        if (this.ieContext != null) {
            return this.ieContext.entryLeftCount;
        }
        return 0L;
    }

    String getLocalUrl() {
        ReplicationBroker tmp = this.broker;
        return tmp != null ? tmp.getLocalUrl() : "";
    }

    long getTotalEntryCount() {
        if (this.ieContext != null) {
            return this.ieContext.entryCount;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEclIncludes(int serverId, Set<String> includeAttributes, Set<String> includeAttributesForDeletes) {
        boolean configurationChanged = false;
        Object object = this.eclIncludesLock;
        synchronized (object) {
            HashSet<String> s1 = new HashSet<String>(includeAttributes);
            HashSet<String> s2 = new HashSet<String>(s1);
            s2.addAll(includeAttributesForDeletes);
            Set<String> s = this.eclIncludesByServer.get(serverId);
            if (!s1.equals(s)) {
                configurationChanged = true;
                this.eclIncludesByServer.put(serverId, Collections.unmodifiableSet(s1));
            }
            if (!s2.equals(s = this.eclIncludesForDeletesByServer.get(serverId))) {
                configurationChanged = true;
                this.eclIncludesForDeletesByServer.put(serverId, Collections.unmodifiableSet(s2));
            }
            s = new HashSet<String>();
            for (Set<String> attributes : this.eclIncludesByServer.values()) {
                s.addAll(attributes);
            }
            this.eclIncludesAllServers = Collections.unmodifiableSet(s);
            s = new HashSet<String>();
            for (Set<String> attributes : this.eclIncludesForDeletesByServer.values()) {
                s.addAll(attributes);
            }
            this.eclIncludesForDeletesAllServers = Collections.unmodifiableSet(s);
        }
        return configurationChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEclIncludes() {
        Object object = this.eclIncludesLock;
        synchronized (object) {
            return this.eclIncludesAllServers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEclIncludesForDeletes() {
        Object object = this.eclIncludesLock;
        synchronized (object) {
            return this.eclIncludesForDeletesAllServers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEclIncludes(int serverId) {
        Object object = this.eclIncludesLock;
        synchronized (object) {
            return this.eclIncludesByServer.get(serverId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEclIncludesForDeletes(int serverId) {
        Object object = this.eclIncludesLock;
        synchronized (object) {
            return this.eclIncludesForDeletesByServer.get(serverId);
        }
    }

    public ChangeNumber getLastLocalChange() {
        return this.state.getMaxChangeNumber(this.serverID);
    }

    protected class IEContext {
        Task initializeTask;
        int exportTarget = -1;
        int importSource = -1;
        long entryCount = 0L;
        long entryLeftCount = 0L;
        DirectoryException exception = null;
        boolean importInProgress;
        int msgCnt = 0;
        int initNumLostConnections = 0;
        InitializeRequestMsg initReqMsgSent = null;
        long startTime;
        Set<Integer> startList = new HashSet<Integer>(0);
        Set<Integer> failureList = new HashSet<Integer>(0);
        private final HashMap<Integer, Integer> ackVals = new HashMap();
        private int slowestServerId = -1;
        short exporterProtocolVersion = (short)-1;
        int initWindow;
        short attemptCnt;

        public IEContext(boolean importInProgress) {
            this.importInProgress = importInProgress;
            this.startTime = System.currentTimeMillis();
            this.attemptCnt = 0;
        }

        private void initializeCounters(long total) throws DirectoryException {
            this.entryCount = total;
            this.entryLeftCount = total;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTask)this.initializeTask).setLeft(this.entryCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryCount);
                }
            }
        }

        public void updateCounters(int entriesDone) throws DirectoryException {
            this.entryLeftCount -= (long)entriesDone;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setLeft(this.entryLeftCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryLeftCount);
                }
            }
        }

        public String toString() {
            return "[ Entry count=" + this.entryCount + ", Entry left count=" + this.entryLeftCount + "]";
        }

        public int getExportTarget() {
            return this.exportTarget;
        }

        public int getImportSource() {
            return this.importSource;
        }

        public DirectoryException getException() {
            return this.exception;
        }

        public void setException(DirectoryException exception) {
            this.exception = exception;
        }

        public void setAckVal(int serverId, int numAck) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] setAckVal[" + serverId + "]=" + numAck);
            }
            this.ackVals.put(serverId, numAck);
            this.slowestServerId = serverId;
            for (Integer sid : ReplicationDomain.this.ieContext.ackVals.keySet()) {
                if (this.ackVals.get(sid) >= this.ackVals.get(this.slowestServerId)) continue;
                this.slowestServerId = sid;
            }
        }

        public int getSlowestServer() {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] getSlowestServer" + this.slowestServerId + " " + this.ackVals.get(this.slowestServerId));
            }
            return this.slowestServerId;
        }
    }

    private class ExportThread
    extends DirectoryThread {
        private final int serverToInitialize;
        private final int initWindow;

        public ExportThread(int serverToInitialize, int initWindow) {
            super("Export thread from serverId=" + ReplicationDomain.this.serverID + " to serverId=" + serverToInitialize);
            this.serverToInitialize = serverToInitialize;
            this.initWindow = initWindow;
        }

        @Override
        public void run() {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] starting " + this.getName());
            }
            try {
                ReplicationDomain.this.initializeRemote(this.serverToInitialize, this.serverToInitialize, null, this.initWindow);
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("[IE] ending " + this.getName());
            }
        }
    }
}

