/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.Session;
import org.opends.server.types.DebugLogLevel;

final class HeartbeatMonitor
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Session session;
    private final long heartbeatInterval;
    private final int serverID;
    private final int replicationServerID;
    private final String baseDN;
    private volatile boolean shutdown = false;
    private final Object shutdownLock = new Object();

    HeartbeatMonitor(int serverID, int replicationServerID, String baseDN, Session session, long heartbeatInterval) {
        super("Replica DS(" + serverID + ") heartbeat monitor for domain \"" + baseDN + "\" from RS(" + replicationServerID + ") at " + session.getReadableRemoteAddress());
        this.serverID = serverID;
        this.replicationServerID = replicationServerID;
        this.baseDN = baseDN;
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " is starting, expected interval is " + this.heartbeatInterval);
        }
        try {
            boolean gotOneFailure = false;
            while (!this.shutdown) {
                long lastReceiveTime;
                long now = System.currentTimeMillis();
                if (now > (lastReceiveTime = this.session.getLastReceiveTime()) + this.heartbeatInterval) {
                    if (gotOneFailure) {
                        ErrorLogger.logError(ReplicationMessages.WARN_HEARTBEAT_FAILURE.get(this.serverID, this.replicationServerID, this.session.getReadableRemoteAddress(), this.baseDN));
                        this.shutdown = true;
                        return;
                    }
                    gotOneFailure = true;
                } else {
                    gotOneFailure = false;
                }
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.shutdown) {
                        try {
                            this.shutdownLock.wait(this.heartbeatInterval);
                        }
                        catch (InterruptedException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.shutdown = true;
                        }
                    }
                }
            }
            return;
        }
        finally {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat monitor is exiting");
            }
            this.session.close();
        }
    }
}

