/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.TimeThread;

public class CTHeartbeatPublisherThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Session session;
    private final long heartbeatInterval;
    private final int serverId;
    private volatile boolean shutdown = false;
    private final Object shutdownLock = new Object();

    public CTHeartbeatPublisherThread(String threadName, Session session, long heartbeatInterval, int serverId2) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
        this.serverId = serverId2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " is starting, interval is %d", this.heartbeatInterval);
            }
            while (!this.shutdown) {
                long sleepTime;
                long now = System.currentTimeMillis();
                ChangeTimeHeartbeatMsg ctHeartbeatMsg = new ChangeTimeHeartbeatMsg(new ChangeNumber(TimeThread.getTime(), 0, this.serverId));
                if (now > this.session.getLastPublishTime() + this.heartbeatInterval) {
                    this.session.publish(ctHeartbeatMsg);
                }
                if ((sleepTime = this.session.getLastPublishTime() + this.heartbeatInterval - now) <= 0L) {
                    sleepTime = this.heartbeatInterval;
                }
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.shutdown) {
                        try {
                            this.shutdownLock.wait(sleepTime);
                        }
                        catch (InterruptedException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.shutdown = true;
                        }
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            if (!DebugLogger.debugEnabled()) return;
            TRACER.debugInfo(this.getName() + "could not send a heartbeat." + e.getMessage() + e.toString());
            return;
        }
        finally {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " is exiting.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
        }
    }
}

