/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.DebugLogLevel;

public class StatusAnalyzer
extends DirectoryThread {
    private volatile boolean shutdown = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ReplicationServerDomain replicationServerDomain;
    private volatile int degradedStatusThreshold = -1;
    private static final int STATUS_ANALYZER_SLEEP_TIME = 5000;
    private volatile boolean done = false;
    private final Object shutdownLock = new Object();

    public StatusAnalyzer(ReplicationServerDomain replicationServerDomain, int degradedStatusThreshold) {
        super("Replication server RS(" + replicationServerDomain.getReplicationServer().getServerId() + ") delay monitor for domain \"" + replicationServerDomain.getBaseDn() + "\"");
        this.replicationServerDomain = replicationServerDomain;
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Directory server status analyzer starting for dn " + this.replicationServerDomain.getBaseDn());
        }
        boolean interrupted = false;
        block5: while (!this.shutdown && !interrupted) {
            Object object = this.shutdownLock;
            synchronized (object) {
                if (!this.shutdown) {
                    try {
                        this.shutdownLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        this.shutdown = true;
                        break;
                    }
                }
            }
            for (DataServerHandler serverHandler : this.replicationServerDomain.getConnectedDSs().values()) {
                int nChanges = serverHandler.getRcvMsgQueueSize();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " DS " + Integer.toString(serverHandler.getServerId()) + " has " + nChanges + " message(s) in writer queue. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                }
                if (this.degradedStatusThreshold <= 0) continue;
                if (nChanges >= this.degradedStatusThreshold) {
                    if (serverHandler.getStatus() != ServerStatus.NORMAL_STATUS || !(interrupted = this.replicationServerDomain.changeStatusFromStatusAnalyzer(serverHandler, StatusMachineEvent.TO_DEGRADED_STATUS_EVENT))) continue;
                    TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " has been interrupted and will die. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                    continue block5;
                }
                if (serverHandler.getStatus() != ServerStatus.DEGRADED_STATUS || !(interrupted = this.replicationServerDomain.changeStatusFromStatusAnalyzer(serverHandler, StatusMachineEvent.TO_NORMAL_STATUS_EVENT))) continue;
                TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " has been interrupted and will die. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                continue block5;
            }
        }
        this.done = true;
        TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Shutting down status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
            }
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setDegradedStatusThreshold(int degradedStatusThreshold) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Directory server status analyzer for dn " + this.replicationServerDomain.getBaseDn() + " changing threshold value to " + degradedStatusThreshold);
        }
        this.degradedStatusThreshold = degradedStatusThreshold;
    }
}

