/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.InitializeRcvAckMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ExpectedAcksInfo;
import org.opends.server.replication.server.MessageHandler;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.MonitoringPublisher;
import org.opends.server.replication.server.NotAssuredUpdateMsg;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerHandler;
import org.opends.server.replication.server.SafeDataExpectedAcksInfo;
import org.opends.server.replication.server.SafeReadExpectedAcksInfo;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.replication.server.StatusAnalyzer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class ReplicationServerDomain
extends MonitorProvider<MonitorProviderCfg> {
    private final String baseDn;
    private StatusAnalyzer statusAnalyzer = null;
    private MonitoringPublisher monitoringPublisher = null;
    private final Map<Integer, DataServerHandler> directoryServers = new ConcurrentHashMap<Integer, DataServerHandler>();
    private final Map<Integer, ReplicationServerHandler> replicationServers = new ConcurrentHashMap<Integer, ReplicationServerHandler>();
    private final ConcurrentLinkedQueue<MessageHandler> otherHandlers = new ConcurrentLinkedQueue();
    private final Map<Integer, DbHandler> sourceDbHandlers = new ConcurrentHashMap<Integer, DbHandler>();
    private ReplicationServer replicationServer;
    private volatile long generationId = -1L;
    private boolean generationIdSavedStatus = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile MonitorData monitorData = new MonitorData();
    private final Object pendingMonitorLock = new Object();
    private long monitorDataLastBuildDate = 0L;
    private final Set<Integer> monitorDataLateServers = new HashSet<Integer>();
    private final Object pendingMonitorDataLock = new Object();
    private MonitorData pendingMonitorData;
    private final Set<Integer> pendingMonitorDataServerIDs = new HashSet<Integer>();
    private CountDownLatch pendingMonitorDataLatch = null;
    private final long monitorDataLifeTime = 500L;
    private final ConcurrentHashMap<ChangeNumber, ExpectedAcksInfo> waitingAcks = new ConcurrentHashMap();
    private Timer assuredTimeoutTimer = null;
    private int assuredTimeoutTimerPurgeCounter = 0;
    private ServerState ctHeartbeatState = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final Object generationIDLock = new Object();

    public ReplicationServerDomain(String baseDn, ReplicationServer replicationServer) {
        this.baseDn = baseDn;
        this.replicationServer = replicationServer;
        this.assuredTimeoutTimer = new Timer("Replication server RS(" + replicationServer.getServerId() + ") assured timer for domain \"" + baseDn + "\"", true);
        DirectoryServer.registerMonitorProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        DbHandler dbHandler;
        Object errorMsg;
        ChangeNumber cn = update.getChangeNumber();
        int id = cn.getServerId();
        sourceHandler.updateServerState(update);
        sourceHandler.incrementInCount();
        if (this.generationId < 0L) {
            this.generationId = sourceHandler.getGenerationId();
        }
        boolean assuredMessage = update.isAssured();
        PreparedAssuredInfo preparedAssuredInfo = null;
        if (assuredMessage) {
            if (sourceHandler.getProtocolVersion() >= 2) {
                AssuredMode assuredMode = update.getAssuredMode();
                if (assuredMode == AssuredMode.SAFE_DATA_MODE) {
                    sourceHandler.incrementAssuredSdReceivedUpdates();
                    preparedAssuredInfo = this.processSafeDataUpdateMsg(update, sourceHandler);
                } else if (assuredMode == AssuredMode.SAFE_READ_MODE) {
                    sourceHandler.incrementAssuredSrReceivedUpdates();
                    preparedAssuredInfo = this.processSafeReadUpdateMsg(update, sourceHandler);
                } else {
                    errorMsg = ReplicationMessages.ERR_RS_UNKNOWN_ASSURED_MODE.get(Integer.toString(this.replicationServer.getServerId()), assuredMode.toString(), this.baseDn, update.toString());
                    ErrorLogger.logError((Message)errorMsg);
                    assuredMessage = false;
                }
            } else {
                assuredMessage = false;
            }
        }
        errorMsg = this.sourceDbHandlers;
        synchronized (errorMsg) {
            dbHandler = this.sourceDbHandlers.get(id);
            if (dbHandler == null) {
                try {
                    dbHandler = this.replicationServer.newDbHandler(id, this.baseDn);
                    this.generationIdSavedStatus = true;
                }
                catch (DatabaseException e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    this.replicationServer.shutdown();
                    return;
                }
                this.sourceDbHandlers.put(id, dbHandler);
            }
        }
        dbHandler.add(update);
        List<Integer> expectedServers = null;
        if (assuredMessage && (expectedServers = preparedAssuredInfo.expectedServers) != null) {
            this.waitingAcks.put(cn, preparedAssuredInfo.expectedAcksInfo);
            AssuredTimeoutTask assuredTimeoutTask = new AssuredTimeoutTask(cn);
            this.assuredTimeoutTimer.schedule((TimerTask)assuredTimeoutTask, this.replicationServer.getAssuredTimeout());
            ++this.assuredTimeoutTimerPurgeCounter;
            if (this.assuredTimeoutTimerPurgeCounter % 100 == 0) {
                this.assuredTimeoutTimer.purge();
            }
        }
        NotAssuredUpdateMsg notAssuredUpdate = null;
        if (sourceHandler.isDataServer()) {
            for (ReplicationServerHandler replicationServerHandler : this.replicationServers.values()) {
                if (this.generationId > 0L && this.generationId != replicationServerHandler.getGenerationId()) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In Replication Server " + this.replicationServer.getReplicationPort() + " " + this.baseDn + " " + this.replicationServer.getServerId() + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to replication server " + Integer.toString(replicationServerHandler.getServerId()) + " with generation id " + Long.toString(replicationServerHandler.getGenerationId()) + " different from local " + "generation id " + Long.toString(this.generationId));
                    continue;
                }
                if (assuredMessage) {
                    if (expectedServers != null && expectedServers.contains(replicationServerHandler.getServerId())) {
                        replicationServerHandler.add(update, sourceHandler);
                        continue;
                    }
                    if (notAssuredUpdate == null) {
                        notAssuredUpdate = new NotAssuredUpdateMsg(update);
                    }
                    replicationServerHandler.add(notAssuredUpdate, sourceHandler);
                    continue;
                }
                replicationServerHandler.add(update, sourceHandler);
            }
        }
        for (DataServerHandler dataServerHandler : this.directoryServers.values()) {
            if (dataServerHandler == sourceHandler) continue;
            ServerStatus dsStatus = dataServerHandler.getStatus();
            if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                if (!DebugLogger.debugEnabled()) continue;
                if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                    TRACER.debugInfo("In " + this + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to directory server " + Integer.toString(dataServerHandler.getServerId()) + " with generation id " + Long.toString(dataServerHandler.getGenerationId()) + " different from local " + "generation id " + Long.toString(this.generationId));
                }
                if (dsStatus != ServerStatus.FULL_UPDATE_STATUS) continue;
                TRACER.debugInfo("In RS " + this.replicationServer.getServerId() + " for dn " + this.baseDn + ", update " + update.getChangeNumber().toString() + " will not be sent to directory server " + Integer.toString(dataServerHandler.getServerId()) + " as it is in full update");
                continue;
            }
            if (assuredMessage) {
                if (expectedServers != null && expectedServers.contains(dataServerHandler.getServerId())) {
                    dataServerHandler.add(update, sourceHandler);
                    continue;
                }
                if (notAssuredUpdate == null) {
                    notAssuredUpdate = new NotAssuredUpdateMsg(update);
                }
                dataServerHandler.add(notAssuredUpdate, sourceHandler);
                continue;
            }
            dataServerHandler.add(update, sourceHandler);
        }
        for (MessageHandler messageHandler : this.otherHandlers) {
            messageHandler.add(update, sourceHandler);
        }
    }

    private PreparedAssuredInfo processSafeReadUpdateMsg(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        ChangeNumber cn = update.getChangeNumber();
        byte groupId = this.replicationServer.getGroupId();
        byte sourceGroupId = sourceHandler.getGroupId();
        ArrayList<Integer> expectedServers = new ArrayList<Integer>();
        ArrayList<Integer> wrongStatusServers = new ArrayList<Integer>();
        if (sourceGroupId == groupId) {
            if (sourceHandler.isDataServer()) {
                for (ReplicationServerHandler replicationServerHandler : this.replicationServers.values()) {
                    if (replicationServerHandler.getGroupId() != groupId || this.generationId <= 0L || this.generationId != replicationServerHandler.getGenerationId()) continue;
                    expectedServers.add(replicationServerHandler.getServerId());
                }
            }
            for (DataServerHandler dataServerHandler : this.directoryServers.values()) {
                if (dataServerHandler == sourceHandler || dataServerHandler.getGroupId() != groupId) continue;
                ServerStatus serverStatus = dataServerHandler.getStatus();
                if (serverStatus == ServerStatus.NORMAL_STATUS) {
                    expectedServers.add(dataServerHandler.getServerId());
                    continue;
                }
                if (serverStatus != ServerStatus.DEGRADED_STATUS) continue;
                wrongStatusServers.add(dataServerHandler.getServerId());
            }
        }
        PreparedAssuredInfo preparedAssuredInfo = new PreparedAssuredInfo();
        if (expectedServers.size() > 0) {
            preparedAssuredInfo.expectedAcksInfo = new SafeReadExpectedAcksInfo(cn, sourceHandler, expectedServers, wrongStatusServers);
            preparedAssuredInfo.expectedServers = expectedServers;
        }
        if (preparedAssuredInfo.expectedServers == null) {
            sourceHandler.send(new AckMsg(cn));
        }
        return preparedAssuredInfo;
    }

    private PreparedAssuredInfo processSafeDataUpdateMsg(UpdateMsg update, ServerHandler sourceHandler) throws IOException {
        ChangeNumber cn = update.getChangeNumber();
        boolean interestedInAcks = false;
        byte safeDataLevel = update.getSafeDataLevel();
        byte groupId = this.replicationServer.getGroupId();
        byte sourceGroupId = sourceHandler.getGroupId();
        if (safeDataLevel < 1) {
            Message errorMsg = ReplicationMessages.ERR_UNKNOWN_ASSURED_SAFE_DATA_LEVEL.get(Integer.toString(this.replicationServer.getServerId()), Byte.toString(safeDataLevel), this.baseDn, update.toString());
            ErrorLogger.logError(errorMsg);
        } else if (sourceGroupId == groupId && this.generationId > 0L && this.generationId == sourceHandler.getGenerationId()) {
            if (sourceHandler.isDataServer()) {
                if (safeDataLevel == 1) {
                    sourceHandler.send(new AckMsg(cn));
                } else {
                    interestedInAcks = true;
                }
            } else if (safeDataLevel > 1) {
                sourceHandler.send(new AckMsg(cn));
            }
        }
        ArrayList<Integer> expectedServers = new ArrayList<Integer>();
        if (interestedInAcks && sourceHandler.isDataServer()) {
            for (ReplicationServerHandler handler : this.replicationServers.values()) {
                if (handler.getGroupId() != groupId || this.generationId <= 0L || this.generationId != handler.getGenerationId()) continue;
                expectedServers.add(handler.getServerId());
            }
        }
        PreparedAssuredInfo preparedAssuredInfo = new PreparedAssuredInfo();
        int nExpectedServers = expectedServers.size();
        if (interestedInAcks) {
            if (nExpectedServers > 0) {
                byte sdl = update.getSafeDataLevel();
                int neededAdditionalServers = sdl - 1;
                byte finalSdl = nExpectedServers >= neededAdditionalServers ? (byte)sdl : (byte)(nExpectedServers + 1);
                preparedAssuredInfo.expectedAcksInfo = new SafeDataExpectedAcksInfo(cn, sourceHandler, finalSdl, expectedServers);
                preparedAssuredInfo.expectedServers = expectedServers;
            } else {
                sourceHandler.send(new AckMsg(cn));
            }
        }
        return preparedAssuredInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAck(AckMsg ack, ServerHandler ackingServer) {
        ChangeNumber cn = ack.getChangeNumber();
        ExpectedAcksInfo expectedAcksInfo = this.waitingAcks.get(cn);
        if (expectedAcksInfo != null) {
            ExpectedAcksInfo expectedAcksInfo2 = expectedAcksInfo;
            synchronized (expectedAcksInfo2) {
                if (expectedAcksInfo.isCompleted()) {
                    return;
                }
                if (expectedAcksInfo.processReceivedAck(ackingServer, ack)) {
                    this.waitingAcks.remove(cn);
                    AckMsg finalAck = expectedAcksInfo.createAck(false);
                    ServerHandler origServer = expectedAcksInfo.getRequesterServer();
                    try {
                        origServer.send(finalAck);
                    }
                    catch (IOException e) {
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(ReplicationMessages.ERR_RS_ERROR_SENDING_ACK.get(Integer.toString(this.replicationServer.getServerId()), Integer.toString(origServer.getServerId()), cn.toString(), this.baseDn));
                        mb.append(StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(mb.toMessage());
                        this.stopServer(origServer, false);
                    }
                    expectedAcksInfo.completed();
                }
            }
        }
    }

    public void stopReplicationServers(Collection<String> replServers) {
        for (ReplicationServerHandler handler : this.replicationServers.values()) {
            if (!replServers.contains(handler.getServerAddressURL())) continue;
            this.stopServer(handler, false);
        }
    }

    public void stopAllServers(boolean shutdown) {
        for (ReplicationServerHandler replicationServerHandler : this.replicationServers.values()) {
            this.stopServer(replicationServerHandler, shutdown);
        }
        for (DataServerHandler dataServerHandler : this.directoryServers.values()) {
            this.stopServer(dataServerHandler, shutdown);
        }
    }

    public boolean checkForDuplicateDS(DataServerHandler handler) {
        if (this.directoryServers.containsKey(handler.getServerId())) {
            Message message = ReplicationMessages.ERR_DUPLICATE_SERVER_ID.get(this.replicationServer.getMonitorInstanceName(), this.directoryServers.get(handler.getServerId()).toString(), handler.toString(), handler.getServerId());
            ErrorLogger.logError(message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer(ServerHandler handler, boolean shutdown) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " domain=" + this + " stopServer() on the server handler " + handler.getMonitorInstanceName());
        }
        if (!handler.engageShutdown()) {
            if (!shutdown) {
                try {
                    this.lock();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                if (this.directoryServers.size() + this.replicationServers.size() == 1) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " remote server " + handler.getMonitorInstanceName() + " is " + "the last RS/DS to be stopped: stopping monitoring publisher");
                    }
                    this.stopMonitoringPublisher();
                }
                if (handler.isReplicationServer()) {
                    if (this.replicationServers.containsKey(handler.getServerId())) {
                        this.unregisterServerHandler(handler);
                        handler.shutdown();
                        this.mayResetGenerationId();
                        if (!shutdown) {
                            this.buildAndSendTopoInfoToDSs(null);
                        }
                    }
                } else if (this.directoryServers.containsKey(handler.getServerId())) {
                    if (this.directoryServers.size() == 1) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " remote server " + handler.getMonitorInstanceName() + " is the last DS to be stopped: stopping status analyzer");
                        }
                        this.stopStatusAnalyzer();
                    }
                    this.unregisterServerHandler(handler);
                    handler.shutdown();
                    this.mayResetGenerationId();
                    if (!shutdown) {
                        this.buildAndSendTopoInfoToRSs();
                        this.buildAndSendTopoInfoToDSs(null);
                    }
                } else if (this.otherHandlers.contains(handler)) {
                    this.unRegisterHandler(handler);
                    handler.shutdown();
                }
            }
            catch (Exception e) {
                ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            }
            finally {
                if (!shutdown) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer(MessageHandler handler) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " domain=" + this + " stopServer() on the message handler " + handler.getMonitorInstanceName());
        }
        if (!handler.engageShutdown()) {
            try {
                this.lock();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                if (this.otherHandlers.contains(handler)) {
                    this.unRegisterHandler(handler);
                    handler.shutdown();
                }
            }
            catch (Exception e) {
                ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            }
            finally {
                this.release();
            }
        }
    }

    private void unregisterServerHandler(ServerHandler handler) {
        if (handler.isReplicationServer()) {
            this.replicationServers.remove(handler.getServerId());
        } else {
            this.directoryServers.remove(handler.getServerId());
        }
    }

    private void mayResetGenerationId() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId generationIdSavedStatus=" + this.generationIdSavedStatus);
        }
        boolean lDAPServersConnectedInTheTopology = false;
        if (this.directoryServers.isEmpty()) {
            for (ReplicationServerHandler rsh : this.replicationServers.values()) {
                if (this.generationId != rsh.getGenerationId()) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId skip RS" + rsh.getMonitorInstanceName() + " that has different genId");
                    continue;
                }
                if (!rsh.hasRemoteLDAPServers()) continue;
                lDAPServersConnectedInTheTopology = true;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " mayResetGenerationId RS" + rsh.getMonitorInstanceName() + " has servers connected to it - will not reset generationId");
                }
                break;
            }
        } else {
            lDAPServersConnectedInTheTopology = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServer.getMonitorInstanceName() + " for " + this.baseDn + " " + " has servers connected to it - will not reset generationId");
            }
        }
        if (!lDAPServersConnectedInTheTopology && !this.generationIdSavedStatus && this.generationId != -1L) {
            this.changeGenerationId(-1L, false);
        }
    }

    public boolean checkForDuplicateRS(ReplicationServerHandler handler) throws DirectoryException {
        ReplicationServerHandler oldHandler = this.replicationServers.get(handler.getServerId());
        if (oldHandler != null) {
            if (oldHandler.getServerAddressURL().equals(handler.getServerAddressURL())) {
                return false;
            }
            Message message = ReplicationMessages.ERR_DUPLICATE_REPLICATION_SERVER_ID.get(this.replicationServer.getMonitorInstanceName(), oldHandler.getServerAddressURL(), handler.getServerAddressURL(), handler.getServerId());
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return true;
    }

    public UpdateMsg take(ServerHandler handler) {
        UpdateMsg msg = handler.take();
        return msg;
    }

    public Set<String> getChangelogs() {
        LinkedHashSet<String> mySet = new LinkedHashSet<String>();
        for (ReplicationServerHandler handler : this.replicationServers.values()) {
            mySet.add(handler.getServerAddressURL());
        }
        return mySet;
    }

    public Set<Integer> getServers() {
        return this.sourceDbHandlers.keySet();
    }

    public List<String> getConnectedLDAPservers() {
        ArrayList<String> mySet = new ArrayList<String>(0);
        for (DataServerHandler handler : this.directoryServers.values()) {
            mySet.add(String.valueOf(handler.getServerId()));
        }
        return mySet;
    }

    public ReplicationIterator getChangelogIterator(int serverId, ChangeNumber changeNumber) {
        ReplicationIterator it;
        DbHandler handler = this.sourceDbHandlers.get(serverId);
        if (handler == null) {
            return null;
        }
        try {
            it = handler.generateIterator(changeNumber);
        }
        catch (Exception e) {
            return null;
        }
        if (!it.next()) {
            it.releaseCursor();
            return null;
        }
        return it;
    }

    public int getCount(int serverId, ChangeNumber from, ChangeNumber to) {
        DbHandler handler = this.sourceDbHandlers.get(serverId);
        if (handler == null) {
            return 0;
        }
        return handler.getCount(from, to);
    }

    public long getChangesCount() {
        long entryCount = 0L;
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            entryCount += dbHandler.getChangesCount();
        }
        return entryCount;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbHandler(int serverId, DbHandler dbHandler) throws DatabaseException {
        Map<Integer, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            this.sourceDbHandlers.put(serverId, dbHandler);
        }
    }

    private List<ServerHandler> getDestinationServers(RoutableMsg msg, ServerHandler senderHandler) {
        ArrayList<ServerHandler> servers;
        block4: {
            block6: {
                block5: {
                    servers = new ArrayList<ServerHandler>();
                    if (msg.getDestination() == -3) break block4;
                    if (msg.getDestination() != -2) break block5;
                    if (!senderHandler.isReplicationServer()) {
                        for (ReplicationServerHandler rsh : this.replicationServers.values()) {
                            if (!rsh.hasRemoteLDAPServers()) continue;
                            servers.add(rsh);
                        }
                    }
                    for (DataServerHandler destinationHandler : this.directoryServers.values()) {
                        if (destinationHandler == senderHandler) continue;
                        servers.add(destinationHandler);
                    }
                    break block4;
                }
                DataServerHandler destinationHandler = this.directoryServers.get(msg.getDestination());
                if (destinationHandler == null) break block6;
                servers.add(destinationHandler);
                break block4;
            }
            if (!senderHandler.isDataServer()) break block4;
            for (ReplicationServerHandler h : this.replicationServers.values()) {
                if (!h.isRemoteLDAPServer(msg.getDestination())) continue;
                servers.add(h);
            }
        }
        return servers;
    }

    public void process(RoutableMsg msg, ServerHandler senderHandler) {
        if (!(msg instanceof InitializeRequestMsg || msg instanceof InitializeTargetMsg || msg instanceof InitializeRcvAckMsg || msg instanceof EntryMsg || msg instanceof DoneMsg || msg.getDestination() != this.replicationServer.getServerId())) {
            if (msg instanceof ErrorMsg) {
                ErrorMsg errorMsg = (ErrorMsg)msg;
                ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
            } else if (msg instanceof MonitorRequestMsg) {
                if (senderHandler.isDataServer()) {
                    MonitorMsg monitorMsg = this.createGlobalTopologyMonitorMsg(msg.getDestination(), msg.getSenderID(), this.monitorData);
                    if (monitorMsg != null) {
                        try {
                            senderHandler.send(monitorMsg);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                MonitorMsg monitorMsg = this.createLocalTopologyMonitorMsg(msg.getDestination(), msg.getSenderID());
                if (monitorMsg != null) {
                    try {
                        senderHandler.send(monitorMsg);
                    }
                    catch (Exception e) {
                        ErrorLogger.logError(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get(Integer.toString(msg.getDestination())));
                    }
                }
            } else if (msg instanceof MonitorMsg) {
                MonitorMsg monitorMsg = (MonitorMsg)msg;
                this.receivesMonitorDataResponse(monitorMsg, senderHandler.getServerId());
            } else {
                ErrorLogger.logError(ReplicationMessages.NOTE_ERR_ROUTING_TO_SERVER.get(msg.getClass().getCanonicalName()));
                MessageBuilder mb1 = new MessageBuilder();
                mb1.append(ReplicationMessages.NOTE_ERR_ROUTING_TO_SERVER.get(msg.getClass().getCanonicalName()));
                mb1.append("serverID:").append(msg.getDestination());
                ErrorMsg errMsg = new ErrorMsg(msg.getSenderID(), mb1.toMessage());
                try {
                    senderHandler.send(errMsg);
                }
                catch (IOException ioe1) {
                    // empty catch block
                }
            }
            return;
        }
        List<ServerHandler> servers = this.getDestinationServers(msg, senderHandler);
        if (servers.isEmpty()) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get(this.baseDn, Integer.toString(msg.getDestination())));
            mb.append(" In Replication Server=").append(this.replicationServer.getMonitorInstanceName());
            mb.append(" unroutable message =").append(msg.getClass().getSimpleName());
            mb.append(" Details:routing table is empty");
            ErrorMsg errMsg = new ErrorMsg(this.replicationServer.getServerId(), msg.getSenderID(), mb.toMessage());
            ErrorLogger.logError(mb.toMessage());
            try {
                senderHandler.send(errMsg);
            }
            catch (IOException ioe) {
                MessageBuilder mb2 = new MessageBuilder();
                mb2.append(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_ERROR.get(this.toString()));
                mb2.append(StaticUtils.stackTraceToSingleLineString(ioe));
                ErrorLogger.logError(mb2.toMessage());
                this.stopServer(senderHandler, false);
            }
        } else {
            for (ServerHandler targetHandler : servers) {
                try {
                    targetHandler.send(msg);
                }
                catch (IOException ioe) {
                    MessageBuilder mb1 = new MessageBuilder();
                    mb1.append(ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.get(this.baseDn, Integer.toString(msg.getDestination())));
                    mb1.append(" unroutable message =" + msg.getClass().getSimpleName());
                    mb1.append(" Details: " + ioe.getLocalizedMessage());
                    ErrorMsg errMsg = new ErrorMsg(msg.getSenderID(), mb1.toMessage());
                    ErrorLogger.logError(mb1.toMessage());
                    try {
                        senderHandler.send(errMsg);
                    }
                    catch (IOException ioe1) {
                        this.stopServer(senderHandler, false);
                        this.stopServer(targetHandler, false);
                    }
                }
            }
        }
    }

    public MonitorMsg createGlobalTopologyMonitorMsg(int sender, int destination, MonitorData monitorData) {
        int replicaId;
        MonitorMsg returnMsg = new MonitorMsg(sender, destination);
        returnMsg.setReplServerDbState(this.getDbServerState());
        Iterator<Integer> it = monitorData.ldapIterator();
        while (it.hasNext()) {
            replicaId = it.next();
            returnMsg.setServerState(replicaId, monitorData.getLDAPServerState(replicaId), monitorData.getApproxFirstMissingDate(replicaId), true);
        }
        it = monitorData.rsIterator();
        while (it.hasNext()) {
            replicaId = it.next();
            returnMsg.setServerState(replicaId, monitorData.getRSStates(replicaId), monitorData.getRSApproxFirstMissingDate(replicaId), false);
        }
        return returnMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorMsg createLocalTopologyMonitorMsg(int sender, int destination) {
        try {
            this.lock();
        }
        catch (InterruptedException e) {
            return null;
        }
        try {
            MonitorMsg monitorMsg = new MonitorMsg(sender, destination);
            for (DataServerHandler lsh : this.directoryServers.values()) {
                monitorMsg.setServerState(lsh.getServerId(), lsh.getServerState(), lsh.getApproxFirstMissingDate(), true);
            }
            for (ReplicationServerHandler rsh : this.replicationServers.values()) {
                monitorMsg.setServerState(rsh.getServerId(), rsh.getServerState(), rsh.getApproxFirstMissingDate(), false);
            }
            monitorMsg.setReplServerDbState(this.getDbServerState());
            MonitorMsg monitorMsg2 = monitorMsg;
            return monitorMsg2;
        }
        finally {
            this.release();
        }
    }

    public void shutdown() {
        DirectoryServer.deregisterMonitorProvider(this);
        this.assuredTimeoutTimer.cancel();
        this.stopAllServers(true);
        this.stopDbHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDbHandlers() {
        Map<Integer, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                dbHandler.shutdown();
            }
            this.sourceDbHandlers.clear();
        }
    }

    public ServerState getDbServerState() {
        ServerState serverState = new ServerState();
        for (DbHandler db : this.sourceDbHandlers.values()) {
            serverState.update(db.getLastChange());
        }
        return serverState;
    }

    public String toString() {
        return "ReplicationServerDomain " + this.baseDn;
    }

    public void buildAndSendTopoInfoToDSs(ServerHandler notThisOne) {
        block4: for (DataServerHandler handler : this.directoryServers.values()) {
            if (notThisOne != null && handler == notThisOne) continue;
            for (int i = 1; i <= 2; ++i) {
                block7: {
                    if (!handler.shuttingDown() && handler.getStatus() != ServerStatus.NOT_CONNECTED_STATUS) {
                        TopologyMsg topoMsg = this.createTopologyMsgForDS(handler.getServerId());
                        try {
                            handler.sendTopoInfo(topoMsg);
                            continue block4;
                        }
                        catch (IOException e) {
                            if (i != 2) break block7;
                            Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_TOPO_INFO.get(this.baseDn, "directory", Integer.toString(handler.getServerId()), e.getMessage());
                            ErrorLogger.logError(message);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void buildAndSendTopoInfoToRSs() {
        TopologyMsg topoMsg = this.createTopologyMsgForRS();
        block4: for (ReplicationServerHandler handler : this.replicationServers.values()) {
            for (int i = 1; i <= 2; ++i) {
                block7: {
                    if (!handler.shuttingDown() && handler.getStatus() != ServerStatus.NOT_CONNECTED_STATUS) {
                        try {
                            handler.sendTopoInfo(topoMsg);
                            continue block4;
                        }
                        catch (IOException e) {
                            if (i != 2) break block7;
                            Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_TOPO_INFO.get(this.baseDn, "replication", Integer.toString(handler.getServerId()), e.getMessage());
                            ErrorLogger.logError(message);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public TopologyMsg createTopologyMsgForRS() {
        ArrayList<DSInfo> dsInfos = new ArrayList<DSInfo>();
        for (DataServerHandler serverHandler : this.directoryServers.values()) {
            dsInfos.add(serverHandler.toDSInfo());
        }
        ArrayList<RSInfo> rsInfos = new ArrayList<RSInfo>();
        RSInfo localRSInfo = new RSInfo(this.replicationServer.getServerId(), this.replicationServer.getServerURL(), this.generationId, this.replicationServer.getGroupId(), this.replicationServer.getWeight());
        rsInfos.add(localRSInfo);
        return new TopologyMsg(dsInfos, rsInfos);
    }

    public TopologyMsg createTopologyMsgForDS(int destDsId) {
        ArrayList<DSInfo> dsInfos = new ArrayList<DSInfo>();
        ArrayList<RSInfo> rsInfos = new ArrayList<RSInfo>();
        for (DataServerHandler serverHandler : this.directoryServers.values()) {
            if (serverHandler.getServerId() == destDsId) continue;
            dsInfos.add(serverHandler.toDSInfo());
        }
        RSInfo localRSInfo = new RSInfo(this.replicationServer.getServerId(), this.replicationServer.getServerURL(), this.generationId, this.replicationServer.getGroupId(), this.replicationServer.getWeight());
        rsInfos.add(localRSInfo);
        for (ReplicationServerHandler serverHandler : this.replicationServers.values()) {
            rsInfos.add(serverHandler.toRSInfo());
            serverHandler.addDSInfos(dsInfos);
        }
        return new TopologyMsg(dsInfos, rsInfos);
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public boolean getGenerationIdSavedStatus() {
        return this.generationIdSavedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initGenerationID(long generationId) {
        Object object = this.generationIDLock;
        synchronized (object) {
            this.generationId = generationId;
            this.generationIdSavedStatus = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long changeGenerationId(long generationId, boolean savedStatus) {
        Object object = this.generationIDLock;
        synchronized (object) {
            long oldGenerationId = this.generationId;
            if (this.generationId != generationId) {
                this.clearDbs();
                this.generationId = generationId;
                this.generationIdSavedStatus = savedStatus;
            }
            return oldGenerationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetGenerationId(ServerHandler senderHandler, ResetGenerationIdMsg genIdMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this + " Receiving ResetGenerationIdMsg from " + senderHandler.getServerId() + " for baseDn " + this.baseDn + ":\n" + genIdMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            long newGenId = genIdMsg.getGenerationId();
            if (newGenId != this.generationId) {
                this.changeGenerationId(newGenId, false);
            } else if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this + " Reset generation id requested for baseDn " + this.baseDn + " but generation id was already " + this.generationId + ":\n" + genIdMsg);
            }
            for (ServerHandler serverHandler : this.replicationServers.values()) {
                try {
                    serverHandler.setGenerationId(newGenId);
                    if (!senderHandler.isDataServer()) continue;
                    serverHandler.send(genIdMsg);
                }
                catch (IOException e) {
                    ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_FORWARDING_RESET_GEN_ID.get(this.baseDn, e.getMessage()));
                }
            }
            for (DataServerHandler dataServerHandler : this.directoryServers.values()) {
                try {
                    dataServerHandler.changeStatusForResetGenId(newGenId);
                }
                catch (IOException e) {
                    ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_CHANGING_STATUS_AFTER_RESET_GEN_ID.get(this.baseDn, Integer.toString(dataServerHandler.getServerId()), e.getMessage()));
                }
            }
            this.buildAndSendTopoInfoToDSs(null);
            this.buildAndSendTopoInfoToRSs();
            Message message = ReplicationMessages.NOTE_RESET_GENERATION_ID.get(this.baseDn, newGenId);
            ErrorLogger.logError(message);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewStatus(DataServerHandler senderHandler, ChangeStatusMsg csMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving ChangeStatusMsg from " + senderHandler.getServerId() + " for baseDn " + this.baseDn + ":\n" + csMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            ServerStatus newStatus = senderHandler.processNewStatus(csMsg);
            if (newStatus == ServerStatus.INVALID_STATUS) {
                return;
            }
            this.buildAndSendTopoInfoToDSs(senderHandler);
            this.buildAndSendTopoInfoToRSs();
            Message message = ReplicationMessages.NOTE_DIRECTORY_SERVER_CHANGED_STATUS.get(senderHandler.getServerId(), this.baseDn, newStatus.toString());
            ErrorLogger.logError(message);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeStatusFromStatusAnalyzer(DataServerHandler serverHandler, StatusMachineEvent event) {
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Status analyzer for domain " + this.baseDn + " has been interrupted when" + " trying to acquire domain lock for changing the status" + " of DS " + serverHandler.getServerId());
            }
            return true;
        }
        try {
            ServerStatus newStatus = ServerStatus.INVALID_STATUS;
            ServerStatus oldStatus = serverHandler.getStatus();
            try {
                newStatus = serverHandler.changeStatusFromStatusAnalyzer(event);
            }
            catch (IOException e) {
                ErrorLogger.logError(ReplicationMessages.ERR_EXCEPTION_CHANGING_STATUS_FROM_STATUS_ANALYZER.get(this.baseDn, Integer.toString(serverHandler.getServerId()), e.getMessage()));
            }
            if (newStatus == ServerStatus.INVALID_STATUS || newStatus == oldStatus) {
                boolean bl = false;
                return bl;
            }
            this.buildAndSendTopoInfoToDSs(serverHandler);
            this.buildAndSendTopoInfoToRSs();
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
        }
        finally {
            this.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDbs() {
        Map<Integer, DbHandler> map = this.sourceDbHandlers;
        synchronized (map) {
            for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
                try {
                    dbHandler.clear();
                }
                catch (Exception e) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(dbHandler.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
                    ErrorLogger.logError(mb.toMessage());
                }
            }
            this.stopDbHandlers();
        }
        try {
            this.replicationServer.clearGenerationId(this.baseDn);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw("Exception caught while clearing generationId:" + e.getLocalizedMessage(), new Object[0]));
        }
    }

    public boolean isDegradedDueToGenerationId(int serverId) {
        ServerHandler handler;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " isDegraded serverId=" + serverId + " given local generation Id=" + this.generationId);
        }
        if ((handler = (ServerHandler)this.replicationServers.get(serverId)) == null && (handler = (ServerHandler)this.directoryServers.get(serverId)) == null) {
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " baseDN=" + this.baseDn + " Compute degradation of serverId=" + serverId + " LS server generation Id=" + handler.getGenerationId());
        }
        return handler.getGenerationId() != this.generationId;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTopoInfoFromRS(TopologyMsg topoMsg, ReplicationServerHandler handler, boolean allowResetGenId) throws IOException, DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In RS " + this.getReplicationServer().getServerId() + " Receiving TopologyMsg from " + handler.getServerId() + " for baseDn " + this.baseDn + ":\n" + topoMsg);
        }
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            handler.processTopoInfoFromRS(topoMsg);
            if (allowResetGenId) {
                this.mayResetGenerationId();
                if (this.generationId < 0L) {
                    this.generationId = handler.getGenerationId();
                }
            }
            if (this.generationId > 0L && this.generationId != handler.getGenerationId()) {
                Message message = ReplicationMessages.WARN_BAD_GENERATION_ID_FROM_RS.get(handler.getServerId(), handler.session.getReadableRemoteAddress(), handler.getGenerationId(), this.baseDn, this.getReplicationServer().getServerId(), this.generationId);
                ErrorLogger.logError(message);
                ErrorMsg errorMsg = new ErrorMsg(this.getReplicationServer().getServerId(), handler.getServerId(), message);
                handler.send(errorMsg);
            }
            this.buildAndSendTopoInfoToDSs(null);
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
        }
        finally {
            this.release();
        }
    }

    MonitorData getDomainMonitorData() {
        return this.monitorData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MonitorData computeDomainMonitorData() throws InterruptedException {
        Object object = this.pendingMonitorLock;
        synchronized (object) {
            if (this.monitorDataLastBuildDate + 500L < TimeThread.getTime()) {
                Object object2;
                try {
                    object2 = this.pendingMonitorDataLock;
                    synchronized (object2) {
                        this.pendingMonitorDataServerIDs.clear();
                        this.pendingMonitorData = new MonitorData();
                        this.initializePendingMonitorData();
                        for (ReplicationServerHandler rs : this.replicationServers.values()) {
                            int serverId = rs.getServerId();
                            MonitorRequestMsg msg = new MonitorRequestMsg(this.replicationServer.getServerId(), serverId);
                            try {
                                rs.send(msg);
                                this.pendingMonitorDataServerIDs.add(serverId);
                            }
                            catch (IOException e) {
                                Message message = ReplicationMessages.ERR_SENDING_REMOTE_MONITOR_DATA_REQUEST.get(this.baseDn, serverId, e.getMessage());
                                ErrorLogger.logError(message);
                            }
                        }
                        this.pendingMonitorDataLatch = new CountDownLatch(this.pendingMonitorDataServerIDs.size());
                    }
                    this.pendingMonitorDataLatch.await(5L, TimeUnit.SECONDS);
                    object2 = this.pendingMonitorDataLock;
                    synchronized (object2) {
                        Iterator<Object> i$ = this.monitorDataLateServers.iterator();
                        while (i$.hasNext()) {
                            int serverId = (Integer)i$.next();
                            if (this.pendingMonitorDataServerIDs.contains(serverId)) continue;
                            ErrorLogger.logError(ReplicationMessages.NOTE_MONITOR_DATA_RECEIVED.get(this.baseDn, serverId));
                        }
                        i$ = this.pendingMonitorDataServerIDs.iterator();
                        while (i$.hasNext()) {
                            int serverId = (Integer)i$.next();
                            if (this.monitorDataLateServers.contains(serverId)) continue;
                            ErrorLogger.logError(ReplicationMessages.WARN_MISSING_REMOTE_MONITOR_DATA.get(this.baseDn, serverId));
                        }
                        this.monitorDataLateServers.clear();
                        this.monitorDataLateServers.addAll(this.pendingMonitorDataServerIDs);
                    }
                    object2 = this.pendingMonitorDataLock;
                    synchronized (object2) {
                        this.pendingMonitorData.completeComputing();
                        this.monitorData = this.pendingMonitorData;
                        this.monitorDataLastBuildDate = TimeThread.getTime();
                    }
                }
                finally {
                    object2 = this.pendingMonitorDataLock;
                    synchronized (object2) {
                        this.pendingMonitorData = null;
                        this.pendingMonitorDataLatch = null;
                        this.pendingMonitorDataServerIDs.clear();
                    }
                }
            }
        }
        return this.monitorData;
    }

    private void initializePendingMonitorData() {
        for (ServerHandler serverHandler : this.directoryServers.values()) {
            int serverID = serverHandler.getServerId();
            ServerState dsState = serverHandler.getServerState().duplicate();
            ChangeNumber maxcn = dsState.getMaxChangeNumber(serverID);
            if (maxcn == null) {
                maxcn = new ChangeNumber(0L, 0, serverID);
            }
            this.pendingMonitorData.setMaxCN(serverID, maxcn);
            this.pendingMonitorData.setLDAPServerState(serverID, dsState);
            this.pendingMonitorData.setFirstMissingDate(serverID, serverHandler.getApproxFirstMissingDate());
        }
        ServerState dbServerState = this.getDbServerState();
        this.pendingMonitorData.setRSState(this.replicationServer.getServerId(), dbServerState);
        for (int sid : dbServerState) {
            ChangeNumber storedCN = dbServerState.getMaxChangeNumber(sid);
            this.pendingMonitorData.setMaxCN(sid, storedCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivesMonitorDataResponse(MonitorMsg msg, int serverId) {
        Object object = this.pendingMonitorDataLock;
        synchronized (object) {
            if (this.pendingMonitorData == null) {
                ErrorLogger.logError(ReplicationMessages.INFO_IGNORING_REMOTE_MONITOR_DATA.get(this.baseDn, msg.getSenderID()));
                return;
            }
            try {
                ServerState replServerState = msg.getReplServerDbState();
                this.pendingMonitorData.setMaxCNs(replServerState);
                this.pendingMonitorData.setRSState(msg.getSenderID(), replServerState);
                Iterator<Integer> lsidIterator = msg.ldapIterator();
                while (lsidIterator.hasNext()) {
                    int sid = lsidIterator.next();
                    ServerState dsServerState = msg.getLDAPServerState(sid);
                    this.pendingMonitorData.setMaxCNs(dsServerState);
                    this.pendingMonitorData.setLDAPServerState(sid, dsServerState);
                    this.pendingMonitorData.setFirstMissingDate(sid, msg.getLDAPApproxFirstMissingDate(sid));
                }
                Iterator<Integer> rsidIterator = msg.rsIterator();
                while (rsidIterator.hasNext()) {
                    Long newfmd;
                    int rsid = rsidIterator.next();
                    if (rsid == this.replicationServer.getServerId()) {
                        for (ServerHandler serverHandler : this.directoryServers.values()) {
                            int connectedlsid = serverHandler.getServerId();
                            newfmd = msg.getRSApproxFirstMissingDate(rsid);
                            this.pendingMonitorData.setFirstMissingDate(connectedlsid, newfmd);
                        }
                        continue;
                    }
                    ReplicationServerHandler rsjHdr = this.replicationServers.get(rsid);
                    if (rsjHdr == null) continue;
                    for (int remotelsid : rsjHdr.getConnectedDirectoryServerIds()) {
                        newfmd = msg.getRSApproxFirstMissingDate(rsid);
                        this.pendingMonitorData.setFirstMissingDate(remotelsid, newfmd);
                    }
                }
            }
            catch (RuntimeException e) {
                ErrorLogger.logError(ReplicationMessages.ERR_PROCESSING_REMOTE_MONITOR_DATA.get(e.getMessage() + StaticUtils.stackTraceToSingleLineString(e)));
            }
            finally {
                if (this.pendingMonitorDataServerIDs.remove(serverId)) {
                    this.pendingMonitorDataLatch.countDown();
                }
            }
        }
    }

    public void setPurgeDelay(long delay) {
        for (DbHandler handler : this.sourceDbHandlers.values()) {
            handler.setPurgeDelay(delay);
        }
    }

    public Map<Integer, DataServerHandler> getConnectedDSs() {
        return this.directoryServers;
    }

    public Map<Integer, ReplicationServerHandler> getConnectedRSs() {
        return this.replicationServers;
    }

    public boolean hasLock() {
        return this.lock.getHoldCount() > 0;
    }

    public void lock() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public void release() {
        this.lock.unlock();
    }

    public boolean tryLock(long timeout) throws InterruptedException {
        return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    public void startStatusAnalyzer() {
        int degradedStatusThreshold;
        if (this.statusAnalyzer == null && (degradedStatusThreshold = this.replicationServer.getDegradedStatusThreshold()) > 0) {
            this.statusAnalyzer = new StatusAnalyzer(this, degradedStatusThreshold);
            this.statusAnalyzer.start();
        }
    }

    public void stopStatusAnalyzer() {
        if (this.statusAnalyzer != null) {
            this.statusAnalyzer.shutdown();
            this.statusAnalyzer.waitForShutdown();
            this.statusAnalyzer = null;
        }
    }

    public boolean isRunningStatusAnalyzer() {
        return this.statusAnalyzer != null;
    }

    public void updateStatusAnalyzer(int degradedStatusThreshold) {
        if (this.statusAnalyzer != null) {
            this.statusAnalyzer.setDegradedStatusThreshold(degradedStatusThreshold);
        }
    }

    public void startMonitoringPublisher() {
        long period;
        if (this.monitoringPublisher == null && (period = this.replicationServer.getMonitoringPublisherPeriod()) > 0L) {
            this.monitoringPublisher = new MonitoringPublisher(this, period);
            this.monitoringPublisher.start();
        }
    }

    public void stopMonitoringPublisher() {
        if (this.monitoringPublisher != null) {
            this.monitoringPublisher.shutdown();
            this.monitoringPublisher.waitForShutdown();
            this.monitoringPublisher = null;
        }
    }

    public boolean isRunningMonitoringPublisher() {
        return this.monitoringPublisher != null;
    }

    public void updateMonitoringPublisher(long period) {
        if (this.monitoringPublisher != null) {
            this.monitoringPublisher.setPeriod(period);
        }
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuraiton) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Replication server RS(" + this.replicationServer.getServerId() + ") " + this.replicationServer.getServerURL() + ",cn=" + this.baseDn.replace(',', '_').replace('=', '_') + ",cn=Replication";
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(Attributes.create("replication-server-id", String.valueOf(this.replicationServer.getServerId())));
        attributes.add(Attributes.create("replication-server-port", String.valueOf(this.replicationServer.getReplicationPort())));
        AttributeBuilder builder = new AttributeBuilder("domain-name");
        builder.add(this.baseDn);
        attributes.add(builder.toAttribute());
        builder = new AttributeBuilder("generation-id");
        builder.add(this.baseDn + " " + this.generationId);
        attributes.add(builder.toAttribute());
        MonitorData md = this.getDomainMonitorData();
        long missingChanges = md.getMissingChangesRS(this.replicationServer.getServerId());
        attributes.add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
        return attributes;
    }

    public void registerHandler(MessageHandler handler) {
        this.otherHandlers.add(handler);
    }

    public boolean unRegisterHandler(MessageHandler handler) {
        return this.otherHandlers.remove(handler);
    }

    public ServerState getChangeTimeHeartbeatState() {
        if (this.ctHeartbeatState == null) {
            this.ctHeartbeatState = this.getDbServerState().duplicate();
        }
        return this.ctHeartbeatState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerState getEligibleState(ChangeNumber eligibleCN) {
        ServerState dbState = this.getDbServerState();
        ServerState result = dbState.duplicate();
        if (eligibleCN != null) {
            for (int sid : dbState) {
                DbHandler h = this.sourceDbHandlers.get(sid);
                ChangeNumber mostRecentDbCN = dbState.getMaxChangeNumber(sid);
                try {
                    if (eligibleCN.olderOrEqual(mostRecentDbCN).booleanValue()) {
                        ReplicationIterator ri = null;
                        try {
                            ri = h.generateIterator(eligibleCN);
                            if (ri == null || ri.getChange() == null) continue;
                            ChangeNumber newCN = ri.getChange().getChangeNumber();
                            result.update(newCN);
                            continue;
                        }
                        catch (Exception e) {
                            result.update(new ChangeNumber(0L, 0, sid));
                            continue;
                        }
                        finally {
                            if (ri != null) {
                                ri.releaseCursor();
                            }
                            continue;
                        }
                    }
                    result.update(mostRecentDbCN);
                }
                catch (Exception e) {
                    Message errMessage = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(" " + StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(errMessage);
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this + " getEligibleState() result is " + result);
        }
        return result;
    }

    public ServerState getStartState() {
        ServerState domainStartState = new ServerState();
        for (DbHandler dbHandler : this.sourceDbHandlers.values()) {
            domainStartState.update(dbHandler.getFirstChange());
        }
        return domainStartState;
    }

    public ChangeNumber getEligibleCN() {
        ChangeNumber eligibleCN = null;
        for (DbHandler db : this.sourceDbHandlers.values()) {
            int sid = db.getServerId();
            ChangeNumber heartbeatLastDN = this.getChangeTimeHeartbeatState().getMaxChangeNumber(sid);
            boolean sidConnected = false;
            if (this.directoryServers.containsKey(sid)) {
                sidConnected = true;
            } else {
                for (ReplicationServerHandler rsh : this.replicationServers.values()) {
                    if (!rsh.isRemoteLDAPServer(sid)) continue;
                    sidConnected = true;
                    break;
                }
            }
            if (!sidConnected) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("In Replication Server " + this.replicationServer.getReplicationPort() + " " + this.baseDn + " " + this.replicationServer.getServerId() + " Server " + sid + " is not considered for eligibility ... potentially down");
                continue;
            }
            ChangeNumber changelogLastCN = db.getLastChange();
            if (changelogLastCN != null && (eligibleCN == null || changelogLastCN.newer(eligibleCN))) {
                eligibleCN = changelogLastCN;
            }
            if (heartbeatLastDN == null || eligibleCN != null && !heartbeatLastDN.newer(eligibleCN)) continue;
            eligibleCN = heartbeatLastDN;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In Replication Server " + this.replicationServer.getReplicationPort() + " " + this.baseDn + " " + this.replicationServer.getServerId() + " getEligibleCN() returns result =" + eligibleCN);
        }
        return eligibleCN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeTimeHeartbeatMsg(ServerHandler senderHandler, ChangeTimeHeartbeatMsg msg) {
        try {
            this.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.storeReceivedCTHeartbeat(msg.getChangeNumber());
            if (senderHandler.isDataServer()) {
                for (ReplicationServerHandler rsHandler : this.replicationServers.values()) {
                    try {
                        if (rsHandler.getProtocolVersion() < 3) continue;
                        rsHandler.send(msg);
                    }
                    catch (IOException e) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        ErrorLogger.logError(ReplicationMessages.ERR_CHANGELOG_ERROR_SENDING_MSG.get("Replication Server " + this.replicationServer.getReplicationPort() + " " + this.baseDn + " " + this.replicationServer.getServerId()));
                        this.stopServer(rsHandler, false);
                    }
                }
            }
        }
        finally {
            this.release();
        }
    }

    public void storeReceivedCTHeartbeat(ChangeNumber cn) {
        this.getChangeTimeHeartbeatState().update(cn);
    }

    public long getEligibleCount(ServerState startState, ChangeNumber endCN) {
        long res = 0L;
        ServerState dbState = this.getDbServerState();
        for (int sid : dbState) {
            ChangeNumber startCN = null;
            if (startState.getMaxChangeNumber(sid) != null) {
                startCN = startState.getMaxChangeNumber(sid);
            }
            long sidRes = this.getCount(sid, startCN, endCN);
            if (startCN != null && sidRes > 0L) {
                --sidRes;
            }
            res += sidRes;
        }
        return res;
    }

    public long getEligibleCount(ChangeNumber startCN, ChangeNumber endCN) {
        long res = 0L;
        ServerState dbState = this.getDbServerState();
        for (int sid : dbState) {
            ChangeNumber lStartCN = new ChangeNumber(startCN.getTime(), startCN.getSeqnum(), sid);
            res += (long)this.getCount(sid, lStartCN, endCN);
        }
        return res;
    }

    public long getLatestDomainTrimDate() {
        long latest = 0L;
        for (DbHandler db : this.sourceDbHandlers.values()) {
            if (latest != 0L && latest >= db.getLatestTrimDate()) continue;
            latest = db.getLatestTrimDate();
        }
        return latest;
    }

    private class AssuredTimeoutTask
    extends TimerTask {
        private ChangeNumber cn = null;

        public AssuredTimeoutTask(ChangeNumber cn) {
            this.cn = cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExpectedAcksInfo expectedAcksInfo = (ExpectedAcksInfo)ReplicationServerDomain.this.waitingAcks.get(this.cn);
            if (expectedAcksInfo != null) {
                ExpectedAcksInfo expectedAcksInfo2 = expectedAcksInfo;
                synchronized (expectedAcksInfo2) {
                    if (expectedAcksInfo.isCompleted()) {
                        return;
                    }
                    ReplicationServerDomain.this.waitingAcks.remove(this.cn);
                    AckMsg finalAck = expectedAcksInfo.createAck(true);
                    ServerHandler origServer = expectedAcksInfo.getRequesterServer();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + Integer.toString(ReplicationServerDomain.this.replicationServer.getServerId()) + " for " + ReplicationServerDomain.this.baseDn + ", sending timeout for assured update with change " + " number " + this.cn.toString() + " to server id " + Integer.toString(origServer.getServerId()));
                    }
                    try {
                        origServer.send(finalAck);
                    }
                    catch (IOException e) {
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(ReplicationMessages.ERR_RS_ERROR_SENDING_ACK.get(Integer.toString(ReplicationServerDomain.this.replicationServer.getServerId()), Integer.toString(origServer.getServerId()), this.cn.toString(), ReplicationServerDomain.this.baseDn));
                        mb.append(StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(mb.toMessage());
                        ReplicationServerDomain.this.stopServer(origServer, false);
                    }
                    boolean safeRead = expectedAcksInfo instanceof SafeReadExpectedAcksInfo;
                    if (safeRead) {
                        origServer.incrementAssuredSrReceivedUpdatesTimeout();
                    } else if (origServer.isDataServer()) {
                        origServer.incrementAssuredSdReceivedUpdatesTimeout();
                    }
                    List<Integer> serversInTimeout = expectedAcksInfo.getTimeoutServers();
                    for (Integer serverId : serversInTimeout) {
                        ServerHandler expectedServerInTimeout = (ServerHandler)ReplicationServerDomain.this.directoryServers.get(serverId);
                        if (expectedServerInTimeout != null) {
                            if (!safeRead) continue;
                            expectedServerInTimeout.incrementAssuredSrSentUpdatesTimeout();
                            continue;
                        }
                        expectedServerInTimeout = (ServerHandler)ReplicationServerDomain.this.replicationServers.get(serverId);
                        if (expectedServerInTimeout == null) continue;
                        if (safeRead) {
                            expectedServerInTimeout.incrementAssuredSrSentUpdatesTimeout();
                            continue;
                        }
                        expectedServerInTimeout.incrementAssuredSdSentUpdatesTimeout();
                    }
                    expectedAcksInfo.completed();
                }
            }
        }
    }

    private class PreparedAssuredInfo {
        public List<Integer> expectedServers = null;
        public ExpectedAcksInfo expectedAcksInfo = null;

        private PreparedAssuredInfo() {
        }
    }
}

