/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;

public class MonitoringPublisher
extends DirectoryThread {
    private volatile boolean shutdown = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ReplicationServerDomain replicationServerDomain;
    private volatile long period;
    private volatile boolean done = false;
    private final Object shutdownLock = new Object();

    public MonitoringPublisher(ReplicationServerDomain replicationServerDomain, long period) {
        super("Replication server RS(" + replicationServerDomain.getReplicationServer().getServerId() + ") monitor publisher for domain \"" + replicationServerDomain.getBaseDn() + "\"");
        this.replicationServerDomain = replicationServerDomain;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher starting for dn " + this.replicationServerDomain.getBaseDn());
        }
        try {
            while (!this.shutdown) {
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.shutdown) {
                        this.shutdownLock.wait(this.period);
                    }
                }
                MonitorData monitorData = this.replicationServerDomain.computeDomainMonitorData();
                MonitorMsg monitorMsg = this.replicationServerDomain.createGlobalTopologyMonitorMsg(0, 0, monitorData);
                int localServerId = this.replicationServerDomain.getReplicationServer().getServerId();
                for (ServerHandler serverHandler : this.replicationServerDomain.getConnectedDSs().values()) {
                    monitorMsg.setSenderID(localServerId);
                    monitorMsg.setDestination(serverHandler.getServerId());
                    try {
                        serverHandler.send(monitorMsg);
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (InterruptedException e) {
            TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " has been interrupted while sleeping.");
        }
        this.done = true;
        TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Shutting down monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
            }
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setPeriod(long period) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn() + " changing period value to " + period);
        }
        this.period = period;
    }
}

